/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.immersive;

import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.immersive.TrackedImmersiveData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class TrackedImmersives {
    public static final List<TrackedImmersiveData<?>> TRACKED_IMMERSIVES = new ArrayList();

    public static void tick(MinecraftServer server) {
        Iterator<TrackedImmersiveData<?>> dataIterator = TRACKED_IMMERSIVES.iterator();
        while (dataIterator.hasNext()) {
            TrackedImmersiveData<?> data2 = dataIterator.next();
            class_3222 player = server.method_3760().method_14602(data2.playerUUID);
            if (player != null && data2.validForPlayer(player)) continue;
            if (player != null) {
                data2.getHandler().onStopTracking(player, data2.getPos().iterator().next());
            }
            dataIterator.remove();
        }
        TRACKED_IMMERSIVES.forEach(data -> {
            class_3222 player = server.method_3760().method_14602(data.playerUUID);
            if (data.shouldSync(player)) {
                TrackedImmersives.syncDataToClient(player, data);
            }
        });
    }

    public static void maybeTrackImmersive(class_3222 player, class_2338 pos) {
        for (ImmersiveHandler<?> handler : ImmersiveHandlers.HANDLERS) {
            if (handler.clientAuthoritative() || !handler.enabledInConfig((class_1657)player) || !Util.isValidBlocks(handler, pos, player.method_37908())) continue;
            TrackedImmersives.trackImmersive(player, handler, pos);
            return;
        }
    }

    public static void clearForPlayer(class_3222 player) {
        Iterator<TrackedImmersiveData<?>> dataIterator = TRACKED_IMMERSIVES.iterator();
        while (dataIterator.hasNext()) {
            TrackedImmersiveData<?> data = dataIterator.next();
            if (!data.playerUUID.equals(player.method_5667())) continue;
            data.getHandler().onStopTracking(player, data.getPos().iterator().next());
            dataIterator.remove();
        }
    }

    private static void trackImmersive(class_3222 player, ImmersiveHandler<?> handler, class_2338 pos) {
        if (TRACKED_IMMERSIVES.stream().anyMatch(data -> Util.getValidBlocks(data.getHandler(), data.getPos().iterator().next(), player.method_37908()).contains(pos) && data.playerUUID.equals(player.method_5667()))) {
            return;
        }
        TrackedImmersiveData data2 = new TrackedImmersiveData(player.method_5667(), Util.getValidBlocks(handler, pos, player.method_37908()), handler, player.method_37908());
        TRACKED_IMMERSIVES.add(data2);
        TrackedImmersives.syncDataToClient(player, data2);
    }

    private static void syncDataToClient(class_3222 player, TrackedImmersiveData<?> data) {
        if (!data.getHandler().clientAuthoritative()) {
            Network.INSTANCE.sendToPlayer(player, data.getSyncPacket(player));
        }
    }
}

