/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.api_impl;

import com.hammy275.immersivemc.api.common.immersive.SwapMode;
import com.hammy275.immersivemc.server.storage.server.ItemSwapAmount;

public class ItemSwapAmountImpl
implements ItemSwapAmount {
    private final SwapMode swapMode;
    private final int numPlacements;
    private final int handStackSize;
    private final int slotIndex;

    public ItemSwapAmountImpl(SwapMode swapMode, int numPlacements, int handStackSize, int slotIndex) {
        this.swapMode = swapMode;
        this.numPlacements = numPlacements;
        this.handStackSize = handStackSize;
        this.slotIndex = slotIndex;
    }

    @Override
    public int getNumItemsToSwap() {
        return switch (this.swapMode) {
            default -> throw new MatchException(null, null);
            case SwapMode.SINGLE -> 1;
            case SwapMode.SPLIT -> {
                int amount = this.handStackSize / this.numPlacements;
                int leftover = this.handStackSize % this.numPlacements;
                if (leftover <= 0 || this.slotIndex < leftover) {
                    // empty if block
                }
                yield ++amount;
            }
            case SwapMode.ALL -> this.handStackSize;
            case SwapMode.CONSTANT -> throw new IllegalArgumentException("Attempted to swap with CONSTANT type from ItemSwapAmountImpl.");
        };
    }

    @Override
    public SwapMode getSwapMode() {
        return this.swapMode;
    }
}

