/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.util;

import com.hammy275.immersivemc.api.client.immersive.Immersive;
import com.hammy275.immersivemc.api.client.immersive.ImmersiveInfo;
import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.hitbox.HitboxInfo;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.MultiblockImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.common.immersive.ImmersiveChecker;
import com.hammy275.immersivemc.common.immersive.ImmersiveCheckers;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.server.immersive.TrackedImmersives;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1835;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2462;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3965;

public class Util {
    public static UseInfo activeUseInfo = null;

    public static boolean blockIsActiveImmersive(class_1657 player, class_2338 pos) {
        class_1937 level = player.method_37908();
        if (level.field_9236) {
            for (Immersive<? extends ImmersiveInfo, ? extends NetworkStorage> singleton : Immersives.IMMERSIVES) {
                ImmersiveHandler<? extends NetworkStorage> immersiveHandler = singleton.getHandler();
                if (immersiveHandler instanceof MultiblockImmersiveHandler) {
                    MultiblockImmersiveHandler handler = (MultiblockImmersiveHandler)immersiveHandler;
                    for (ImmersiveInfo immersiveInfo : singleton.getTrackedObjects()) {
                        Set<class_2338> handledBlocks = handler.getHandledBlocks(pos, level);
                        if (handledBlocks == null || !handledBlocks.contains(immersiveInfo.getBlockPosition())) continue;
                        return true;
                    }
                    continue;
                }
                for (ImmersiveInfo immersiveInfo : singleton.getTrackedObjects()) {
                    if (!immersiveInfo.getBlockPosition().equals((Object)pos)) continue;
                    return true;
                }
            }
            return false;
        }
        return TrackedImmersives.TRACKED_IMMERSIVES.stream().anyMatch(data -> data.playerUUID.equals(player.method_5667()) && data.getPos().contains(pos));
    }

    public static class_1268 otherHand(class_1268 hand) {
        return hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static class_1271<class_1799> doUse(class_1657 player, class_1268 hand, class_2338 pos) {
        class_1271 result;
        try {
            activeUseInfo = new UseInfo(player, hand, pos);
            result = player.method_5998(hand).method_7913(player.method_37908(), player, hand);
        }
        finally {
            activeUseInfo = null;
        }
        return result;
    }

    public static class_243 getLookAngle(float pitch, float yaw) {
        float yawCos = class_3532.method_15362((float)pitch);
        return new class_243((double)(class_3532.method_15374((float)yaw) * yawCos), (double)(-class_3532.method_15374((float)pitch)), (double)(class_3532.method_15362((float)yaw) * yawCos));
    }

    public static boolean isValidBlocks(ImmersiveHandler<?> handler, class_2338 pos, class_1937 level) {
        return Util.getValidBlocks(handler, pos, level).contains(pos);
    }

    public static boolean isValidBlocks(ImmersiveHandler<?> handler, Set<class_2338> pos, class_1937 level) {
        return Util.getValidBlocks(handler, pos.iterator().next(), level).equals(pos);
    }

    public static Set<class_2338> getValidBlocks(ImmersiveHandler<?> handler, class_2338 pos, class_1937 level) {
        boolean valid = handler.isValidBlock(pos, level);
        if (valid) {
            if (handler instanceof MultiblockImmersiveHandler) {
                MultiblockImmersiveHandler mih = (MultiblockImmersiveHandler)handler;
                Set<class_2338> positions = mih.getHandledBlocks(pos, level);
                if (positions != null && positions.stream().allMatch(p -> handler.isValidBlock((class_2338)p, level))) {
                    return positions;
                }
                return Set.of();
            }
            return Set.of(pos);
        }
        return Set.of();
    }

    public static class_243 average(Set<class_2338> positions) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (class_2338 pos : positions) {
            x += (double)pos.method_10263();
            y += (double)pos.method_10264();
            z += (double)pos.method_10260();
        }
        return new class_243(x / (double)positions.size(), y / (double)positions.size(), z / (double)positions.size());
    }

    public static boolean isThrowableItem(class_1792 item) {
        return item == class_1802.field_8287 || item == class_1802.field_8803 || item == class_1802.field_8634 || item == class_1802.field_8436 || item == class_1802.field_8150 || item == class_1802.field_8543 || item instanceof class_1835 || item instanceof class_1787;
    }

    public static class_2350 horizontalDirectionFromLook(class_243 look) {
        double maxLook = Math.max(Math.abs(look.field_1352), Math.abs(look.field_1350));
        if (maxLook == Math.abs(look.field_1352)) {
            return look.field_1352 < 0.0 ? class_2350.field_11039 : class_2350.field_11034;
        }
        return look.field_1350 < 0.0 ? class_2350.field_11043 : class_2350.field_11035;
    }

    public static boolean isHittingImmersive(class_3965 result, class_1937 level) {
        class_2338 pos = result.method_17777();
        for (ImmersiveChecker checker : ImmersiveCheckers.CHECKERS) {
            if (!checker.apply(pos, level)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasItemInInventoryWithStackSpace(class_1657 player, class_1799 stack) {
        for (class_1799 invItem : player.method_31548().field_7547) {
            if (!Util.stacksEqualBesidesCount(invItem, stack) || invItem.method_7947() >= invItem.method_7914()) continue;
            return true;
        }
        return false;
    }

    public static boolean canPickUpItem(class_1542 item, class_1657 player) {
        return (!item.method_6977() || player.method_31549().field_7477) && Math.abs(item.method_18798().field_1352) <= 0.01 && Math.abs(item.method_18798().field_1350) <= 0.01;
    }

    public static Optional<Integer> rayTraceClosest(Pair<class_243, class_243> rayStartAndEnd, BoundingBox ... targets) {
        return Util.rayTraceClosest((class_243)rayStartAndEnd.getFirst(), (class_243)rayStartAndEnd.getSecond(), targets);
    }

    public static Optional<Integer> rayTraceClosest(class_243 rayStart, class_243 rayEnd, BoundingBox ... targets) {
        return Util.rayTraceClosest(rayStart, rayEnd, Arrays.stream(targets).toList());
    }

    public static Optional<Integer> rayTraceClosest(class_243 rayStart, class_243 rayEnd, Collection<? extends HitboxInfo> targets) {
        return Util.rayTraceClosest(rayStart, rayEnd, targets.stream().map(info -> info != null ? info.getHitbox() : null).toList());
    }

    public static Optional<Integer> rayTraceClosest(class_243 rayStart, class_243 rayEnd, Iterable<BoundingBox> targets) {
        double dist = Double.MAX_VALUE;
        Integer winner = null;
        int i = 0;
        for (BoundingBox target : targets) {
            if (target != null) {
                double distTemp;
                if (BoundingBox.contains(target, rayStart)) {
                    return Optional.of(i);
                }
                Optional<class_243> closestHitOpt = target.isAABB() ? target.asAABB().method_992(rayStart, rayEnd) : target.asOBB().rayHit(rayStart, rayEnd);
                double d = distTemp = closestHitOpt.isPresent() ? closestHitOpt.get().method_1025(rayStart) : -1.0;
                if (closestHitOpt.isPresent() && distTemp < dist) {
                    winner = i;
                    dist = distTemp;
                }
            }
            ++i;
        }
        return Optional.ofNullable(winner);
    }

    public static Optional<Integer> getFirstIntersect(class_243 pos, BoundingBox ... targets) {
        return Util.getFirstIntersect(pos, Arrays.stream(targets).toList());
    }

    public static Optional<Integer> getFirstIntersect(class_243 pos, Collection<? extends HitboxInfo> targets) {
        return Util.getFirstIntersect(pos, targets.stream().map(info -> info != null ? info.getHitbox() : null).toList());
    }

    public static Optional<Integer> getFirstIntersect(class_243 pos, Iterable<BoundingBox> targets) {
        int i = 0;
        for (BoundingBox target : targets) {
            if (target != null && BoundingBox.contains(target, pos)) {
                return Optional.of(i);
            }
            ++i;
        }
        return Optional.empty();
    }

    public static Optional<Integer> getClosestIntersect(class_243 pos, List<BoundingBox> targets) {
        int res = -1;
        double distanceToBeat = Double.MAX_VALUE;
        for (int i = 0; i < targets.size(); ++i) {
            double newDist;
            if (targets.get(i) == null || !BoundingBox.contains(targets.get(i), pos) || !((newDist = pos.method_1025(BoundingBox.getCenter(targets.get(i)))) < distanceToBeat)) continue;
            distanceToBeat = newDist;
            res = i;
        }
        return res == -1 ? Optional.empty() : Optional.of(res);
    }

    public static class_2595 getOtherChest(class_2595 chest) {
        return Util.getOtherChest(chest, true);
    }

    protected static class_2595 getOtherChest(class_2595 chest, boolean checkOther) {
        if (chest == null) {
            return null;
        }
        class_2350 otherDir = class_2281.method_9758((class_2680)chest.method_11010());
        class_2338 otherPos = chest.method_11016().method_10093(otherDir);
        if (chest.method_10997() != null && chest.method_10997().method_8321(otherPos) instanceof class_2595) {
            class_2595 other = (class_2595)chest.method_10997().method_8321(otherPos);
            if (checkOther && other != null) {
                return Util.getOtherChest(other, false) == chest ? other : null;
            }
            return other;
        }
        return null;
    }

    public static boolean stacksEqualBesidesCount(class_1799 a, class_1799 b) {
        if (a.method_7960() && b.method_7960()) {
            return true;
        }
        if (a.method_7960() || b.method_7960()) {
            return false;
        }
        int oldCountA = a.method_7947();
        int oldCountB = b.method_7947();
        a.method_7939(1);
        b.method_7939(1);
        boolean res = class_1799.method_7973((class_1799)a, (class_1799)b);
        a.method_7939(oldCountA);
        b.method_7939(oldCountB);
        return res;
    }

    public static ItemStackMergeResult mergeStacks(class_1799 mergeIntoIn, class_1799 mergeFromIn, boolean useCopy) {
        return Util.mergeStacks(mergeIntoIn, mergeFromIn, useCopy, -1);
    }

    public static ItemStackMergeResult mergeStacks(class_1799 mergeIntoIn, class_1799 mergeFromIn, boolean useCopy, int forcedMaxMergeIntoSize) {
        int mergeIntoMaxStackSize;
        int n = mergeIntoMaxStackSize = forcedMaxMergeIntoSize == -1 ? mergeIntoIn.method_7914() : forcedMaxMergeIntoSize;
        if (!Util.stacksEqualBesidesCount(mergeIntoIn, mergeFromIn) || mergeIntoMaxStackSize <= 1) {
            return new ItemStackMergeResult(mergeIntoIn, mergeFromIn);
        }
        class_1799 into = useCopy ? mergeIntoIn.method_7972() : mergeIntoIn;
        class_1799 from = useCopy ? mergeFromIn.method_7972() : mergeFromIn;
        int totalCount = into.method_7947() + from.method_7947();
        int fromAmount = 0;
        if (totalCount > mergeIntoMaxStackSize) {
            fromAmount = totalCount - mergeIntoMaxStackSize;
            totalCount = mergeIntoMaxStackSize;
        }
        into.method_7939(totalCount);
        from.method_7939(fromAmount);
        return new ItemStackMergeResult(into, fromAmount == 0 ? class_1799.field_8037 : from);
    }

    public static void setRepeater(class_1937 level, class_2338 pos, int newDelay) {
        class_2680 state = level.method_8320(pos);
        if (state.method_26204() instanceof class_2462) {
            state = (class_2680)state.method_11657((class_2769)class_2462.field_11451, (Comparable)Integer.valueOf(newDelay));
            level.method_8652(pos, state, 3);
        }
    }

    public static void useLever(class_1657 player, class_2338 pos) {
        if (ImmersiveCheckers.isLever(pos, player.method_37908())) {
            class_2680 lever = player.method_37908().method_8320(pos);
            lever.method_55781(player.method_37908(), player, new class_3965(class_243.method_24953((class_2382)pos), class_2350.field_11043, pos, true));
        }
    }

    public static void useTrapdoor(class_1657 player, class_1937 level, class_2338 pos) {
        if (ImmersiveHandlers.trapdoorHandler.isValidBlock(pos, level)) {
            class_2680 trapdoor = level.method_8320(pos);
            trapdoor.method_55781(level, player, new class_3965(class_243.method_24953((class_2382)pos), class_2350.field_11043, pos, true));
        }
    }

    public static void useDoor(class_1657 player, class_1937 level, class_2338 pos) {
        if (ImmersiveHandlers.doorHandler.isValidBlock(pos, level)) {
            class_2680 door = level.method_8320(pos);
            door.method_55781(level, player, new class_3965(class_243.method_24953((class_2382)pos), class_2350.field_11043, pos, true));
        }
    }

    public static class_243 getPlayerVelocity(class_243 lastTickPos, class_243 currentTickPos) {
        return new class_243(currentTickPos.field_1352 - lastTickPos.field_1352, currentTickPos.field_1351 - lastTickPos.field_1351, currentTickPos.field_1350 - lastTickPos.field_1350);
    }

    public static double moveTowardsZero(double num, double subtract) {
        if ((subtract = Math.abs(subtract)) >= Math.abs(num)) {
            return 0.0;
        }
        if (num < 0.0) {
            return num + subtract;
        }
        return num - subtract;
    }

    public static void giveStackHandFirst(class_1657 player, class_1268 hand, class_1799 stack) {
        if (player.method_5998(hand).method_7960()) {
            player.method_6122(hand, stack);
        } else {
            Util.placeLeftovers(player, stack);
        }
    }

    public static void placeLeftovers(class_1657 player, class_1799 leftovers) {
        Util.placeLeftovers(player, leftovers, player.method_19538());
    }

    public static void placeLeftovers(class_1657 player, class_1799 leftovers, class_243 pos) {
        if (!leftovers.method_7960()) {
            class_1542 item = new class_1542(player.method_37908(), pos.field_1352, pos.field_1351, pos.field_1350, leftovers);
            player.method_37908().method_8649((class_1297)item);
        }
    }

    public static void putResourceLocation(class_2487 nbt, String key, class_2960 loc) {
        class_2487 locTag = new class_2487();
        locTag.method_10582("namespace", loc.method_12836());
        locTag.method_10582("path", loc.method_12832());
        nbt.method_10566(key, (class_2520)locTag);
    }

    public static class_2960 getResourceLocation(class_2487 nbt, String key) {
        class_2487 subTag = nbt.method_10562(key);
        return class_2960.method_60655((String)subTag.method_10558("namespace"), (String)subTag.method_10558("path"));
    }

    public static List<class_2338> allPositionsWithAABB(class_238 box) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        int minX = (int)Math.floor(box.field_1323);
        int minY = (int)Math.floor(box.field_1322);
        int minZ = (int)Math.floor(box.field_1321);
        int maxX = (int)Math.floor(box.field_1320);
        int maxY = (int)Math.floor(box.field_1325);
        int maxZ = (int)Math.floor(box.field_1324);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    positions.add(new class_2338(x, y, z));
                }
            }
        }
        return positions;
    }

    public static class_243[] get3x3HorizontalGrid(class_2338 blockPos, double spacing, class_2350 blockForward, boolean use3DCompat) {
        class_243 pos = class_243.method_26410((class_2382)blockPos, (double)1.0);
        if (use3DCompat) {
            pos = pos.method_1031(0.0, 0.0625, 0.0);
        }
        class_2350 left = blockForward.method_10160();
        class_243 leftOffset = new class_243((double)left.method_10163().method_10263() * -spacing, 0.0, (double)left.method_10163().method_10260() * -spacing);
        class_243 rightOffset = new class_243((double)left.method_10163().method_10263() * spacing, 0.0, (double)left.method_10163().method_10260() * spacing);
        class_243 topOffset = new class_243((double)blockForward.method_10163().method_10263() * -spacing, 0.0, (double)blockForward.method_10163().method_10260() * -spacing);
        class_243 botOffset = new class_243((double)blockForward.method_10163().method_10263() * spacing, 0.0, (double)blockForward.method_10163().method_10260() * spacing);
        return new class_243[]{pos.method_1019(leftOffset).method_1019(topOffset), pos.method_1019(topOffset), pos.method_1019(rightOffset).method_1019(topOffset), pos.method_1019(leftOffset), pos, pos.method_1019(rightOffset), pos.method_1019(leftOffset).method_1019(botOffset), pos.method_1019(botOffset), pos.method_1019(rightOffset).method_1019(botOffset)};
    }

    public static class_2350 getForwardFromPlayerUpAndDown(class_1657 player, class_2338 pos) {
        return Util.getForwardFromPlayerUpAndDownFilterBlockFacing(player, pos, false);
    }

    public static class_2350 getForwardFromPlayerUpAndDownFilterBlockFacing(class_1657 player, class_2338 pos, boolean filterOnBlockFacing) {
        class_2350.class_2351 filter = filterOnBlockFacing ? ((class_2350)player.method_37908().method_8320(pos).method_11654((class_2769)class_2318.field_10927)).method_10166() : null;
        class_243 playerPos = player.method_19538();
        if (playerPos.field_1351 >= (double)pos.method_10264() + 0.625 && filter != class_2350.class_2351.field_11052) {
            return class_2350.field_11036;
        }
        if (playerPos.field_1351 <= (double)pos.method_10264() - 0.625 && filter != class_2350.class_2351.field_11052) {
            return class_2350.field_11033;
        }
        class_2350 forward = ImmersiveLogicHelpers.instance().getHorizontalBlockForward(player, pos);
        if (forward.method_10166() != filter) {
            return forward;
        }
        class_2350 blockFacing = (class_2350)player.method_37908().method_8320(pos).method_11654((class_2769)class_2318.field_10927);
        class_243 blockCenter = class_243.method_24953((class_2382)pos);
        class_2350 blockLeftDir = blockFacing.method_10160();
        class_243 blockLeftVec = new class_243((double)blockLeftDir.method_10163().method_10263(), (double)blockLeftDir.method_10163().method_10264(), (double)blockLeftDir.method_10163().method_10260());
        class_243 counterClockwisePos = blockCenter.method_1019(blockLeftVec.method_1021(0.5));
        class_243 clockwisePos = blockCenter.method_1019(blockLeftVec.method_1021(-0.5));
        class_243 upPos = blockCenter.method_1031(0.0, 0.5, 0.0);
        class_243 downPos = blockCenter.method_1031(0.0, -0.5, 0.0);
        double counterClockwiseDist = counterClockwisePos.method_1025(playerPos);
        double clockwiseDist = clockwisePos.method_1025(playerPos);
        double upDist = upPos.method_1025(playerPos);
        double downDist = downPos.method_1025(playerPos);
        double min = Math.min(counterClockwiseDist, clockwiseDist);
        min = Math.min(min, upDist);
        if ((min = Math.min(min, downDist)) == counterClockwiseDist) {
            return forward.method_10160();
        }
        if (min == clockwiseDist) {
            return forward.method_10170();
        }
        if (min == upDist) {
            return class_2350.field_11036;
        }
        return class_2350.field_11033;
    }

    public record UseInfo(class_1657 player, class_1268 hand, class_2338 pos) {
        public class_243 getVec3Pos() {
            return class_243.method_24953((class_2382)this.pos);
        }
    }

    public static class ItemStackMergeResult {
        public final class_1799 mergedInto;
        public final class_1799 mergedFrom;

        public ItemStackMergeResult(class_1799 mergedInto, class_1799 mergedFrom) {
            this.mergedInto = mergedInto;
            this.mergedFrom = mergedFrom;
        }

        public String toString() {
            return "Merged Into: " + String.valueOf(this.mergedInto) + "\nMerged From: " + String.valueOf(this.mergedFrom);
        }
    }
}

