/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.NetworkClientHandlers;
import com.hammy275.immersivemc.mixin.BeaconBlockEntityMixin;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_2338;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9129;

public class BeaconDataPacket {
    private static final int speedId = class_7923.field_41174.method_10206((Object)((class_1291)class_1294.field_5904.comp_349()));
    private static final int hasteId = class_7923.field_41174.method_10206((Object)((class_1291)class_1294.field_5917.comp_349()));
    private static final int resistId = class_7923.field_41174.method_10206((Object)((class_1291)class_1294.field_5907.comp_349()));
    private static final int jumpId = class_7923.field_41174.method_10206((Object)((class_1291)class_1294.field_5913.comp_349()));
    private static final int strengthId = class_7923.field_41174.method_10206((Object)((class_1291)class_1294.field_5910.comp_349()));
    private static final int regenId = class_7923.field_41174.method_10206((Object)((class_1291)class_1294.field_5924.comp_349()));
    public final class_2338 pos;
    public final int powerIndex;
    public final boolean useRegen;

    public static BeaconDataPacket fromBeacon(class_2580 beacon) {
        BeaconBlockEntityMixin accessor = (BeaconBlockEntityMixin)beacon;
        class_6880<class_1291> primaryEffect = accessor.immersiveMC$getPrimaryPower();
        int primaryId = primaryEffect == null ? -1 : class_7923.field_41174.method_10206((Object)((class_1291)primaryEffect.comp_349()));
        int powerIndex = -1;
        if (primaryId == speedId) {
            powerIndex = 0;
        } else if (primaryId == hasteId) {
            powerIndex = 1;
        } else if (primaryId == resistId) {
            powerIndex = 2;
        } else if (primaryId == jumpId) {
            powerIndex = 3;
        } else if (primaryId == strengthId) {
            powerIndex = 4;
        }
        class_6880<class_1291> secondaryEffect = accessor.immersiveMC$getSecondaryPower();
        return new BeaconDataPacket(beacon.method_11016(), powerIndex, secondaryEffect != null && class_7923.field_41174.method_10206((Object)((class_1291)secondaryEffect.comp_349())) == regenId);
    }

    public BeaconDataPacket(class_2338 pos, int powerIndex, boolean useRegen) {
        this.pos = pos;
        this.powerIndex = powerIndex;
        this.useRegen = useRegen;
    }

    public BeaconDataPacket(class_2338 pos) {
        this.pos = pos;
        this.powerIndex = -2;
        this.useRegen = false;
    }

    public static void encode(BeaconDataPacket packet, class_9129 buffer) {
        buffer.method_10807(packet.pos).method_53002(packet.powerIndex).method_52964(packet.useRegen);
    }

    public static BeaconDataPacket decode(class_9129 buffer) {
        return new BeaconDataPacket(buffer.method_10811(), buffer.readInt(), buffer.readBoolean());
    }

    public static void handle(BeaconDataPacket packet, class_3222 player) {
        if (player == null) {
            NetworkClientHandlers.setBeaconData(packet);
        } else {
            class_2586 class_25862 = player.method_37908().method_8321(packet.pos);
            if (class_25862 instanceof class_2580) {
                class_2580 beacon = (class_2580)class_25862;
                Network.INSTANCE.sendToPlayer(player, BeaconDataPacket.fromBeacon(beacon));
            }
        }
    }
}

