/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive.storage.dual.impl;

import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.ServerSubscriber;
import com.hammy275.immersivemc.server.ServerUtil;
import com.hammy275.immersivemc.server.storage.server.ItemSwapAmount;
import com.hammy275.immersivemc.server.storage.server.SwapResult;
import com.hammy275.immersivemc.server.storage.world.WorldStorage;
import com.hammy275.immersivemc.server.storage.world.WorldStoragesImpl;
import com.hammy275.immersivemc.server.swap.Swap;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public abstract class ItemStorage
implements WorldStorage,
NetworkStorage {
    protected class_1799[] items;
    protected List<PlayerItemCounts>[] itemCounts;
    protected boolean isDirtyForClientSync = false;
    public final int maxInputIndex;

    public ItemStorage(int numItems, int maxInputIndex) {
        this.items = new class_1799[numItems];
        Arrays.fill(this.items, class_1799.field_8037);
        this.itemCounts = new LinkedList[numItems];
        for (int i = 0; i < numItems; ++i) {
            this.itemCounts[i] = new LinkedList<PlayerItemCounts>();
        }
        this.maxInputIndex = maxInputIndex;
    }

    public boolean isDirtyForClientSync() {
        return this.isDirtyForClientSync;
    }

    public void setDirty(class_3218 level) {
        WorldStoragesImpl.markDirtyS(level);
        this.isDirtyForClientSync = true;
    }

    public void setNoLongerDirtyForClientSync() {
        this.isDirtyForClientSync = false;
    }

    public void setItem(int slot, class_1799 stack) {
        this.items[slot] = stack;
        this.itemCounts[slot].clear();
    }

    public void setItem(int slot, class_1799 stack, class_1657 player) {
        this.setItem(slot, stack);
        this.incrementCountForPlayer(player, stack.method_7947(), slot);
    }

    public void shrinkSlot(int slot, int amount) {
        this.items[slot].method_7934(amount);
        this.shrinkCountsOnly(slot, amount);
    }

    public void shrinkCountsOnly(int slot, int amount) {
        while (amount > 0 && !this.itemCounts[slot].isEmpty()) {
            PlayerItemCounts counts = this.itemCounts[slot].get(0);
            int toSubtract = Math.min(amount, counts.count);
            amount -= toSubtract;
            counts.count -= toSubtract;
            if (counts.count != 0) continue;
            this.itemCounts[slot].remove(0);
        }
    }

    public void placeItem(class_1657 player, class_1268 hand, int slot, ItemSwapAmount amount) {
        this.placeItem(player, hand, slot, amount, -1);
    }

    public void placeItem(class_1657 player, class_1268 hand, int slot, ItemSwapAmount amount, int forcedMaxImmersiveStackSize) {
        class_1799 playerStack = player.method_5998(hand);
        class_1799 otherStack = this.getItem(slot);
        SwapResult result = Swap.swapItems(playerStack, otherStack, amount, forcedMaxImmersiveStackSize, player, incrementAmount -> this.incrementCountForPlayer(player, (int)incrementAmount, slot), ignored -> this.itemCounts[slot].clear());
        result.giveToPlayer(player, hand);
        this.items[slot] = result.immersiveStack();
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            this.setDirty(sp.method_51469());
        }
    }

    public void incrementCountForPlayer(class_1657 player, int amount, int slot) {
        PlayerItemCounts last;
        boolean shouldReturnItems = ActiveConfig.getConfigForPlayer((class_1657)player).returnItemsWhenLeavingImmersives;
        PlayerItemCounts playerItemCounts = last = this.itemCounts[slot].isEmpty() ? null : this.itemCounts[slot].getLast();
        if (last != null && shouldReturnItems && last.uuid.isPresent() && last.uuid.get().equals(player.method_5667())) {
            last.count += amount;
        } else if (shouldReturnItems) {
            this.itemCounts[slot].add(new PlayerItemCounts(Optional.of(player.method_5667()), amount));
        } else if (last != null && last.uuid.isEmpty()) {
            last.count += amount;
        } else {
            this.itemCounts[slot].add(new PlayerItemCounts(Optional.empty(), amount));
        }
    }

    public class_1799 getItem(int slot) {
        return this.items[slot];
    }

    public int getNumItems() {
        return this.items.length;
    }

    public class_1799[] getItemsRaw() {
        return this.items;
    }

    public void copyFromOld(ItemStorage oldStorage) {
        this.items = oldStorage.items;
        this.itemCounts = oldStorage.itemCounts;
    }

    public void returnItems(class_1657 player) {
        for (int slot = 0; slot < this.itemCounts.length; ++slot) {
            Stack<Integer> countsToRemove = new Stack<Integer>();
            for (int countIndex = 0; countIndex < this.itemCounts[slot].size(); ++countIndex) {
                PlayerItemCounts counts = this.itemCounts[slot].get(countIndex);
                if (!counts.uuid.isPresent() || !counts.uuid.get().equals(player.method_5667())) continue;
                countsToRemove.add(countIndex);
                class_1799 ret = this.items[slot].method_7972();
                ret.method_7939(counts.count);
                Util.placeLeftovers(player, ret);
                this.items[slot].method_7934(counts.count);
            }
            while (!countsToRemove.isEmpty()) {
                this.itemCounts[slot].remove((Integer)countsToRemove.pop());
            }
        }
    }

    @Override
    public void load(class_2487 nbt, class_7225.class_7874 provider, int lastVanillaDataVersion) {
        int i;
        int length = nbt.method_10550("numOfItems");
        this.items = new class_1799[length];
        for (i = 0; i < length; ++i) {
            this.items[i] = ServerUtil.parseItem((class_7225.class_7874)ServerSubscriber.server.method_30611(), nbt.method_10562("item" + i), lastVanillaDataVersion);
        }
        this.itemCounts = new LinkedList[length];
        for (i = 0; i < length; ++i) {
            this.itemCounts[i] = new LinkedList<PlayerItemCounts>();
        }
        if (nbt.method_10545("itemCounts")) {
            class_2487 rootCounts = nbt.method_10562("itemCounts");
            for (int i2 = 0; i2 < length; ++i2) {
                class_2487 slotTag = rootCounts.method_10562("slot" + i2);
                int numOfCounts = slotTag.method_10550("numOfItems");
                for (int j = 0; j < numOfCounts; ++j) {
                    this.itemCounts[i2].add(PlayerItemCounts.load(slotTag.method_10562(String.valueOf(j))));
                }
            }
        }
    }

    @Override
    public class_2487 save(class_2487 nbt, class_7225.class_7874 provider) {
        nbt.method_10569("numOfItems", this.items.length);
        for (int i = 0; i < this.items.length; ++i) {
            nbt.method_10566("item" + i, this.items[i].method_57375((class_7225.class_7874)ServerSubscriber.server.method_30611()));
        }
        class_2487 rootCounts = new class_2487();
        for (int slot = 0; slot < this.itemCounts.length; ++slot) {
            class_2487 countSlot = new class_2487();
            countSlot.method_10569("numOfItems", this.itemCounts[slot].size());
            for (int countIndex = 0; countIndex < this.itemCounts[slot].size(); ++countIndex) {
                PlayerItemCounts count = this.itemCounts[slot].get(countIndex);
                countSlot.method_10566(String.valueOf(countIndex), (class_2520)count.save());
            }
            rootCounts.method_10566("slot" + slot, (class_2520)countSlot);
        }
        nbt.method_10566("itemCounts", (class_2520)rootCounts);
        return nbt;
    }

    public void moveSlot(int oldSlot, int newSlot) {
        this.items[newSlot] = this.items[oldSlot];
        this.itemCounts[newSlot] = this.itemCounts[oldSlot];
        this.items[oldSlot] = class_1799.field_8037;
        this.itemCounts[oldSlot] = new LinkedList<PlayerItemCounts>();
    }

    public void addSlotsToEnd(int slotsToAdd) {
        int i;
        class_1799[] oldItems = this.items;
        List<PlayerItemCounts>[] oldItemCounts = this.itemCounts;
        this.items = new class_1799[oldItems.length + slotsToAdd];
        Arrays.fill(this.items, class_1799.field_8037);
        this.itemCounts = new LinkedList[oldItemCounts.length + slotsToAdd];
        for (i = 0; i < oldItems.length; ++i) {
            this.items[i] = oldItems[i];
        }
        for (i = 0; i < oldItemCounts.length; ++i) {
            this.itemCounts[i] = oldItemCounts[i];
        }
        for (i = oldItemCounts.length; i < this.itemCounts.length; ++i) {
            this.itemCounts[i] = new LinkedList<PlayerItemCounts>();
        }
    }

    @Override
    public void encode(class_9129 buffer) {
        for (class_1799 item : this.items) {
            class_1799.field_49268.encode((Object)buffer, (Object)item);
        }
    }

    @Override
    public void decode(class_9129 buffer) {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = (class_1799)class_1799.field_49268.decode((Object)buffer);
        }
    }

    public static class PlayerItemCounts {
        public final Optional<UUID> uuid;
        public int count;

        public PlayerItemCounts(Optional<UUID> uuid, int count) {
            this.uuid = uuid;
            this.count = count;
        }

        public class_2487 save() {
            class_2487 nbt = new class_2487();
            nbt.method_10582("uuid", this.uuid.isEmpty() ? "null" : this.uuid.get().toString());
            nbt.method_10569("count", this.count);
            return nbt;
        }

        public static PlayerItemCounts load(class_2487 nbt) {
            String uuidString = nbt.method_10558("uuid");
            UUID uuid = uuidString.equals("null") || uuidString.isEmpty() ? null : UUID.fromString(uuidString);
            int count = nbt.method_10550("count");
            return new PlayerItemCounts(Optional.ofNullable(uuid), count);
        }
    }
}

