/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.config;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.ClientActiveConfig;
import com.hammy275.immersivemc.common.config.CrouchMode;
import com.hammy275.immersivemc.common.config.ItemGuidePreset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigUpgrader {
    public static boolean upgradeCommonIfNeeded(Map<Object, Object> config) {
        int version;
        boolean didUpgrade;
        boolean bl = didUpgrade = version < ActiveConfig.DEFAULT.commonConfigVersion;
        for (version = config.containsKey("commonConfigVersion") ? ConfigUpgrader.readInt(config, "commonConfigVersion") : 1; version < ActiveConfig.DEFAULT.commonConfigVersion; ++version) {
            if (version != 1) continue;
            config.put("commonConfigVersion", 1);
        }
        config.put("commonConfigVersion", version);
        return didUpgrade;
    }

    public static boolean upgradeClientIfNeeded(Map<Object, Object> config) {
        int version;
        boolean didUpgrade;
        boolean bl = didUpgrade = version < ClientActiveConfig.DEFAULT.clientConfigVersion;
        for (version = config.containsKey("clientConfigVersion") ? ConfigUpgrader.readInt(config, "clientConfigVersion") : 1; version < ClientActiveConfig.DEFAULT.clientConfigVersion; ++version) {
            if (version == 1) {
                config.put("clientConfigVersion", 1);
                continue;
            }
            if (version == 2) {
                boolean bypassImmersive = (Boolean)config.getOrDefault("crouchingBypassesImmersives", false);
                config.put("crouchMode", bypassImmersive ? CrouchMode.BYPASS_IMMERSIVE.toString() : CrouchMode.SWAP_ALL.toString());
                config.remove("crouchingBypassesImmersives");
                continue;
            }
            if (version != 3) continue;
            int itemGuideColor = ConfigUpgrader.readInt(config, "itemGuideColor");
            int itemGuideSelectedColor = ConfigUpgrader.readInt(config, "itemGuideSelectedColor");
            int rangedGrabColor = ConfigUpgrader.readInt(config, "rangedGrabColor");
            if (itemGuideColor == 0x3300FFFF && itemGuideSelectedColor == 0x3300FF00 && rangedGrabColor == -16711681) {
                config.put("itemGuidePreset", ItemGuidePreset.CLASSIC.name());
                continue;
            }
            if (itemGuideColor == 1670089611 && itemGuideSelectedColor == 2143667653 && rangedGrabColor == -3815995) {
                config.put("itemGuidePreset", ItemGuidePreset.GRAY.name());
                continue;
            }
            if (itemGuideColor == -1 || itemGuideSelectedColor == -1 || rangedGrabColor == -1) continue;
            config.put("itemGuidePreset", ItemGuidePreset.CUSTOM.name());
            HashMap<String, Object> customColorMap = new HashMap<String, Object>();
            customColorMap.put("colors", List.of(Integer.valueOf(itemGuideColor)));
            customColorMap.put("selectedColors", List.of(Integer.valueOf(itemGuideSelectedColor)));
            customColorMap.put("rangedGrabColors", List.of(Integer.valueOf(rangedGrabColor)));
            customColorMap.put("transitionTimeMS", 5000);
            config.put("itemGuideCustomColorData", customColorMap);
        }
        config.put("clientConfigVersion", version);
        return didUpgrade;
    }

    private static int readInt(Map<Object, Object> config, String key) {
        return ((Double)config.get(key)).intValue();
    }
}

