/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.config;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.BackpackMode;
import com.hammy275.immersivemc.common.config.ClientActiveConfig;
import com.hammy275.immersivemc.common.config.ConfigType;
import com.hammy275.immersivemc.common.config.CrouchMode;
import com.hammy275.immersivemc.common.config.ItemGuideColorData;
import com.hammy275.immersivemc.common.config.ItemGuidePreset;
import com.hammy275.immersivemc.common.config.PlacementGuideMode;
import com.hammy275.immersivemc.common.config.ReachBehindBackpackMode;
import com.hammy275.immersivemc.common.util.RGBA;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.function.BiConsumer;

public class ConfigConverter {
    private static final File OLD_CONFIG_FILE = Paths.get(Platform.getConfigFolder().toString(), "immersive_mc.toml").toFile();
    private static Map<String, OldConfigData<?, ActiveConfig>> OLD_CONFIG_MAP_SHARED;
    private static Map<String, OldConfigData<?, ClientActiveConfig>> OLD_CONFIG_MAP_CLIENT_ONLY;
    private static long readItemGuideColor;
    private static long readItemGuideSelectedColor;
    private static long readRangedGrabColor;
    private static boolean definitelyDontConvert;

    public static void maybeDoConversion() {
        if (!definitelyDontConvert) {
            if (!OLD_CONFIG_FILE.exists() || ConfigType.SERVER.configFile.exists() || ConfigType.CLIENT.configFile.exists()) {
                definitelyDontConvert = true;
                return;
            }
            try {
                ConfigConverter.doConversion();
            }
            finally {
                definitelyDontConvert = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void doConversion() {
        ConfigConverter.initConversionMap();
        if (ActiveConfig.FILE_CLIENT == null) {
            ActiveConfig.FILE_CLIENT = new ClientActiveConfig();
        }
        try (Scanner scanner = new Scanner(OLD_CONFIG_FILE);){
            while (scanner.hasNextLine()) {
                int equalsIndex;
                String line = scanner.nextLine();
                if (line.startsWith("#") || (equalsIndex = line.indexOf(61)) <= -1) continue;
                String key = line.substring(0, equalsIndex).strip();
                OldConfigData<?, ActiveConfig> dataShared = OLD_CONFIG_MAP_SHARED.get(key);
                OldConfigData<?, ClientActiveConfig> dataClient = OLD_CONFIG_MAP_CLIENT_ONLY.get(key);
                if (dataShared == null && dataClient == null) continue;
                String value = line.substring(equalsIndex + 1).strip();
                Class clazz = dataShared != null ? dataShared.clazz : dataClient.clazz;
                try {
                    boolean val;
                    if (clazz == Integer.class) {
                        int val2 = Integer.parseInt(value);
                        if (dataShared != null) {
                            dataShared.setter.accept(ActiveConfig.FILE_CLIENT, (ClientActiveConfig)((Object)Integer.valueOf(val2)));
                            dataShared.setter.accept(ActiveConfig.FILE_SERVER, (ActiveConfig)((Object)Integer.valueOf(val2)));
                            continue;
                        }
                        dataClient.setter.accept(ActiveConfig.FILE_CLIENT, (ClientActiveConfig)((Object)Integer.valueOf(val2)));
                        continue;
                    }
                    if (clazz == Long.class) {
                        long val3 = Long.parseLong(value);
                        if (dataShared != null) {
                            dataShared.setter.accept(ActiveConfig.FILE_CLIENT, (ClientActiveConfig)((Object)Long.valueOf(val3)));
                            dataShared.setter.accept(ActiveConfig.FILE_SERVER, (ActiveConfig)((Object)Long.valueOf(val3)));
                            continue;
                        }
                        dataClient.setter.accept(ActiveConfig.FILE_CLIENT, (ClientActiveConfig)((Object)Long.valueOf(val3)));
                        continue;
                    }
                    if (clazz == Double.class) {
                        double val4 = Double.parseDouble(value);
                        if (dataShared != null) {
                            dataShared.setter.accept(ActiveConfig.FILE_CLIENT, (ClientActiveConfig)((Object)Double.valueOf(val4)));
                            dataShared.setter.accept(ActiveConfig.FILE_SERVER, (ActiveConfig)((Object)Double.valueOf(val4)));
                            continue;
                        }
                        dataClient.setter.accept(ActiveConfig.FILE_CLIENT, (ClientActiveConfig)((Object)Double.valueOf(val4)));
                        continue;
                    }
                    if (clazz != Boolean.class) throw new UnsupportedOperationException("Class " + String.valueOf(clazz) + " does not have a written conversion to the new config format!");
                    boolean bl = val = value.startsWith("t") || value.startsWith("T");
                    if (dataShared != null) {
                        dataShared.setter.accept(ActiveConfig.FILE_CLIENT, (ClientActiveConfig)((Object)Boolean.valueOf(val)));
                        dataShared.setter.accept(ActiveConfig.FILE_SERVER, (ActiveConfig)((Object)Boolean.valueOf(val)));
                        continue;
                    }
                    dataClient.setter.accept(ActiveConfig.FILE_CLIENT, (ClientActiveConfig)((Object)Boolean.valueOf(val)));
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
                }
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
        finally {
            if (readItemGuideColor == 0x3300FFFFL && readItemGuideSelectedColor == 0x3300FF00L && readRangedGrabColor == 0xFF00FFFFL) {
                ActiveConfig.FILE_CLIENT.itemGuidePreset = ItemGuidePreset.CLASSIC;
            } else if (readItemGuideColor == 1670089611L && readItemGuideSelectedColor == 2143667653L && readRangedGrabColor == 0xFFC5C5C5L) {
                ActiveConfig.FILE_CLIENT.itemGuidePreset = ItemGuidePreset.GRAY;
            } else if (readItemGuideColor != -1L && readItemGuideSelectedColor != -1L && readRangedGrabColor != -1L) {
                ActiveConfig.FILE_CLIENT.itemGuidePreset = ItemGuidePreset.CUSTOM;
                ActiveConfig.FILE_CLIENT.itemGuideCustomColorData = ItemGuideColorData.of(() -> new RGBA(readItemGuideColor), () -> new RGBA(readItemGuideSelectedColor), () -> new RGBA(readRangedGrabColor));
            }
            OLD_CONFIG_FILE.delete();
            ActiveConfig.FILE_SERVER.writeConfigFile(ConfigType.SERVER);
            if (Platform.isClient()) {
                ActiveConfig.FILE_CLIENT.writeConfigFile(ConfigType.CLIENT);
            } else {
                ActiveConfig.FILE_CLIENT = null;
            }
        }
    }

    private static <T> void addBothConversion(String key, Class<T> clazz, BiConsumer<ActiveConfig, T> setter) {
        OLD_CONFIG_MAP_SHARED.put(key, new OldConfigData<T, ActiveConfig>(clazz, setter));
    }

    private static <T> void addClientConversion(String key, Class<T> clazz, BiConsumer<ClientActiveConfig, T> setter) {
        OLD_CONFIG_MAP_CLIENT_ONLY.put(key, new OldConfigData<T, ClientActiveConfig>(clazz, setter));
    }

    private static void initConversionMap() {
        OLD_CONFIG_MAP_SHARED = new HashMap();
        OLD_CONFIG_MAP_CLIENT_ONLY = new HashMap();
        ConfigConverter.addClientConversion("bag_color", Integer.class, (config, val) -> {
            config.bagColor = val;
        });
        ConfigConverter.addBothConversion("anvil_immersion", Boolean.class, (config, val) -> {
            config.useAnvilImmersive = val;
        });
        ConfigConverter.addBothConversion("brewing_immersion", Boolean.class, (config, val) -> {
            config.useBrewingStandImmersive = val;
        });
        ConfigConverter.addBothConversion("chest_immersion", Boolean.class, (config, val) -> {
            config.useChestImmersive = val;
        });
        ConfigConverter.addBothConversion("crafting_immersion", Boolean.class, (config, val) -> {
            config.useCraftingTableImmersive = val;
        });
        ConfigConverter.addBothConversion("furnace_immersion", Boolean.class, (config, val) -> {
            config.useFurnaceImmersive = val;
        });
        ConfigConverter.addBothConversion("jukebox_immersion", Boolean.class, (config, val) -> {
            config.useJukeboxImmersive = val;
        });
        ConfigConverter.addBothConversion("ranged_grab", Boolean.class, (config, val) -> {
            config.useRangedGrabImmersive = val;
        });
        ConfigConverter.addBothConversion("button_immersion", Boolean.class, (config, val) -> {
            config.useButtonImmersive = val;
        });
        ConfigConverter.addBothConversion("enchant_table_immersion", Boolean.class, (config, val) -> {
            config.useEnchantingTableImmersive = val;
        });
        ConfigConverter.addBothConversion("campfire_immersion", Boolean.class, (config, val) -> {
            config.useCampfireImmersive = val;
        });
        ConfigConverter.addBothConversion("lever_immersion", Boolean.class, (config, val) -> {
            config.useLeverImmersive = val;
        });
        ConfigConverter.addBothConversion("bag_inventory", Boolean.class, (config, val) -> {
            config.useBagImmersive = val;
        });
        ConfigConverter.addBothConversion("repeater_immersion", Boolean.class, (config, val) -> {
            config.useRepeaterImmersive = val;
        });
        ConfigConverter.addBothConversion("door_immersion", Boolean.class, (config, val) -> {
            config.useDoorImmersive = val;
        });
        ConfigConverter.addBothConversion("can_pet", Boolean.class, (config, val) -> {
            config.allowPetting = val;
        });
        ConfigConverter.addBothConversion("armor_immersion", Boolean.class, (config, val) -> {
            config.useArmorImmersive = val;
        });
        ConfigConverter.addBothConversion("feed_animals", Boolean.class, (config, val) -> {
            config.useFeedingAnimalsImmersive = val;
        });
        ConfigConverter.addBothConversion("shulker_box_immersion", Boolean.class, (config, val) -> {
            config.useShulkerImmersive = val;
        });
        ConfigConverter.addBothConversion("can_pet_any_living", Boolean.class, (config, val) -> {
            config.allowPettingAnythingLiving = val;
        });
        ConfigConverter.addBothConversion("immersive_shield", Boolean.class, (config, val) -> {
            config.useShieldImmersive = val;
        });
        ConfigConverter.addBothConversion("ranged_grab_range", Integer.class, (config, val) -> {
            config.rangedGrabRange = val;
        });
        ConfigConverter.addBothConversion("beacon_immersion", Boolean.class, (config, val) -> {
            config.useBeaconImmersive = val;
        });
        ConfigConverter.addBothConversion("barrel_immersion", Boolean.class, (config, val) -> {
            config.useBarrelImmersive = val;
        });
        ConfigConverter.addBothConversion("use_throwing", Boolean.class, (config, val) -> {
            config.useThrowingImmersive = val;
        });
        ConfigConverter.addBothConversion("allow_throwing_beyond_max", Boolean.class, (config, val) -> {
            config.allowThrowingBeyondVanillaMaxRange = val;
        });
        ConfigConverter.addBothConversion("hopper_immersion", Boolean.class, (config, val) -> {
            config.useHopperImmersive = val;
        });
        ConfigConverter.addBothConversion("smithing_table_immersion", Boolean.class, (config, val) -> {
            config.useSmithingTableImmersive = val;
        });
        ConfigConverter.addBothConversion("written_book_immersion", Boolean.class, (config, val) -> {
            config.useWrittenBookImmersive = val;
        });
        ConfigConverter.addBothConversion("cauldron_immersion", Boolean.class, (config, val) -> {
            config.useCauldronImmersive = val;
        });
        ConfigConverter.addClientConversion("crouch_bypass_immersion", Boolean.class, (config, val) -> {
            config.crouchMode = val != false ? CrouchMode.BYPASS_IMMERSIVE : CrouchMode.SWAP_ALL;
        });
        ConfigConverter.addClientConversion("do_rumble", Boolean.class, (config, val) -> {
            config.doVRControllerRumble = val;
        });
        ConfigConverter.addClientConversion("return_items", Boolean.class, (config, val) -> {
            config.returnItemsWhenLeavingImmersives = val;
        });
        ConfigConverter.addClientConversion("right_click_chest", Boolean.class, (config, val) -> {
            config.rightClickChestInteractions = val;
        });
        ConfigConverter.addClientConversion("center_furnace", Boolean.class, (config, val) -> {
            config.autoCenterFurnaceImmersive = val;
        });
        ConfigConverter.addClientConversion("center_brewing", Boolean.class, (config, val) -> {
            config.autoCenterBrewingStandImmersive = val;
        });
        ConfigConverter.addClientConversion("bag_mode", Integer.class, (config, val) -> {
            config.bagMode = BackpackMode.values()[val];
        });
        ConfigConverter.addClientConversion("placement_guide_mode", Integer.class, (config, val) -> {
            config.placementGuideMode = PlacementGuideMode.values()[val];
        });
        ConfigConverter.addClientConversion("spin_crafting_output", Boolean.class, (config, val) -> {
            config.spinSomeImmersiveOutputs = val;
        });
        ConfigConverter.addClientConversion("right_click_in_vr", Boolean.class, (config, val) -> {
            config.rightClickImmersiveInteractionsInVR = val;
        });
        ConfigConverter.addClientConversion("resource_pack_3d_compat", Boolean.class, (config, val) -> {
            config.compatFor3dResourcePacks = val;
        });
        ConfigConverter.addClientConversion("item_guide_color", Long.class, (config, val) -> {
            readItemGuideColor = val;
        });
        ConfigConverter.addClientConversion("item_guide_selected_color", Long.class, (config, val) -> {
            readItemGuideSelectedColor = val;
        });
        ConfigConverter.addClientConversion("ranged_grab_color", Long.class, (config, val) -> {
            readRangedGrabColor = val;
        });
        ConfigConverter.addClientConversion("disable_vanilla_interactions", Boolean.class, (config, val) -> {
            config.disableVanillaInteractionsForSupportedImmersives = val;
        });
        ConfigConverter.addClientConversion("reach_behind_bag_mode", Integer.class, (config, val) -> {
            config.reachBehindBagMode = ReachBehindBackpackMode.values()[val];
        });
        ConfigConverter.addBothConversion("iron_furnaces_furnace_immersion", Boolean.class, (config, val) -> {
            config.useIronFurnacesFurnaceImmersive = val;
        });
        ConfigConverter.addBothConversion("tinkers_construct_crafting_station_immersion", Boolean.class, (config, val) -> {
            config.useTinkersConstructCraftingStationImmersive = val;
        });
        ConfigConverter.addClientConversion("item_guide_size", Double.class, (config, val) -> {
            config.itemGuideSize = val;
        });
        ConfigConverter.addClientConversion("item_guide_selected_size", Double.class, (config, val) -> {
            config.itemGuideSelectedSize = val;
        });
        ConfigConverter.addClientConversion("disable_outside_vr", Boolean.class, (config, val) -> {
            config.disableImmersiveMCOutsideVR = val;
        });
        ConfigConverter.addBothConversion("lectern_immersion", Boolean.class, (config, val) -> {
            config.useLecternImmersive = val;
        });
        ConfigConverter.addBothConversion("chiseled_bookshelf_immersion", Boolean.class, (config, val) -> {
            config.useChiseledBookshelfImmersive = val;
        });
    }

    static {
        readItemGuideColor = -1L;
        readItemGuideSelectedColor = -1L;
        readRangedGrabColor = -1L;
        definitelyDontConvert = false;
    }

    private record OldConfigData<T, C extends ActiveConfig>(Class<T> clazz, BiConsumer<C, T> setter) {
    }
}

