/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.api_impl.hitbox;

import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.hitbox.OBB;
import com.hammy275.immersivemc.common.obb.OBBRotList;
import com.hammy275.immersivemc.common.obb.RotType;
import java.util.Optional;
import net.minecraft.class_238;
import net.minecraft.class_243;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class OBBImpl
implements BoundingBox,
OBB {
    private static final double HALFSQRT2 = Math.sqrt(2.0) / 2.0;
    final class_238 aabb;
    final class_243 center;
    final Vector3f centerF;
    final Quaternionf rotation;

    public OBBImpl(class_238 aabb) {
        this(aabb, new Quaternionf());
    }

    public OBBImpl(class_238 aabb, double pitch, double yaw, double roll) {
        this(aabb, OBBRotList.create().addRot(yaw, RotType.YAW).addRot(pitch, RotType.PITCH).addRot(roll, RotType.ROLL).asQuaternion());
    }

    public OBBImpl(class_238 aabb, Quaternionf rotation) {
        this.aabb = aabb;
        this.center = aabb.method_1005();
        this.centerF = this.center.method_46409();
        this.rotation = rotation;
    }

    @Override
    public boolean contains(class_243 point) {
        Vector3f pt = point.method_46409();
        pt = pt.sub((Vector3fc)this.centerF).rotate((Quaternionfc)this.rotation).add((Vector3fc)this.centerF);
        return this.aabb.method_1006(this.toVec3(pt));
    }

    @Override
    public Optional<class_243> rayHit(class_243 rayStart, class_243 rayEnd) {
        class_243 dir = rayEnd.method_1020(rayStart).method_1029();
        double dist = rayStart.method_1022(rayEnd);
        Vector3f dirF = dir.method_46409().rotate((Quaternionfc)this.rotation);
        Vector3f rayStartF = rayStart.method_46409().sub((Vector3fc)this.centerF).rotate((Quaternionfc)this.rotation).add((Vector3fc)this.centerF);
        Optional intersect = this.aabb.method_992(this.toVec3(rayStartF), this.toVec3(rayStartF.add((Vector3fc)dirF.mul((float)dist))));
        if (intersect.isPresent()) {
            return Optional.of(this.toVec3(((class_243)intersect.get()).method_46409().sub((Vector3fc)this.centerF).rotate((Quaternionfc)this.rotation).add((Vector3fc)this.centerF)));
        }
        return Optional.empty();
    }

    @Override
    public class_238 getUnderlyingAABB() {
        return this.aabb;
    }

    @Override
    public class_243 getCenter() {
        return this.center;
    }

    @Override
    public Quaternionf getRotation() {
        return new Quaternionf((Quaternionfc)this.rotation);
    }

    @Override
    public class_238 getEnclosingAABB() {
        double maxSize = Math.max(Math.max(this.aabb.method_17939(), this.aabb.method_17940()), this.aabb.method_17941());
        return this.aabb.method_1014(maxSize * HALFSQRT2);
    }

    @Override
    public OBB move(class_243 movement) {
        return new OBBImpl(this.aabb.method_997(movement), this.rotation);
    }

    @Override
    public OBBImpl asOBB() {
        return this;
    }

    @Override
    public class_238 asAABB() {
        throw new RuntimeException("Cannot get AABB as OBB!");
    }

    private class_243 toVec3(Vector3f vec3f) {
        return new class_243((double)vec3f.x(), (double)vec3f.y(), (double)vec3f.z());
    }
}

