/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive.book;

import com.hammy275.immersivemc.api.common.hitbox.OBB;
import com.hammy275.immersivemc.client.immersive.book.BookInteractable;
import com.hammy275.immersivemc.client.immersive.book.BookRenderable;
import com.hammy275.immersivemc.common.immersive.CommonBookData;
import com.hammy275.immersivemc.common.obb.OBBClientUtil;
import com.hammy275.immersivemc.common.util.PageChangeState;
import com.hammy275.immersivemc.common.util.PosRot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_557;
import net.minecraft.class_5602;
import net.minecraft.class_7833;

public class ClientBookData
extends CommonBookData {
    private static final class_557 bookModel = new class_557(class_310.method_1551().method_31974().method_32072(class_5602.field_27685));
    private static final class_2960 writtenBookTexture = class_2960.method_60655((String)"immersivemc", (String)"nahnotfox_written_book.png");
    public final List<BookInteractable> interactables = new ArrayList<BookInteractable>();
    public final List<BookRenderable> renderables = new ArrayList<BookRenderable>();
    protected final List<OBB> obbs = new ArrayList<OBB>();
    protected float lastLeftPageTurn;
    protected float lastRightPageTurn;

    public ClientBookData() {
        this.pageTurner = class_310.method_1551().field_1724;
        this.lastLeftPageTurn = this.leftPageTurn;
        this.lastRightPageTurn = this.rightPageTurn;
    }

    @Override
    public void tick(PosRot bookPosRot, PosRot ... others) {
        this.lastLeftPageTurn = this.leftPageTurn;
        this.lastRightPageTurn = this.rightPageTurn;
        super.tick(bookPosRot, others);
        this.obbs.clear();
        BookInteractable[] interacted = new BookInteractable[others.length];
        for (BookInteractable interactable : this.interactables) {
            OBB obb = interactable.getOBB();
            this.obbs.add(obb);
            for (int o = 0; o < others.length; ++o) {
                PosRot other = others[o];
                if (interacted[o] != null || !obb.contains(other.position())) continue;
                interacted[o] = interactable;
            }
        }
        for (int o = 0; o < others.length; ++o) {
            if (interacted[o] == null) continue;
            if (class_310.method_1551().field_1690.field_1886.method_1434()) {
                interacted[o].interact(this, bookPosRot, others[o]);
                continue;
            }
            interacted[o].hover(this, bookPosRot, others[o]);
        }
    }

    public void render(class_4587 stack, int light, PosRot bookPosRot) {
        stack.method_22903();
        float partialTick = class_310.method_1551().method_60646().method_60637(true);
        class_243 pos = bookPosRot.position();
        class_4184 cameraInfo = class_310.method_1551().field_1773.method_19418();
        stack.method_22904(-cameraInfo.method_19326().field_1352 + pos.field_1352, -cameraInfo.method_19326().field_1351 + pos.field_1351, -cameraInfo.method_19326().field_1350 + pos.field_1350);
        stack.method_22905(1.0f, 1.0f, 1.0f);
        stack.method_22907(class_7833.field_40715.rotationDegrees(bookPosRot.getYaw() + 90.0f));
        stack.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
        stack.method_22907(class_7833.field_40718.rotationDegrees(bookPosRot.getPitch()));
        stack.method_22907(class_7833.field_40715.rotationDegrees(bookPosRot.getRoll()));
        float bookOpenAmount = 1.1f;
        bookModel.method_17073(0.0f, class_3532.method_16439((float)partialTick, (float)this.lastLeftPageTurn, (float)this.leftPageTurn), class_3532.method_16439((float)partialTick, (float)this.lastRightPageTurn, (float)this.rightPageTurn), bookOpenAmount);
        bookModel.method_24184(stack, class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23572((class_2960)writtenBookTexture)), light, class_4608.field_21444, -1);
        stack.method_22909();
        if (this.pageChangeState == PageChangeState.NONE) {
            this.renderPage(stack, bookPosRot, true, light);
            this.renderPage(stack, bookPosRot, false, light);
        }
        if (this.pageChangeState == PageChangeState.NONE) {
            for (int i = 0; i <= 1; ++i) {
                OBBClientUtil.renderOBB(stack, this.pageTurnBoxes[i], false, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else if (!this.pageChangeState.isAnim) {
            OBBClientUtil.renderOBB(stack, this.pageTurnBoxes[2], false, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        for (OBB obb : this.obbs) {
            OBBClientUtil.renderOBB(stack, obb, false, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void mergeFromServer(CommonBookData fromServer) {
        this.leftPageIndex = fromServer.leftPageIndex;
        this.leftPageTurn = fromServer.leftPageTurn;
        this.rightPageTurn = fromServer.rightPageTurn;
        this.pageChangeState = fromServer.pageChangeState;
    }

    public List<OBB> getPageTurnHitboxes() {
        return List.of(this.pageTurnBoxes);
    }

    public List<OBB> getInteractableHitboxes() {
        return this.interactables.stream().map(BookInteractable::getOBB).toList();
    }

    protected void renderPage(class_4587 stack, PosRot bookPosRot, boolean leftPage, int light) {
        class_243 awayFromBookUp = this.getAwayVector(bookPosRot);
        class_243 pageUp = bookPosRot.getLookAngle();
        class_243 left = this.getLeftRightVector(bookPosRot, leftPage);
        class_243 posBase = bookPosRot.position().method_1019(left.method_1021(0.15)).method_1019(awayFromBookUp.method_1021(0.09375));
        class_4184 cameraInfo = class_310.method_1551().field_1773.method_19418();
        for (BookRenderable renderable : this.renderables) {
            stack.method_22903();
            class_243 renderableOffset = renderable.getStartOffset(this, leftPage, bookPosRot);
            class_243 pos = posBase.method_1019(pageUp.method_1021(0.25 * renderableOffset.field_1351)).method_1019(left.method_1021(-0.15 * renderableOffset.field_1352)).method_1019(awayFromBookUp.method_1021(0.09375 * renderableOffset.field_1350));
            stack.method_22904(-cameraInfo.method_19326().field_1352 + pos.field_1352, -cameraInfo.method_19326().field_1351 + pos.field_1351, -cameraInfo.method_19326().field_1350 + pos.field_1350);
            stack.method_22907(class_7833.field_40715.rotationDegrees(bookPosRot.getYaw() + 90.0f));
            stack.method_22907(class_7833.field_40718.rotationDegrees(bookPosRot.getPitch()));
            stack.method_22907(class_7833.field_40714.rotationDegrees(90.0f + (leftPage ? 11.0f : -11.0f)));
            stack.method_22907(class_7833.field_40718.rotationDegrees(270.0f));
            stack.method_22907(class_7833.field_40716.rotationDegrees(bookPosRot.getRoll()));
            renderable.render(stack, this, leftPage, light, bookPosRot);
            stack.method_22909();
        }
    }

    @Override
    public void resetTurnState() {
        super.resetTurnState();
        this.lastLeftPageTurn = this.leftPageTurn;
        this.lastRightPageTurn = this.rightPageTurn;
    }
}

