/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.immersive.BuiltImmersiveInfo;
import com.hammy275.immersivemc.api.client.immersive.ForcedUpDownRenderDir;
import com.hammy275.immersivemc.api.client.immersive.HitboxPositioningMode;
import com.hammy275.immersivemc.api.client.immersive.HitboxVRMovementInfo;
import com.hammy275.immersivemc.api.client.immersive.HitboxVRMovementInfoBuilder;
import com.hammy275.immersivemc.api.client.immersive.ItemRotationType;
import com.hammy275.immersivemc.api.client.immersive.RelativeHitboxInfo;
import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.hitbox.HitboxInfo;
import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.LastClientVRData;
import com.hammy275.immersivemc.client.immersive.RelativeHitboxInfoBuilderImpl;
import com.hammy275.immersivemc.client.immersive.TextData;
import com.hammy275.immersivemc.client.immersive.info.BuiltImmersiveInfoImpl;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;

public class RelativeHitboxInfoImpl
implements RelativeHitboxInfo,
HitboxInfo,
Cloneable {
    private final RelativeHitboxInfoBuilderImpl usedBuilder;
    public final Function<BuiltImmersiveInfo<?>, class_243> centerOffset;
    public final double sizeX;
    public final double sizeY;
    public final double sizeZ;
    public final boolean isInput;
    public final boolean holdsItems;
    public final boolean itemSpins;
    public final float itemRenderSizeMultiplier;
    public final boolean isTriggerHitbox;
    public final Function<BuiltImmersiveInfo<?>, List<Pair<class_2561, class_243>>> textSupplier;
    public final Function<BuiltImmersiveInfo<?>, ForcedUpDownRenderDir> forcedUpDownRenderDir;
    public final boolean constantOffset;
    public final boolean needs3dCompat;
    public final HitboxVRMovementInfo vrMovementInfo;
    public final boolean renderItem;
    public final boolean renderItemCount;
    public final boolean forcedUpDownRenderDirConstant;
    public final ItemRotationType itemRotationType;
    private class_238 box;
    private class_243 pos;
    private boolean didCalc = false;
    private final List<TextData> textData = new ArrayList<TextData>();
    private class_2350 upDownRenderDir = null;
    private class_243 xVec;
    private class_243 yVec;
    private class_243 zVec;
    private class_243 centerPos;
    private class_243 lastPos = null;
    public class_1799 item = null;

    public RelativeHitboxInfoImpl(RelativeHitboxInfoBuilderImpl usedBuilder, Function<BuiltImmersiveInfo<?>, class_243> centerOffset, double sizeX, double sizeY, double sizeZ, boolean holdsItems, boolean isInput, boolean itemSpins, float itemRenderSizeMultiplier, boolean isTriggerHitbox, Function<BuiltImmersiveInfo<?>, List<Pair<class_2561, class_243>>> textSupplier, Function<BuiltImmersiveInfo<?>, ForcedUpDownRenderDir> forcedUpDownDir, boolean constantOffset, boolean needs3dCompat, HitboxVRMovementInfo vrMovementInfo, boolean renderItem, boolean renderItemCount, boolean forcedUpDownRenderDirConstant, ItemRotationType itemRotationType) {
        this.usedBuilder = usedBuilder;
        this.centerOffset = centerOffset;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.holdsItems = holdsItems;
        this.isInput = isInput;
        this.itemSpins = itemSpins;
        this.itemRenderSizeMultiplier = itemRenderSizeMultiplier;
        this.isTriggerHitbox = isTriggerHitbox;
        this.textSupplier = textSupplier;
        this.forcedUpDownRenderDir = forcedUpDownDir;
        this.constantOffset = constantOffset;
        this.needs3dCompat = needs3dCompat;
        this.vrMovementInfo = vrMovementInfo;
        this.renderItem = renderItem;
        this.renderItemCount = renderItemCount;
        this.forcedUpDownRenderDirConstant = forcedUpDownRenderDirConstant;
        this.itemRotationType = itemRotationType;
    }

    public void forceNull() {
        this.pos = null;
        this.box = null;
        this.didCalc = true;
        this.textData.clear();
        this.upDownRenderDir = null;
    }

    public void recalculate(class_1937 level, HitboxPositioningMode mode, BuiltImmersiveInfoImpl<?> info) {
        this.lastPos = this.pos;
        class_243 offset = this.centerOffset.apply(info);
        if (offset == null) {
            this.forceNull();
            return;
        }
        if (ActiveConfig.active().compatFor3dResourcePacks && this.needs3dCompat) {
            offset = offset.method_1031(0.0, 0.0, 0.0625);
        }
        class_2338 pos = info.getBlockPosition();
        if (mode == HitboxPositioningMode.HORIZONTAL_BLOCK_FACING) {
            blockFacing = (class_2350)level.method_8320(pos).method_11654((class_2769)class_2383.field_11177);
            this.recalcHorizBlockFacing(blockFacing, info, offset);
            this.upDownRenderDir = null;
        } else if (mode == HitboxPositioningMode.TOP_PLAYER_FACING) {
            this.recalcTopPlayerFacing(info.immersiveDir, info, offset);
            this.upDownRenderDir = class_2350.field_11036;
        } else if (mode == HitboxPositioningMode.TOP_LITERAL) {
            this.xVec = new class_243(1.0, 0.0, 0.0);
            this.yVec = new class_243(0.0, 1.0, 0.0);
            this.zVec = new class_243(0.0, 0.0, 1.0);
            this.centerPos = class_243.method_24955((class_2382)pos).method_1031(0.0, 1.0, 0.0);
            double actualXSize = this.sizeX;
            double actualYSize = this.sizeY;
            double actualZSize = this.sizeZ;
            this.pos = this.centerPos.method_1019(this.xVec.method_1021(offset.field_1352)).method_1019(this.yVec.method_1021(offset.field_1351)).method_1019(this.zVec.method_1021(offset.field_1350));
            this.box = class_238.method_30048((class_243)this.pos, (double)actualXSize, (double)actualYSize, (double)actualZSize);
            this.upDownRenderDir = class_2350.field_11036;
        } else if (mode == HitboxPositioningMode.TOP_BLOCK_FACING) {
            blockFacing = (class_2350)level.method_8320(pos).method_11654((class_2769)class_2383.field_11177);
            this.recalcTopBottomBlockFacing(blockFacing, info, offset, false);
            this.upDownRenderDir = class_2350.field_11036;
        } else if (mode == HitboxPositioningMode.HORIZONTAL_PLAYER_FACING) {
            blockFacing = ImmersiveLogicHelpers.instance().getHorizontalBlockForward((class_1657)class_310.method_1551().field_1724, info.getBlockPosition());
            this.recalcHorizBlockFacing(blockFacing, info, offset);
            this.upDownRenderDir = null;
        } else if (mode == HitboxPositioningMode.BLOCK_FACING_NEG_X) {
            blockFacing = (class_2350)level.method_8320(pos).method_11654((class_2769)class_2318.field_10927);
            if (blockFacing.method_10166() != class_2350.class_2351.field_11052) {
                this.recalcHorizBlockFacing(blockFacing, info, offset);
                this.upDownRenderDir = null;
            } else {
                this.recalcTopBottomBlockFacing(class_2350.field_11035, info, offset, blockFacing == class_2350.field_11033);
                this.upDownRenderDir = blockFacing;
            }
        } else if (mode == HitboxPositioningMode.PLAYER_FACING_NO_DOWN) {
            class_2350 playerFacing = Util.getForwardFromPlayerUpAndDown((class_1657)class_310.method_1551().field_1724, info.getBlockPosition());
            if (playerFacing == class_2350.field_11036) {
                this.recalcTopPlayerFacing(info.immersiveDir, info, offset);
                this.upDownRenderDir = class_2350.field_11036;
            } else {
                blockFacing = ImmersiveLogicHelpers.instance().getHorizontalBlockForward((class_1657)class_310.method_1551().field_1724, info.getBlockPosition());
                this.recalcHorizBlockFacing(blockFacing, info, offset);
                this.upDownRenderDir = null;
            }
        } else if (mode == HitboxPositioningMode.PLAYER_FACING_FILTER_BLOCK_FACING) {
            class_2350 dir = info.immersiveDir;
            class_2350 literalFacing = (class_2350)level.method_8320(pos).method_11654((class_2769)class_2318.field_10927);
            if (dir.method_10166() == class_2350.class_2351.field_11052) {
                this.recalcTopBottomBlockFacing(literalFacing, info, offset, dir == class_2350.field_11033);
            } else {
                this.recalcHorizBlockFacing(dir, info, offset, literalFacing);
                this.upDownRenderDir = null;
            }
        } else if (mode == HitboxPositioningMode.HORIZONTAL_BLOCK_FACING_ATTACHED_FLOOR_CEILING_REVERSED) {
            class_2680 state = level.method_8320(pos);
            blockFacing = (class_2350)state.method_11654((class_2769)class_2383.field_11177);
            class_2738 attachFace = (class_2738)state.method_11654((class_2769)class_2741.field_12555);
            switch (attachFace) {
                case field_12475: 
                case field_12473: {
                    boolean isCeiling = attachFace == class_2738.field_12473;
                    blockFacing = blockFacing.method_10153();
                    this.recalcHorizBlockFacing(blockFacing, info, offset, isCeiling ? class_2350.field_11033 : class_2350.field_11036);
                    this.upDownRenderDir = isCeiling ? class_2350.field_11033 : class_2350.field_11036;
                    break;
                }
                case field_12471: {
                    this.xVec = class_243.method_24954((class_2382)blockFacing.method_10160().method_10163());
                    this.yVec = class_243.method_24954((class_2382)blockFacing.method_10163());
                    this.zVec = new class_243(0.0, -1.0, 0.0);
                    this.centerPos = class_243.method_24955((class_2382)info.getBlockPosition());
                    this.upDownRenderDir = null;
                    double actualXSize = blockFacing.method_10166() == class_2350.class_2351.field_11048 ? this.sizeZ : this.sizeX;
                    double actualYSize = blockFacing.method_10166() == class_2350.class_2351.field_11048 ? this.sizeX : this.sizeZ;
                    double actualZSize = this.sizeY;
                    this.pos = this.centerPos.method_1019(this.xVec.method_1021(offset.field_1352)).method_1019(this.yVec.method_1021(offset.field_1351)).method_1019(this.zVec.method_1021(offset.field_1350));
                    this.box = class_238.method_30048((class_243)this.pos, (double)actualXSize, (double)actualYSize, (double)actualZSize);
                }
            }
        } else {
            throw new UnsupportedOperationException("Hitbox calculation for positioning mode " + String.valueOf((Object)mode) + " unimplemented!");
        }
        this.calcTextOffsets(info);
        ForcedUpDownRenderDir forcedDirApplied = this.forcedUpDownRenderDir.apply(info);
        if (forcedDirApplied != ForcedUpDownRenderDir.NOT_FORCED) {
            this.upDownRenderDir = forcedDirApplied.direction;
        }
        if (this.vrMovementInfo != null && VRPluginVerify.clientInVR()) {
            boolean[] passed = new boolean[]{false, false};
            for (int c = 0; c <= 1; ++c) {
                class_243 velocityMask;
                double negThreshold;
                double posThreshold;
                if (!LastClientVRData.canGetVelocityChange() || !this.box.method_1006(VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724).getController(c).position())) continue;
                class_243 velocity = LastClientVRData.changeForVelocity(c == 0 ? LastClientVRData.VRType.C0 : LastClientVRData.VRType.C1);
                if (this.vrMovementInfo.relativeAxis() == null) {
                    passed[c] = velocity.method_1027() >= this.vrMovementInfo.thresholds()[0] * this.vrMovementInfo.thresholds()[0];
                    continue;
                }
                if (this.vrMovementInfo.thresholds().length == 2) {
                    posThreshold = Math.max(this.vrMovementInfo.thresholds()[0], this.vrMovementInfo.thresholds()[1]);
                    negThreshold = Math.min(this.vrMovementInfo.thresholds()[0], this.vrMovementInfo.thresholds()[1]);
                } else {
                    posThreshold = Math.max(this.vrMovementInfo.thresholds()[0], 0.0);
                    negThreshold = Math.min(this.vrMovementInfo.thresholds()[0], 0.0);
                }
                class_243 class_2432 = this.vrMovementInfo.relativeAxis() == class_2350.class_2351.field_11048 ? this.xVec : (velocityMask = this.vrMovementInfo.relativeAxis() == class_2350.class_2351.field_11052 ? this.yVec : this.zVec);
                if (posThreshold != 0.0) {
                    boolean bl = passed[c] = this.getNonZeroComponent(velocity.method_18806(velocityMask)) >= posThreshold;
                }
                if (negThreshold == 0.0) continue;
                passed[c] = passed[c] || this.getNonZeroComponent(velocity.method_18806(velocityMask)) <= negThreshold;
            }
            if (switch (this.vrMovementInfo.controllerMode()) {
                case HitboxVRMovementInfoBuilder.ControllerMode.PRIMARY -> passed[0];
                case HitboxVRMovementInfoBuilder.ControllerMode.SECONDARY -> passed[1];
                case HitboxVRMovementInfoBuilder.ControllerMode.EITHER -> passed[0] || passed[1];
                case HitboxVRMovementInfoBuilder.ControllerMode.BOTH -> passed[0] && passed[1];
                default -> throw new IllegalArgumentException("Invalid controllerMOde for HitboxVRMovementInfo.");
            }) {
                ArrayList<class_1268> passedHands = new ArrayList<class_1268>(2);
                if (passed[0]) {
                    passedHands.add(class_1268.field_5808);
                }
                if (passed[1]) {
                    passedHands.add(class_1268.field_5810);
                }
                this.vrMovementInfo.actionConsumer().accept(info, passedHands);
            }
        }
        this.didCalc = true;
    }

    public class_238 getRenderHitbox(float partialTick) {
        if (!this.didCalc) {
            throw new IllegalStateException("Should call recalculate() or forceNull() before getting render hitbox.");
        }
        if (this.lastPos == null || this.constantOffset) {
            return this.box;
        }
        return this.box.method_997(ClientUtil.lerpVec3(this.lastPos, this.pos, partialTick).method_1020(this.lastPos));
    }

    public void onOrientationChange() {
        this.lastPos = null;
    }

    private void recalcHorizBlockFacing(class_2350 blockFacing, BuiltImmersiveInfoImpl<?> info, class_243 offset) {
        this.recalcHorizBlockFacing(blockFacing, info, offset, class_2350.field_11036);
    }

    private void recalcHorizBlockFacing(class_2350 blockFacing, BuiltImmersiveInfoImpl<?> info, class_243 offset, class_2350 blockLiteralFacing) {
        class_2338 pos = info.getBlockPosition();
        this.xVec = blockLiteralFacing.method_10166() != class_2350.class_2351.field_11052 ? new class_243(0.0, 1.0, 0.0) : class_243.method_24954((class_2382)blockFacing.method_10160().method_10163());
        this.yVec = class_243.method_24954((class_2382)blockLiteralFacing.method_10163());
        this.zVec = class_243.method_24954((class_2382)blockFacing.method_10163());
        this.centerPos = class_243.method_24953((class_2382)info.getBlockPosition()).method_1019(this.zVec.method_1021(0.5));
        double actualXSize = blockFacing.method_10166() == class_2350.class_2351.field_11048 ? this.sizeZ : this.sizeX;
        double actualYSize = this.sizeY;
        double actualZSize = blockFacing.method_10166() == class_2350.class_2351.field_11048 ? this.sizeX : this.sizeZ;
        this.pos = this.centerPos.method_1019(this.xVec.method_1021(offset.field_1352)).method_1019(this.yVec.method_1021(offset.field_1351)).method_1019(this.zVec.method_1021(offset.field_1350));
        this.box = class_238.method_30048((class_243)this.pos, (double)actualXSize, (double)actualYSize, (double)actualZSize);
    }

    private void recalcTopBottomBlockFacing(class_2350 blockFacing, BuiltImmersiveInfoImpl<?> info, class_243 offset, boolean bottomOfBlock) {
        class_2338 pos = info.getBlockPosition();
        this.xVec = class_243.method_24954((class_2382)blockFacing.method_10170().method_10163());
        this.yVec = class_243.method_24954((class_2382)blockFacing.method_10163());
        this.zVec = new class_243(0.0, 1.0, 0.0);
        this.centerPos = class_243.method_24955((class_2382)pos).method_1031(0.0, bottomOfBlock ? 0.0 : 1.0, 0.0);
        double actualXSize = blockFacing.method_10166() == class_2350.class_2351.field_11048 ? this.sizeY : this.sizeX;
        double actualYSize = this.sizeZ;
        double actualZSize = blockFacing.method_10166() == class_2350.class_2351.field_11048 ? this.sizeX : this.sizeY;
        this.pos = this.centerPos.method_1019(this.xVec.method_1021(offset.field_1352)).method_1019(this.yVec.method_1021(offset.field_1351)).method_1019(this.zVec.method_1021(offset.field_1350));
        this.box = class_238.method_30048((class_243)this.pos, (double)actualXSize, (double)actualYSize, (double)actualZSize);
    }

    private void recalcTopPlayerFacing(class_2350 playerFacing, BuiltImmersiveInfoImpl<?> info, class_243 offset) {
        class_2338 pos = info.getBlockPosition();
        this.xVec = class_243.method_24954((class_2382)playerFacing.method_10160().method_10163());
        this.yVec = class_243.method_24954((class_2382)playerFacing.method_10153().method_10163());
        this.zVec = new class_243(0.0, 1.0, 0.0);
        this.centerPos = class_243.method_24955((class_2382)pos).method_1031(0.0, 1.0, 0.0);
        double actualXSize = playerFacing.method_10166() == class_2350.class_2351.field_11048 ? this.sizeY : this.sizeX;
        double actualYSize = this.sizeZ;
        double actualZSize = playerFacing.method_10166() == class_2350.class_2351.field_11048 ? this.sizeX : this.sizeY;
        this.pos = this.centerPos.method_1019(this.xVec.method_1021(offset.field_1352)).method_1019(this.yVec.method_1021(offset.field_1351)).method_1019(this.zVec.method_1021(offset.field_1350));
        this.box = class_238.method_30048((class_243)this.pos, (double)actualXSize, (double)actualYSize, (double)actualZSize);
    }

    private void calcTextOffsets(BuiltImmersiveInfoImpl<?> info) {
        if (this.textSupplier != null) {
            List<Pair<class_2561, class_243>> textList = this.textSupplier.apply(info);
            this.textData.clear();
            if (textList != null) {
                for (Pair<class_2561, class_243> pair : textList) {
                    if (pair == null) continue;
                    this.textData.add(new TextData((class_2561)pair.getFirst(), this.xVec.method_1021(((class_243)pair.getSecond()).field_1352).method_1019(this.yVec.method_1021(((class_243)pair.getSecond()).field_1351)).method_1019(this.zVec.method_1021(((class_243)pair.getSecond()).field_1350))));
                }
            }
        }
    }

    private double getNonZeroComponent(class_243 vec) {
        return vec.field_1352 != 0.0 ? vec.field_1352 : (vec.field_1351 != 0.0 ? vec.field_1351 : vec.field_1350);
    }

    public class_238 getAABB() {
        if (!this.didCalc) {
            throw new IllegalStateException("Should call recalculate() or forceNull() before getting hitbox.");
        }
        return this.box;
    }

    public class_2350 getUpDownRenderDir() {
        if (!this.didCalc) {
            throw new IllegalStateException("Should call recalculate() or forceNull() before getting upDownRenderDir.");
        }
        return this.upDownRenderDir;
    }

    public boolean hasAABB() {
        return this.box != null;
    }

    public List<TextData> getTextData() {
        return this.textData;
    }

    public boolean calcDone() {
        return this.didCalc;
    }

    public Object clone() {
        return this.cloneWithNewOffset(this.centerOffset);
    }

    public RelativeHitboxInfoImpl cloneWithNewOffset(Function<BuiltImmersiveInfo<?>, class_243> newOffset) {
        return ((RelativeHitboxInfoBuilderImpl)this.getBuilderClone().setCenterOffset((Function)newOffset)).build();
    }

    @Override
    public RelativeHitboxInfoImpl cloneWithAddedOffset(class_243 offset) {
        return ((RelativeHitboxInfoBuilderImpl)this.getBuilderClone().setCenterOffset(info -> {
            class_243 offsetOut = this.centerOffset.apply((BuiltImmersiveInfo<?>)info);
            if (offsetOut == null) {
                return null;
            }
            return offsetOut.method_1019(offset);
        })).build();
    }

    @Override
    public RelativeHitboxInfoBuilderImpl getBuilderClone() {
        return this.usedBuilder.clone();
    }

    @Override
    public BoundingBox getHitbox() {
        return this.hasAABB() ? this.getAABB() : null;
    }

    @Override
    public boolean isTriggerHitbox() {
        return this.isTriggerHitbox;
    }
}

