/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveClientConstants;
import com.hammy275.immersivemc.api.client.ImmersiveClientLogicHelpers;
import com.hammy275.immersivemc.api.client.ImmersiveConfigScreenInfo;
import com.hammy275.immersivemc.api.client.ImmersiveRenderHelpers;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.ChestInfo;
import com.hammy275.immersivemc.common.compat.Lootr;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ListOfItemsStorage;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.ChestShulkerOpenPacket;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.common.vr.VRRumble;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2611;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class ImmersiveChest
extends AbstractImmersive<ChestInfo, ListOfItemsStorage> {
    public static final double spacing = 0.1875;
    private final double threshold = 0.03;
    public int openCloseCooldown = 0;

    @Override
    public void globalTick() {
        super.globalTick();
        if (this.openCloseCooldown > 0) {
            --this.openCloseCooldown;
        }
        this.infos.removeIf(info -> !this.chestsValid((ChestInfo)info));
    }

    @Override
    public ChestInfo buildInfo(class_2338 pos, class_1937 level) {
        class_2586 blockEnt = level.method_8321(pos);
        if (blockEnt instanceof class_2595) {
            return new ChestInfo(blockEnt, (class_2586)Util.getOtherChest((class_2595)blockEnt));
        }
        if (blockEnt instanceof class_2611) {
            return new ChestInfo(blockEnt, null);
        }
        throw new IllegalArgumentException("ImmersiveChest can only track chests and ender chests!");
    }

    @Override
    public int handleHitboxInteract(ChestInfo info, class_746 player, List<Integer> hitboxIndices, class_1268 hand, boolean modifierPressed) {
        if (!info.isOpen) {
            return -1;
        }
        ImmersiveClientLogicHelpers.instance().sendSwapPacket(info.getBlockPosition(), hitboxIndices, hand, false);
        return ImmersiveClientConstants.instance().defaultCooldown();
    }

    @Override
    public boolean shouldRender(ChestInfo info) {
        return info.hasHitboxes();
    }

    @Override
    public void render(ChestInfo info, class_4587 stack, ImmersiveRenderHelpers helpers, float partialTick) {
        int i;
        if (info.isOpen) {
            boolean showCount;
            int endTop;
            int startTop;
            for (i = 0; i < 27; ++i) {
                startTop = 9 * info.getRowNum();
                endTop = startTop + 9;
                showCount = i >= startTop && i <= endTop;
                helpers.renderItemWithInfo(info.hitboxes.get((int)i).item, stack, 0.25f, showCount, info.light, info, true, i, null, info.forward, class_2350.field_11036);
            }
            if (info.otherChest != null) {
                for (i = 27; i < 54; ++i) {
                    startTop = 9 * info.getRowNum() + 27;
                    endTop = startTop + 9 + 27;
                    showCount = i >= startTop && i <= endTop;
                    helpers.renderItemWithInfo(info.hitboxes.get((int)i).item, stack, 0.25f, showCount, info.light, info, true, i, null, info.forward, class_2350.field_11036);
                }
            }
        }
        for (i = 0; i <= 1; ++i) {
            if (info.openCloseHitboxes[i] == null || info.openClosePositions[i] == null) continue;
            helpers.renderHitbox(stack, (BoundingBox)info.openCloseHitboxes[i]);
        }
    }

    @Override
    public void tick(ChestInfo info) {
        class_2586 chest;
        super.tick(info);
        info.light = ImmersiveClientLogicHelpers.instance().getLight(info.getBlockPosition().method_10084());
        class_2586 class_25862 = class_310.method_1551().field_1687.method_8321(info.getBlockPosition());
        if (class_25862 instanceof class_2595) {
            class_2595 cbe = (class_2595)class_25862;
            info.otherChest = Util.getOtherChest(cbe);
        }
        class_2586[] chests = new class_2586[]{info.chest, info.otherChest};
        for (int i = 0; i <= 1; ++i) {
            chest = chests[i];
            if (chest == null) continue;
            info.forward = (class_2350)chest.method_11010().method_11654((class_2769)class_2383.field_11177);
            class_243[] positions = Util.get3x3HorizontalGrid(chest.method_11016(), 0.1875, info.forward, false);
            float hitboxSize = 0.18333334f;
            int startTop = 9 * info.getRowNum() + 27 * i;
            int endTop = startTop + 9;
            for (int z = startTop; z < endTop; ++z) {
                class_243 pos = positions[z % 9];
                double offset = (double)(z - startTop) * 2.0E-4;
                info.getAllHitboxes().get((int)z).box = class_238.method_30048((class_243)pos.method_1031(offset, -0.2 + offset, offset), (double)hitboxSize, (double)hitboxSize, (double)hitboxSize);
            }
            int startMid = 9 * info.getNextRow(info.getRowNum()) + 27 * i;
            int endMid = startMid + 9;
            for (int z = startMid; z < endMid; ++z) {
                class_243 pos = positions[z % 9];
                double offset = (double)(z - startMid) * 2.0E-4;
                info.getAllHitboxes().get((int)z).box = class_238.method_30048((class_243)pos.method_1031(offset, -0.325 + offset, offset), (double)0.0, (double)0.0, (double)0.0);
            }
            int startBot = 9 * info.getNextRow(info.getNextRow(info.getRowNum())) + 27 * i;
            int endBot = startBot + 9;
            for (int z = startBot; z < endBot; ++z) {
                class_243 pos = positions[z % 9];
                double offset = (double)(z - startBot) * 2.0E-4;
                info.getAllHitboxes().get((int)z).box = class_238.method_30048((class_243)pos.method_1031(offset, -0.45 + offset, offset), (double)0.0, (double)0.0, (double)0.0);
            }
        }
        for (int chestNum = 0; chestNum <= 1; ++chestNum) {
            class_243 linePos;
            chest = chests[chestNum];
            if (chest == null) continue;
            class_243 forward = class_243.method_24954((class_2382)info.forward.method_10163());
            class_243 left = class_243.method_24954((class_2382)info.forward.method_10160().method_10163());
            class_243 frontMid = class_243.method_26410((class_2382)chest.method_11016(), (double)1.0).method_1019(forward.method_18805(0.5, 0.5, 0.5));
            if (info.isOpen) {
                linePos = frontMid.method_1019(forward.method_18805(-0.5, -0.5, -0.5));
                info.openClosePositions[chestNum] = linePos = linePos.method_1031(0.0, 0.5, 0.0);
                info.openCloseHitboxes[chestNum] = new class_238(linePos.method_1019(left.method_18805(-0.5, -0.5, -0.5)).method_1031(0.0, -0.25, 0.0).method_1019(forward.method_18805(-0.625, -0.625, -0.625)), linePos.method_1019(left.method_18805(0.5, 0.5, 0.5)).method_1031(0.0, 0.25, 0.0).method_1019(forward.method_18805(0.625, 0.625, 0.625)));
                continue;
            }
            info.openClosePositions[chestNum] = linePos = frontMid.method_1031(0.0, -0.375, 0.0);
            info.openCloseHitboxes[chestNum] = new class_238(linePos.method_1019(left.method_18805(-0.5, -0.5, -0.5)).method_1031(0.0, -0.25, 0.0).method_1019(forward.method_18805(-0.15, -0.15, -0.15)), linePos.method_1019(left.method_18805(0.5, 0.5, 0.5)).method_1031(0.0, 0.25, 0.0).method_1019(forward.method_18805(0.15, 0.15, 0.15)));
        }
        if (this.openCloseCooldown <= 0 && !ActiveConfig.active().rightClickChestInteractions && VRPluginVerify.clientInVR() && VRPlugin.API.apiActive((class_1657)class_310.method_1551().field_1724) && info.openCloseHitboxes != null) {
            boolean cond;
            class_243 current0 = VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724).getController0().position();
            class_243 current1 = VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724).getController1().position();
            double diff0 = current0.field_1351 - info.lastY0;
            double diff1 = current1.field_1351 - info.lastY1;
            if (Util.getFirstIntersect(current0, (BoundingBox[])info.openCloseHitboxes).isEmpty()) {
                diff0 = 0.0;
            }
            if (Util.getFirstIntersect(current1, (BoundingBox[])info.openCloseHitboxes).isEmpty()) {
                diff1 = 0.0;
            }
            if (info.isOpen) {
                cond = diff0 <= -0.03 || diff1 <= -0.03;
            } else {
                boolean bl = cond = diff0 >= 0.03 || diff1 >= 0.03;
            }
            if (cond) {
                if (!info.isOpen) {
                    if (diff0 >= 0.03) {
                        VRRumble.rumbleIfVR((class_1657)class_310.method_1551().field_1724, 0, 0.15f);
                        if (diff1 >= 0.006 && current0.method_1025(current1) <= 1.0) {
                            VRRumble.rumbleIfVR((class_1657)class_310.method_1551().field_1724, 1, 0.15f);
                        }
                    }
                    if (diff1 >= 0.03) {
                        VRRumble.rumbleIfVR((class_1657)class_310.method_1551().field_1724, 1, 0.15f);
                        if (diff0 >= 0.006 && current0.method_1025(current1) <= 1.0) {
                            VRRumble.rumbleIfVR((class_1657)class_310.method_1551().field_1724, 0, 0.15f);
                        }
                    }
                }
                ImmersiveChest.openChest(info);
                this.openCloseCooldown = 40;
            }
            info.lastY0 = current0.field_1351;
            info.lastY1 = current1.field_1351;
        }
    }

    @Nullable
    public class_238 getDragHitbox(ChestInfo info) {
        return null;
    }

    @Override
    public boolean isInputHitbox(ChestInfo info, int hitboxIndex) {
        return true;
    }

    @Override
    public ImmersiveHandler<ListOfItemsStorage> getHandler() {
        return ImmersiveHandlers.chestHandler;
    }

    @Override
    @Nullable
    public ImmersiveConfigScreenInfo configScreenInfo() {
        return ClientUtil.createConfigScreenInfo("chest", () -> new class_1799((class_1935)class_1802.field_8106), config -> config.useChestImmersive, (config, newVal) -> {
            config.useChestImmersive = newVal;
        });
    }

    @Override
    public boolean shouldDisableRightClicksWhenVanillaInteractionsDisabled(ChestInfo info) {
        return true;
    }

    @Override
    public void processStorageFromNetwork(ChestInfo info, ListOfItemsStorage storage) {
        for (int i = 0; i < storage.getItems().size(); ++i) {
            info.hitboxes.get((int)i).item = storage.getItems().get(i);
        }
    }

    @Override
    public boolean isVROnly() {
        return false;
    }

    public boolean chestsValid(ChestInfo info) {
        try {
            boolean mainChestExists = this.getHandler().isValidBlock(info.getBlockPosition(), info.chest.method_10997());
            boolean otherChestExists = info.otherChest == null || info.chest.method_10997() != null && info.chest.method_10997().method_8321(info.otherPos) instanceof class_2595;
            return mainChestExists && otherChestExists;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static ChestInfo findImmersive(class_2586 chest) {
        Objects.requireNonNull(chest);
        for (ChestInfo info : Immersives.immersiveChest.getTrackedObjects()) {
            if (info.chest != chest && info.otherChest != chest) continue;
            return info;
        }
        return null;
    }

    public static void openChest(ChestInfo info) {
        info.isOpen = !info.isOpen;
        Network.INSTANCE.sendToServer(new ChestShulkerOpenPacket(info.getBlockPosition(), info.isOpen));
        if (info.isOpen) {
            Lootr.lootrImpl.markOpener((class_1657)class_310.method_1551().field_1724, info.getBlockPosition());
        }
    }
}

