/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.api_impl;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.api.client.ImmersiveRenderHelpers;
import com.hammy275.immersivemc.api.client.immersive.ImmersiveInfo;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.hitbox.HitboxInfo;
import com.hammy275.immersivemc.client.immersive.SwapTracker;
import com.hammy275.immersivemc.client.subscribe.ClientRenderSubscriber;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.obb.OBBClientUtil;
import com.hammy275.immersivemc.common.obb.OBBRotList;
import com.hammy275.immersivemc.common.obb.RotType;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

public class ImmersiveRenderHelpersImpl
implements ImmersiveRenderHelpers {
    public static final ImmersiveRenderHelpers INSTANCE = new ImmersiveRenderHelpersImpl();

    @Override
    public void renderItemWithInfo(class_1799 item, class_4587 stack, float size, boolean renderItemCounts, int light, ImmersiveInfo info, boolean shouldRenderItemGuide, int hitboxIndex, @Nullable Float spinDegrees, @Nullable class_2350 facing, @Nullable class_2350 upDown) {
        boolean hovered;
        HitboxInfo hitbox = info.getAllHitboxes().get(hitboxIndex);
        float partialTick = class_310.method_1551().method_60646().method_60637(true);
        boolean bl = hovered = info.getSlotHovered(0) == hitboxIndex || info.getSlotHovered(1) == hitboxIndex || SwapTracker.slotHovered(info, hitboxIndex);
        if (item == null || item.method_7960()) {
            if (shouldRenderItemGuide) {
                this.renderItemGuide(stack, hitbox.getRenderHitbox(partialTick), hovered, light);
            }
        } else {
            long ticksExisted = info.getTicksExisted();
            size = ticksExisted < 10L ? (size *= this.getTransitionMultiplier(info.getTicksExisted())) : (hovered ? size * 1.25f : size);
            BoundingBox bbox = hitbox.getRenderHitbox(partialTick);
            this.renderItem(item, stack, size, bbox, renderItemCounts, light, spinDegrees, facing, upDown);
        }
    }

    @Override
    public void renderItem(class_1799 item, class_4587 stack, float size, BoundingBox hitbox, boolean renderItemCounts, int light) {
        this.renderItem(item, stack, size, hitbox, renderItemCounts, light, null, null, null);
    }

    @Override
    public void renderItem(class_1799 item, class_4587 stack, float size, BoundingBox hitbox, boolean renderItemCounts, int light, @Nullable Float spinDegrees, @Nullable class_2350 facing, @Nullable class_2350 upDown) {
        class_4184 renderInfo = class_310.method_1551().field_1773.method_19418();
        class_243 pos = BoundingBox.getCenter(hitbox);
        if (item != null && item != class_1799.field_8037) {
            stack.method_22903();
            stack.method_22904(-renderInfo.method_19326().field_1352 + pos.field_1352, -renderInfo.method_19326().field_1351 + pos.field_1351, -renderInfo.method_19326().field_1350 + pos.field_1350);
            stack.method_22905(size, size, size);
            class_243 textPos = pos;
            float degreesRotation = 0.0f;
            if (spinDegrees != null) {
                degreesRotation = spinDegrees.floatValue();
            } else if (facing == class_2350.field_11039) {
                degreesRotation = 90.0f;
            } else if (facing == class_2350.field_11035) {
                degreesRotation = 180.0f;
            } else if (facing == class_2350.field_11034) {
                degreesRotation = 270.0f;
            }
            int upDownRot = 0;
            if (upDown == class_2350.field_11036) {
                upDownRot = 90;
                textPos = textPos.method_1031(0.0, 0.15, 0.0);
            } else if (upDown == class_2350.field_11033) {
                upDownRot = 270;
                textPos = textPos.method_1031(0.0, -0.15, 0.0);
            } else if (facing == class_2350.field_11039) {
                textPos = textPos.method_1031(-0.15, 0.0, 0.0);
            } else if (facing == class_2350.field_11035) {
                textPos = textPos.method_1031(0.0, 0.0, 0.15);
            } else if (facing == class_2350.field_11034) {
                textPos = textPos.method_1031(0.15, 0.0, 0.0);
            } else if (facing == class_2350.field_11043) {
                textPos = textPos.method_1031(0.0, 0.0, -0.15);
            } else if (facing == null) {
                class_243 textMove;
                this.faceTowardsPlayer(stack, BoundingBox.getCenter(hitbox));
                stack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                if (VRPluginVerify.hasAPI && VRPluginVerify.clientInVR()) {
                    IVRPlayer textMovePlayer = Platform.isDevelopmentEnvironment() ? VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724) : VRPlugin.API.getRenderVRPlayer();
                    textMove = textMovePlayer.getHMD().getLookAngle();
                } else {
                    textMove = class_310.method_1551().field_1724.method_5720();
                }
                textMove = textMove.method_18805(-0.05, -0.05, -0.05);
                textPos = textPos.method_1019(textMove);
            }
            if (facing != null) {
                stack.method_22907(class_7833.field_40716.rotationDegrees(degreesRotation));
                stack.method_22907(class_7833.field_40714.rotationDegrees((float)upDownRot));
            }
            class_811 type = facing == null ? class_811.field_4318 : class_811.field_4319;
            class_310.method_1551().method_1480().method_23177((class_1309)class_310.method_1551().field_1724, item, type, false, stack, (class_4597)class_310.method_1551().method_22940().method_23000(), (class_1937)class_310.method_1551().field_1687, light, class_4608.field_21444, 0);
            stack.method_22909();
            if (renderItemCounts && item.method_7947() > 1) {
                this.renderText((class_2561)class_2561.method_43470((String)String.valueOf(item.method_7947())), stack, textPos, light, facing == null ? 0.0025f : 0.01f);
            }
        }
        this.renderHitbox(stack, hitbox);
    }

    @Override
    public void renderItemGuide(class_4587 stack, BoundingBox hitbox, boolean isSelected, int light) {
        ClientRenderSubscriber.itemGuideRenderData.add(new ClientRenderSubscriber.ItemGuideRenderData(stack, hitbox, 0.2f, isSelected, light));
    }

    @Override
    public void renderHitbox(class_4587 stack, BoundingBox hitbox) {
        this.renderHitbox(stack, hitbox, false);
    }

    @Override
    public void renderHitbox(class_4587 stack, BoundingBox hitbox, boolean alwaysRender) {
        this.renderHitbox(stack, hitbox, alwaysRender, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void renderHitbox(class_4587 stack, BoundingBox hitbox, boolean alwaysRender, float red, float green, float blue) {
        this.renderHitbox(stack, hitbox, alwaysRender, red, green, blue, 1.0f);
    }

    @Override
    public void renderHitbox(class_4587 stack, BoundingBox hitbox, boolean alwaysRender, float red, float green, float blue, float alpha) {
        if ((class_310.method_1551().method_1561().method_3958() || alwaysRender) && hitbox != null) {
            if (hitbox.isAABB()) {
                class_4184 renderInfo = class_310.method_1551().field_1773.method_19418();
                stack.method_22903();
                stack.method_22904(-renderInfo.method_19326().field_1352, -renderInfo.method_19326().field_1351, -renderInfo.method_19326().field_1350);
                class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
                class_761.method_22982((class_4587)stack, (class_4588)buffer.getBuffer((class_1921)class_1921.field_21695), (class_238)hitbox.asAABB(), (float)red, (float)green, (float)blue, (float)alpha);
                stack.method_22909();
            } else {
                OBBClientUtil.renderOBB(stack, hitbox.asOBB(), alwaysRender, red, green, blue, alpha);
            }
        }
    }

    @Override
    public void renderText(class_2561 text, class_4587 stack, class_243 pos, int light, float textSize) {
        class_4184 renderInfo = class_310.method_1551().field_1773.method_19418();
        stack.method_22903();
        stack.method_22904(-renderInfo.method_19326().field_1352 + pos.field_1352, -renderInfo.method_19326().field_1351 + pos.field_1351, -renderInfo.method_19326().field_1350 + pos.field_1350);
        stack.method_22907(renderInfo.method_23767());
        stack.method_22905(textSize *= ActiveConfig.active().textScale, -textSize, textSize);
        class_327 font = class_310.method_1551().field_1772;
        float size = (float)(-font.method_27525((class_5348)text)) / 2.0f;
        font.method_30882(text, size, 0.0f, -1, false, stack.method_23760().method_23761(), (class_4597)class_310.method_1551().method_22940().method_23000(), class_327.class_6415.field_33993, 0, light);
        stack.method_22909();
    }

    @Override
    public void renderImage(class_4587 stack, class_2960 imageLocation, class_243 pos, float size, int light, @Nullable class_2350 facing) {
        this.renderImage(stack, imageLocation, 0.0f, 0.0f, 1.0f, 1.0f, pos, size, light, facing);
    }

    @Override
    public void renderImage(class_4587 stack, class_2960 imageLocation, float minImageU, float minImageV, float maxImageU, float maxImageV, class_243 pos, float size, int light, @Nullable class_2350 facing) {
        this.renderImage(stack, imageLocation, minImageU, minImageV, maxImageU, maxImageV, pos, size, light, 0.0f, facing);
    }

    @Override
    public void renderImage(class_4587 stack, class_2960 imageLocation, float minImageU, float minImageV, float maxImageU, float maxImageV, class_243 pos, float size, int light, float roll, @Nullable class_2350 facing) {
        class_4184 renderInfo = class_310.method_1551().field_1773.method_19418();
        stack.method_22903();
        stack.method_22904(-renderInfo.method_19326().field_1352 + pos.field_1352, -renderInfo.method_19326().field_1351 + pos.field_1351, -renderInfo.method_19326().field_1350 + pos.field_1350);
        stack.method_22905(size, size, size);
        if (facing == class_2350.field_11039) {
            stack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        } else if (facing == class_2350.field_11035) {
            stack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        } else if (facing == class_2350.field_11034) {
            stack.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
        } else if (facing == null) {
            this.faceTowardsPlayer(stack, pos);
            stack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        }
        stack.method_22907(class_7833.field_40717.rotationDegrees(roll));
        class_4588 consumer = class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23578((class_2960)imageLocation));
        class_4587.class_4665 pose = stack.method_23760();
        consumer.method_56824(pose, -0.5f, -0.25f, 0.0f).method_39415(-1).method_22913(minImageU, maxImageV).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        consumer.method_56824(pose, 0.5f, -0.25f, 0.0f).method_39415(-1).method_22913(maxImageU, maxImageV).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        consumer.method_56824(pose, 0.5f, 0.75f, 0.0f).method_39415(-1).method_22913(maxImageU, minImageV).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        consumer.method_56824(pose, -0.5f, 0.75f, 0.0f).method_39415(-1).method_22913(minImageU, minImageV).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        stack.method_22909();
    }

    @Override
    public float getTransitionMultiplier(long ticksExisted) {
        return Math.min(1.0f, 0.1f * ((float)ticksExisted + class_310.method_1551().method_60646().method_60637(true)));
    }

    @Override
    public float hoverScaleSizeMultiplier() {
        return 1.25f;
    }

    private void faceTowardsPlayer(class_4587 stack, class_243 renderPos) {
        if (VRPluginVerify.clientInVR()) {
            class_243 target = Platform.isDevelopmentEnvironment() ? VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724).getHMD().position() : VRPlugin.API.getRenderVRPlayer().getHMD().position();
            class_243 ray = target.method_1020(renderPos);
            class_243 rayNoY = ray.method_18805(1.0, 0.0, 1.0);
            OBBRotList rotList = OBBRotList.create().addRot(Math.atan2(ray.field_1350, ray.field_1352) + 1.5707963267948966, RotType.YAW).addRot(-Math.atan2(ray.field_1351, rayNoY.method_1033()), RotType.PITCH);
            stack.method_22907(rotList.asQuaternion());
        } else {
            stack.method_22907(class_310.method_1551().method_1561().method_24197());
        }
    }
}

