/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.fabric;

import immersive_melodies.Common;
import immersive_melodies.ItemGroups;
import immersive_melodies.Items;
import immersive_melodies.Sounds;
import immersive_melodies.fabric.resources.FabricMelody;
import immersive_melodies.network.ImmersivePayload;
import immersive_melodies.network.Network;
import immersive_melodies.resources.ServerMelodyManager;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public final class CommonFabric
implements ModInitializer {
    Network.Registrar fabricRegistrar = new Network.Registrar(this){

        @Override
        public <T extends ImmersivePayload> void register(class_8710.class_9154<T> type, class_9139<class_2540, T> codec, boolean isServer) {
            if (isServer) {
                PayloadTypeRegistry.playC2S().register(type, codec);
                ServerPlayNetworking.registerGlobalReceiver(type, (payload, ctx) -> ctx.server().execute(() -> payload.handle((class_1657)ctx.player())));
            } else {
                PayloadTypeRegistry.playS2C().register(type, codec);
                if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                    ClientProxy.register(type);
                }
            }
        }
    };

    private static <T> void registerHelper(class_2378<T> register, Consumer<Common.RegisterHelper<T>> consumer) {
        consumer.accept((name, value) -> class_2378.method_10230((class_2378)register, (class_2960)name, (Object)value));
    }

    public void onInitialize() {
        CommonFabric.registerHelper(class_7923.field_41178, Items::registerItems);
        CommonFabric.registerHelper(class_7923.field_41172, Sounds::registerSounds);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new FabricMelody());
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            ServerMelodyManager.server = server;
        });
        class_1761 group = FabricItemGroup.builder().method_47321(ItemGroups.getDisplayName()).method_47320(ItemGroups::getIcon).method_47317((enabledFeatures, entries) -> entries.method_45423(Items.getSortedItems())).method_47324();
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)Common.locate("group"), (Object)group);
        Network.register(this.fabricRegistrar);
        Network.registerSender(ServerPlayNetworking::send);
    }

    private static final class ClientProxy {
        private ClientProxy() {
        }

        public static <T extends ImmersivePayload> void register(class_8710.class_9154<T> type) {
            ClientPlayNetworking.registerGlobalReceiver(type, (payload, ctx) -> ctx.client().execute(() -> payload.handle((class_1657)ctx.player())));
        }
    }
}

