/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.theme;

import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.quest.theme.QuestTheme;
import dev.ftb.mods.ftbquests.quest.theme.SelectorProperties;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.ftb.mods.ftbquests.quest.theme.selector.AllSelector;
import dev.ftb.mods.ftbquests.quest.theme.selector.AndSelector;
import dev.ftb.mods.ftbquests.quest.theme.selector.IDSelector;
import dev.ftb.mods.ftbquests.quest.theme.selector.NotSelector;
import dev.ftb.mods.ftbquests.quest.theme.selector.TagSelector;
import dev.ftb.mods.ftbquests.quest.theme.selector.ThemeSelector;
import dev.ftb.mods.ftbquests.quest.theme.selector.TypeSelector;
import dev.ftb.mods.ftbquests.util.FileUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeLoader
implements class_4013 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeLoader.class);

    public void method_14491(class_3300 resourceManager) {
        ThemeLoader.loadTheme(resourceManager);
    }

    public static void loadTheme(class_3300 resourceManager) {
        HashMap<ThemeSelector, SelectorProperties> map = new HashMap<ThemeSelector, SelectorProperties>();
        try {
            class_2960 rl = FTBQuestsAPI.rl("ftb_quests_theme.txt");
            for (class_3298 class_32982 : resourceManager.method_14489(rl)) {
                try {
                    InputStream in = class_32982.method_14482();
                    try {
                        ThemeLoader.parse(map, FileUtils.read(in));
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to load FTB Quests theme file from " + String.valueOf(rl), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to load FTB Quests theme file", (Throwable)ex);
        }
        if (map.isEmpty()) {
            LOGGER.error("FTB Quests theme file is missing! Some mod has broken resource loading, inspect log for errors");
        }
        QuestTheme theme = new QuestTheme();
        theme.defaults = (SelectorProperties)map.remove(AllSelector.INSTANCE);
        if (theme.defaults == null) {
            theme.defaults = new SelectorProperties(AllSelector.INSTANCE);
        }
        theme.selectors.addAll(map.values());
        theme.selectors.sort(null);
        QuestTheme.instance = theme;
        LOGGER.debug("Theme:");
        LOGGER.debug("");
        LOGGER.debug("[*]");
        for (Map.Entry entry : theme.defaults.properties.entrySet()) {
            LOGGER.debug((String)entry.getKey() + ": " + theme.replaceVariables((String)entry.getValue(), 0));
        }
        for (SelectorProperties selectorProperties : theme.selectors) {
            LOGGER.debug("");
            LOGGER.debug("[" + String.valueOf(selectorProperties.selector) + "]");
            for (Map.Entry<String, String> entry : selectorProperties.properties.entrySet()) {
                LOGGER.debug(entry.getKey() + ": " + theme.replaceVariables(entry.getValue(), 0));
            }
        }
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        list.add("circle");
        list.add("square");
        list.add("rsquare");
        for (String s : ((String)ThemeProperties.EXTRA_QUEST_SHAPES.get()).split(",")) {
            list.add(s.trim());
        }
        list.add("none");
        QuestShape.reload(new ArrayList<String>(list));
    }

    private static void parse(Map<ThemeSelector, SelectorProperties> selectorPropertyMap, List<String> lines) {
        ArrayList<SelectorProperties> current = new ArrayList<SelectorProperties>();
        for (String line : lines) {
            String[] s1;
            int ei;
            int si;
            if ((line = line.trim()).isEmpty() || line.startsWith("//")) continue;
            if (line.length() > 2 && (si = line.indexOf(91)) < (ei = line.indexOf(93))) {
                current.clear();
                for (String sel : line.substring(si + 1, ei).split("\\|")) {
                    AndSelector andSelector = new AndSelector();
                    for (String sel1 : sel.trim().split("&")) {
                        ThemeSelector themeSelector = ThemeLoader.parse(Pattern.compile("\\s").matcher(sel1).replaceAll(""));
                        if (themeSelector == null) continue;
                        andSelector.selectors.add(themeSelector);
                    }
                    if (andSelector.selectors.isEmpty()) continue;
                    AndSelector selector = andSelector.selectors.size() == 1 ? andSelector.selectors.get(0) : andSelector;
                    current.add(selectorPropertyMap.computeIfAbsent(selector, SelectorProperties::new));
                }
                continue;
            }
            if (current.isEmpty() || (s1 = line.split(":", 2)).length != 2) continue;
            String k = s1[0].trim();
            String v = s1[1].trim();
            if (k.isEmpty() || v.isEmpty()) continue;
            for (SelectorProperties selectorProperties : current) {
                selectorProperties.properties.put(k, v);
            }
        }
    }

    @Nullable
    private static ThemeSelector parse(String sel) {
        if (sel.isEmpty()) {
            return null;
        }
        if (sel.equals("*")) {
            return AllSelector.INSTANCE;
        }
        if (sel.startsWith("!")) {
            ThemeSelector s = ThemeLoader.parse(sel.substring(1));
            return s == null ? null : new NotSelector(s);
        }
        if (QuestObjectType.NAME_MAP.map.containsKey(sel)) {
            return new TypeSelector((QuestObjectType)QuestObjectType.NAME_MAP.get(sel));
        }
        if (sel.startsWith("#")) {
            String s = sel.substring(1);
            return s.isEmpty() ? null : new TagSelector(s);
        }
        return QuestObjectBase.parseHexId(sel).map(IDSelector::new).orElse(null);
    }
}

