/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftbquests.net.SubmitTaskMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;

public class CustomTask
extends Task {
    public static final Predicate<QuestObjectBase> PREDICATE = object -> object instanceof CustomTask;
    private Check check = null;
    private int checkTimer = 1;
    private long maxProgress = 1L;
    private boolean enableButton = false;

    public CustomTask(long id, Quest quest) {
        super(id, quest);
    }

    public void setCheck(Check check) {
        this.check = check;
    }

    @Override
    public TaskType getType() {
        return TaskTypes.CUSTOM;
    }

    @Override
    public long getMaxProgress() {
        return this.maxProgress;
    }

    public void setCheckTimer(int checkTimer) {
        this.checkTimer = checkTimer;
    }

    public void setMaxProgress(long maxProgress) {
        this.maxProgress = maxProgress;
    }

    public void setEnableButton(boolean enableButton) {
        this.enableButton = enableButton;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        if (this.enableButton && canClick) {
            button.playClickSound();
            NetworkManager.sendToServer((class_8710)new SubmitTaskMessage(this.id));
        }
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return this.check == null ? 0 : this.checkTimer;
    }

    @Override
    public void writeNetData(class_9129 buffer) {
        super.writeNetData(buffer);
        buffer.method_10804(this.checkTimer);
        buffer.method_10791(this.maxProgress);
        buffer.method_52964(this.enableButton);
    }

    @Override
    public void readNetData(class_9129 buffer) {
        super.readNetData(buffer);
        this.checkTimer = buffer.method_10816();
        this.maxProgress = buffer.method_10792();
        this.enableButton = buffer.readBoolean();
    }

    @Override
    public void submitTask(TeamData teamData, class_3222 player, class_1799 craftedItem) {
        if (this.check != null && this.checkTaskSequence(teamData) && !teamData.isCompleted(this)) {
            this.check.check(new Data(this, teamData), player);
        }
    }

    @Override
    public boolean checkOnLogin() {
        return false;
    }

    @FunctionalInterface
    public static interface Check {
        public void check(Data var1, class_3222 var2);
    }

    public record Data(CustomTask task, TeamData teamData) {
        public long getProgress() {
            return this.teamData.getProgress(this.task);
        }

        public void setProgress(long l) {
            this.teamData.setProgress(this.task, l);
        }

        public void addProgress(long l) {
            this.teamData.addProgress(this.task, l);
        }
    }
}

