/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.KnownServerRegistries;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.AbstractBooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.util.TextUtils;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_167;
import net.minecraft.class_178;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_8779;
import net.minecraft.class_9129;

public class AdvancementTask
extends AbstractBooleanTask {
    private class_2960 advancement = class_2960.method_60654((String)"minecraft:story/root");
    private String criterion = "";

    public AdvancementTask(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.ADVANCEMENT;
    }

    @Override
    public void writeData(class_2487 nbt, class_7225.class_7874 provider) {
        super.writeData(nbt, provider);
        nbt.method_10582("advancement", this.advancement.toString());
        nbt.method_10582("criterion", this.criterion);
    }

    @Override
    public void readData(class_2487 nbt, class_7225.class_7874 provider) {
        super.readData(nbt, provider);
        this.advancement = class_2960.method_12829((String)nbt.method_10558("advancement"));
        this.criterion = nbt.method_10558("criterion");
    }

    @Override
    public void writeNetData(class_9129 buffer) {
        super.writeNetData(buffer);
        buffer.method_10812(this.advancement);
        buffer.method_10788(this.criterion, Short.MAX_VALUE);
    }

    @Override
    public void readNetData(class_9129 buffer) {
        super.readNetData(buffer);
        this.advancement = buffer.method_10810();
        this.criterion = buffer.method_10800(Short.MAX_VALUE);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        if (KnownServerRegistries.client != null && !KnownServerRegistries.client.advancements().isEmpty()) {
            Map advancements = KnownServerRegistries.client.advancements();
            KnownServerRegistries.AdvancementInfo def = (KnownServerRegistries.AdvancementInfo)advancements.values().iterator().next();
            config.addEnum("advancement", (Object)this.advancement, v -> {
                this.advancement = v;
            }, NameMap.of((Object)def.id(), (Object[])advancements.keySet().toArray(new class_2960[0])).icon(id -> ItemIcon.getItemIcon((class_1799)advancements.getOrDefault(id, def).icon())).name(id -> advancements.getOrDefault(id, def).name()).create()).setNameKey("ftbquests.task.ftbquests.advancement");
        } else {
            config.addString("advancement", this.advancement.toString(), v -> {
                this.advancement = class_2960.method_12829((String)v);
            }, "minecraft:story/root").setNameKey("ftbquests.task.ftbquests.advancement");
        }
        config.addString("criterion", this.criterion, v -> {
            this.criterion = v;
        }, "");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_2561 getAltTitle() {
        KnownServerRegistries.AdvancementInfo info;
        KnownServerRegistries.AdvancementInfo advancementInfo = info = KnownServerRegistries.client == null ? null : (KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements().get(this.advancement);
        if (info != null && !TextUtils.isComponentEmpty(info.name())) {
            return class_2561.method_43471((String)"ftbquests.task.ftbquests.advancement").method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)"").method_10852(info.name()).method_27692(class_124.field_1054));
        }
        return super.getAltTitle();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        KnownServerRegistries.AdvancementInfo info;
        KnownServerRegistries.AdvancementInfo advancementInfo = info = KnownServerRegistries.client == null ? null : (KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements().get(this.advancement);
        if (info != null && !info.icon().method_7960()) {
            return ItemIcon.getItemIcon((class_1799)info.icon());
        }
        return super.getAltIcon();
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 5;
    }

    @Override
    public boolean canSubmit(TeamData teamData, class_3222 player) {
        class_8779 advancementHolder = player.field_13995.method_3851().method_12896(this.advancement);
        if (advancementHolder == null) {
            return false;
        }
        class_167 progress = player.method_14236().method_12882(advancementHolder);
        if (this.criterion.isEmpty()) {
            return progress.method_740();
        }
        class_178 criterionProgress = progress.method_737(this.criterion);
        return criterionProgress != null && criterionProgress.method_784();
    }
}

