/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ReorderItemResponseMessage(long questId, List<Long> itemIds, boolean task) implements class_8710
{
    public static final class_8710.class_9154<ReorderItemResponseMessage> TYPE = new class_8710.class_9154(FTBQuestsAPI.rl("reorder_item_response"));
    public static final class_9139<class_2540, ReorderItemResponseMessage> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_48551, ReorderItemResponseMessage::questId, (class_9139)class_9135.field_48551.method_56433(class_9135.method_56363()), ReorderItemResponseMessage::itemIds, (class_9139)class_9135.field_48547, ReorderItemResponseMessage::task, ReorderItemResponseMessage::new);

    public static ReorderItemResponseMessage tasks(Quest quest) {
        return new ReorderItemResponseMessage(quest.id, quest.getTasks().stream().map(QuestObjectBase::getId).toList(), true);
    }

    public static ReorderItemResponseMessage rewards(Quest quest) {
        return new ReorderItemResponseMessage(quest.id, quest.getRewards().stream().map(QuestObjectBase::getId).toList(), false);
    }

    public static void handle(ReorderItemResponseMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ClientQuestFile file = ClientQuestFile.INSTANCE;
            Quest q = file.getQuest(message.questId);
            if (q != null) {
                if (message.task) {
                    List<Task> tasks = message.itemIds.stream().map(file::getTask).filter(Objects::nonNull).toList();
                    if (tasks.size() == message.itemIds.size()) {
                        q.setTaskList(tasks);
                    }
                } else {
                    List<Reward> rewards = message.itemIds.stream().map(file::getReward).filter(Objects::nonNull).toList();
                    if (rewards.size() == message.itemIds.size()) {
                        q.setRewardList(rewards);
                    }
                }
                q.editedFromGUI();
            }
        });
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}

