/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.net.CreateObjectResponseMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public record CopyQuestMessage(long id, long chapterId, double qx, double qy, boolean copyDeps) implements class_8710
{
    public static final class_8710.class_9154<CopyQuestMessage> TYPE = new class_8710.class_9154(FTBQuestsAPI.rl("copy_quest_message"));
    public static final class_9139<class_2540, CopyQuestMessage> STREAM_CODEC = class_9139.method_56906((class_9139)class_9135.field_48551, CopyQuestMessage::id, (class_9139)class_9135.field_48551, CopyQuestMessage::chapterId, (class_9139)class_9135.field_48553, CopyQuestMessage::qx, (class_9139)class_9135.field_48553, CopyQuestMessage::qy, (class_9139)class_9135.field_48547, CopyQuestMessage::copyDeps, CopyQuestMessage::new);

    public class_8710.class_9154<CopyQuestMessage> method_56479() {
        return TYPE;
    }

    public static void handle(CopyQuestMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerQuestFile file = ServerQuestFile.INSTANCE;
            QuestObject patt0$temp = file.get(message.id);
            if (patt0$temp instanceof Quest) {
                Quest toCopy = (Quest)patt0$temp;
                QuestObject patt1$temp = file.get(message.chapterId);
                if (patt1$temp instanceof Chapter) {
                    Chapter chapter = (Chapter)patt1$temp;
                    Quest newQuest = Objects.requireNonNull(QuestObjectBase.copy(toCopy, () -> new Quest(file.newID(), chapter)));
                    if (!message.copyDeps) {
                        newQuest.clearDependencies();
                    }
                    newQuest.setX(message.qx);
                    newQuest.setY(message.qy);
                    newQuest.onCreated();
                    toCopy.getTasks().forEach(task -> {
                        Task newTask = QuestObjectBase.copy(task, () -> TaskType.createTask(file.newID(), newQuest, task.getType().getTypeForNBT()));
                        if (newTask != null) {
                            newTask.onCreated();
                        }
                    });
                    for (Reward reward2 : toCopy.getRewards()) {
                        Reward newReward = QuestObjectBase.copy(reward2, () -> RewardType.createReward(file.newID(), newQuest, reward2.getType().getTypeForNBT()));
                        if (newReward == null) continue;
                        newReward.onCreated();
                    }
                    MinecraftServer server = context.getPlayer().method_5682();
                    NetworkHelper.sendToAll((MinecraftServer)server, (class_8710)CreateObjectResponseMessage.create(newQuest, null));
                    newQuest.getTasks().forEach(task -> {
                        class_2487 extra = new class_2487();
                        extra.method_10582("type", task.getType().getTypeForNBT());
                        NetworkHelper.sendToAll((MinecraftServer)server, (class_8710)CreateObjectResponseMessage.create(task, extra));
                    });
                    newQuest.getRewards().forEach(reward -> {
                        class_2487 extra = new class_2487();
                        extra.method_10582("type", reward.getType().getTypeForNBT());
                        NetworkHelper.sendToAll((MinecraftServer)server, (class_8710)CreateObjectResponseMessage.create(reward, extra));
                    });
                    ServerQuestFile.INSTANCE.refreshIDMap();
                    ServerQuestFile.INSTANCE.clearCachedData();
                    ServerQuestFile.INSTANCE.markDirty();
                }
            }
        });
    }
}

