/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.item_filtering;

import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.api.ItemFilterAdapter;
import dev.ftb.mods.ftbquests.integration.item_filtering.DisplayStacksCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_9323;

public enum ItemMatchingSystem {
    INSTANCE;

    private final List<ItemFilterAdapter> adapters = new CopyOnWriteArrayList<ItemFilterAdapter>();

    public void registerFilterAdapter(ItemFilterAdapter adapter) {
        this.adapters.add(adapter);
    }

    public boolean isItemFilter(class_1799 stack) {
        return this.getFilterAdapter(stack).isPresent();
    }

    public Optional<ItemFilterAdapter> getFilterAdapter(class_1799 stack) {
        return this.adapters.stream().filter(adapter -> adapter.isFilterStack(stack)).findFirst();
    }

    public boolean doesItemMatch(class_1799 filterStack, class_1799 toCheck, ComponentMatchType matchType) {
        return this.getFilterAdapter(filterStack).map(adapter -> adapter.doesItemMatch(filterStack, toCheck)).orElse(this.areItemStacksEqual(filterStack, toCheck, matchType));
    }

    public List<class_1799> getAllMatchingStacks(class_1799 filterStack) {
        ArrayList res = new ArrayList();
        this.adapters.forEach(adapter -> {
            if (adapter.isFilterStack(filterStack)) {
                res.addAll(DisplayStacksCache.getCachedDisplayStacks(filterStack, adapter));
            }
        });
        return res.isEmpty() ? List.of(filterStack) : res;
    }

    private boolean areItemStacksEqual(class_1799 stackA, class_1799 stackB, ComponentMatchType matchType) {
        if (stackA == stackB) {
            return true;
        }
        if (stackA.method_7909() != stackB.method_7909()) {
            return false;
        }
        return switch (matchType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> true;
            case 1 -> this.fuzzyMatch(stackA.method_57353(), stackB.method_57353());
            case 2 -> class_1799.method_31577((class_1799)stackA, (class_1799)stackB);
        };
    }

    private boolean fuzzyMatch(class_9323 map, class_9323 toMatch) {
        return map.method_57833().allMatch(tc -> toMatch.method_57832(tc.comp_2443()) && toMatch.method_57829(tc.comp_2443()).equals(tc.comp_2444()));
    }

    public Collection<ItemFilterAdapter> adapters() {
        return Collections.unmodifiableCollection(this.adapters);
    }

    public static enum ComponentMatchType {
        NONE("none"),
        FUZZY("fuzzy"),
        STRICT("strict");

        public static final NameMap<ComponentMatchType> NAME_MAP;
        private final String name;

        private ComponentMatchType(String name) {
            this.name = name;
        }

        static {
            NAME_MAP = NameMap.of((Object)((Object)NONE), (Object[])ComponentMatchType.values()).id(v -> v.name).create();
        }
    }
}

