/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.client.gui.quests.TooltipContextMenuItem;
import dev.ftb.mods.ftbquests.net.CreateObjectMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class AddTaskButton
extends Button {
    private final Quest quest;

    public AddTaskButton(Panel panel, Quest quest) {
        super(panel, (class_2561)class_2561.method_43471((String)"gui.add"), (Icon)ThemeProperties.ADD_ICON.get());
        this.quest = quest;
        this.setSize(18, 18);
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        for (TaskType type : TaskTypes.TYPES.values()) {
            contextMenu.add(new ContextMenuItem(type.getDisplayName(), type.getIconSupplier(), b -> {
                this.playClickSound();
                type.getGuiProvider().openCreationGui(this.parent, this.quest, (task, extra) -> NetworkManager.sendToServer((class_8710)CreateObjectMessage.create(task, extra)));
            }));
        }
        String clip = AddTaskButton.getClipboardString();
        if (!clip.isEmpty()) {
            QuestObjectBase.parseHexId(clip).ifPresent(taskId -> {
                QuestObject patt0$temp = FTBQuestsAPI.api().getQuestFile(true).get((long)taskId);
                if (patt0$temp instanceof Task) {
                    Task task = (Task)patt0$temp;
                    contextMenu.add(ContextMenuItem.SEPARATOR);
                    contextMenu.add(new PasteTaskMenuItem(task, b -> this.copyAndCreateTask(task)));
                }
            });
        }
        this.getGui().openContextMenu(contextMenu);
    }

    private void copyAndCreateTask(Task task) {
        Task newTask = QuestObjectBase.copy(task, () -> TaskType.createTask(0L, this.quest, task.getType().getTypeId().toString()));
        if (newTask != null) {
            NetworkManager.sendToServer((class_8710)CreateObjectMessage.create(newTask, newTask.getType().makeExtraNBT()));
        }
    }

    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(graphics, theme, x, y, w, h);
        }
    }

    public static class PasteTaskMenuItem
    extends TooltipContextMenuItem {
        public PasteTaskMenuItem(Task task, @Nullable Consumer<Button> callback) {
            super((class_2561)class_2561.method_43471((String)"ftbquests.gui.paste_task"), Icons.ADD, callback, new class_2561[]{class_2561.method_43470((String)"\"").method_10852(task.getTitle()).method_27693("\""), class_2561.method_43470((String)QuestObjectBase.getCodeString(task.id)).method_27692(class_124.field_1063)});
        }
    }
}

