/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_8828;
import org.jetbrains.annotations.Nullable;

public class TextComponentParser {
    public static final Char2ObjectOpenHashMap<class_124> CODE_TO_FORMATTING = (Char2ObjectOpenHashMap)class_156.method_654((Object)new Char2ObjectOpenHashMap(), map -> {
        map.put('0', (Object)class_124.field_1074);
        map.put('1', (Object)class_124.field_1058);
        map.put('2', (Object)class_124.field_1077);
        map.put('3', (Object)class_124.field_1062);
        map.put('4', (Object)class_124.field_1079);
        map.put('5', (Object)class_124.field_1064);
        map.put('6', (Object)class_124.field_1065);
        map.put('7', (Object)class_124.field_1080);
        map.put('8', (Object)class_124.field_1063);
        map.put('9', (Object)class_124.field_1078);
        map.put('a', (Object)class_124.field_1060);
        map.put('b', (Object)class_124.field_1075);
        map.put('c', (Object)class_124.field_1061);
        map.put('d', (Object)class_124.field_1076);
        map.put('e', (Object)class_124.field_1054);
        map.put('f', (Object)class_124.field_1068);
        map.put('k', (Object)class_124.field_1051);
        map.put('l', (Object)class_124.field_1067);
        map.put('m', (Object)class_124.field_1055);
        map.put('n', (Object)class_124.field_1073);
        map.put('o', (Object)class_124.field_1056);
        map.put('r', (Object)class_124.field_1070);
    });
    private final String text;
    private final Function<String, class_2561> substitutes;
    private class_5250 component;
    private StringBuilder builder;
    private class_2583 style;

    private TextComponentParser(String txt, @Nullable Function<String, class_2561> sub) {
        this.text = txt;
        this.substitutes = sub;
    }

    public static class_2561 parse(String text, @Nullable Function<String, class_2561> substitutes) {
        class_2561 c = TextComponentParser.parse0(text, substitutes);
        if (c == class_2561.field_25310) {
            return c;
        }
        while (c.method_10851() == class_8828.field_46625 && c.method_10866().equals((Object)class_2583.field_24360) && c.method_10855().size() == 1) {
            c = (class_2561)c.method_10855().get(0);
        }
        return c;
    }

    private static class_2561 parse0(String text, @Nullable Function<String, class_2561> substitutes) {
        try {
            return new TextComponentParser(text, substitutes).parse();
        }
        catch (BadFormatException ex) {
            return class_2561.method_43470((String)ex.getMessage()).method_27692(class_124.field_1061);
        }
        catch (Exception ex) {
            return class_2561.method_43470((String)ex.toString()).method_27692(class_124.field_1061);
        }
    }

    private class_2561 parse() throws BadFormatException {
        if (this.text.isEmpty()) {
            return class_2561.method_43473();
        }
        char[] c = this.text.replaceAll("\\\\n", "\n").toCharArray();
        boolean hasSpecialCodes = false;
        for (char c1 : c) {
            if (c1 != '{' && c1 != '&' && c1 != '\u00a7') continue;
            hasSpecialCodes = true;
            break;
        }
        if (!hasSpecialCodes) {
            return class_2561.method_43470((String)new String(c));
        }
        this.component = class_2561.method_43470((String)"");
        this.style = class_2583.field_24360;
        this.builder = new StringBuilder();
        boolean sub = false;
        for (int i = 0; i < c.length; ++i) {
            boolean end;
            boolean escape = i > 0 && c[i - 1] == '\\';
            boolean bl = end = i == c.length - 1;
            if (sub && (end || c[i] == '{' || c[i] == '}')) {
                if (c[i] == '{') {
                    throw new BadFormatException("Invalid formatting! Can't nest multiple substitutes!");
                }
                this.finishPart();
                sub = false;
                continue;
            }
            if (!escape) {
                if (c[i] == '&' || c[i] == '\u00a7') {
                    this.finishPart();
                    if (end) {
                        throw new BadFormatException("Invalid formatting! Can't end string with &!");
                    }
                    if (c[++i] == '#') {
                        char[] rrggbb = new char[7];
                        rrggbb[0] = 35;
                        System.arraycopy(c, i + 1, rrggbb, 1, 6);
                        i += 6;
                        this.style = this.style.method_27703(class_5251.method_27719((String)new String(rrggbb)).result().orElse(class_5251.method_27717((int)0xFFFFFF)));
                        continue;
                    }
                    if (c[i] == ' ') {
                        throw new BadFormatException("Invalid formatting! You must escape whitespace after & with \\&!");
                    }
                    class_124 formatting = (class_124)CODE_TO_FORMATTING.get(c[i]);
                    if (formatting == null) {
                        throw new BadFormatException("Invalid formatting! Unknown formatting symbol after &: '" + c[i] + "'!");
                    }
                    this.style = this.style.method_27706(formatting);
                    continue;
                }
                if (c[i] == '{') {
                    this.finishPart();
                    if (end) {
                        throw new BadFormatException("Invalid formatting! Can't end string with {!");
                    }
                    sub = true;
                }
            }
            if (c[i] == '\\' && !escape) continue;
            this.builder.append(c[i]);
        }
        this.finishPart();
        return this.component;
    }

    private void finishPart() throws BadFormatException {
        String string = this.builder.toString();
        this.builder.setLength(0);
        if (string.isEmpty()) {
            return;
        }
        if (string.length() < 2 || string.charAt(0) != '{') {
            class_5250 component1 = class_2561.method_43470((String)string);
            component1.method_10862(this.style);
            this.component.method_10852((class_2561)component1);
            return;
        }
        class_2561 component1 = this.substitutes.apply(string.substring(1));
        if (component1 == null) {
            throw new BadFormatException("Invalid formatting! Unknown substitute: " + string.substring(1));
        }
        class_2583 style0 = component1.method_10866();
        class_2583 style1 = this.style;
        style1 = style1.method_10949(style0.method_10969());
        style1 = style1.method_10958(style0.method_10970());
        style1 = style1.method_10975(style0.method_10955());
        component1 = class_2561.method_43470((String)"").method_10852(component1).method_27696(style1);
        this.component.method_10852(component1);
    }

    private static class BadFormatException
    extends IllegalArgumentException {
        private BadFormatException(String s) {
            super(s);
        }
    }
}

