/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import java.util.List;
import java.util.Stack;
import java.util.function.BiFunction;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class GuiHelper {
    public static final BaseScreen BLANK_GUI = new BaseScreen(){

        @Override
        public void addWidgets() {
        }

        @Override
        public void alignWidgets() {
        }
    };
    private static final BiFunction<Color4I, Boolean, Color4I> BRIGHTEN = class_156.method_34865((col, outset) -> col.addBrightness(outset != false ? 0.15f : -0.1f));
    private static final BiFunction<Color4I, Boolean, Color4I> DARKEN = class_156.method_34865((col, outset) -> col.addBrightness(outset != false ? -0.1f : 0.15f));
    private static final Stack<Scissor> SCISSOR = new Stack();

    public static void setupDrawing() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
    }

    public static void playSound(class_3414 event, float pitch) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)event, (float)pitch));
    }

    public static void drawTexturedRect(class_332 graphics, int x, int y, int w, int h, Color4I col, float u0, float v0, float u1, float v1) {
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        GuiHelper.addRectToBufferWithUV(graphics, buffer, x, y, w, h, col, u0, v0, u1, v1);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    public static void addRectToBuffer(class_332 graphics, class_287 buffer, int x, int y, int w, int h, Color4I col) {
        if (w <= 0 || h <= 0) {
            return;
        }
        Matrix4f m = graphics.method_51448().method_23760().method_23761();
        int r = col.redi();
        int g = col.greeni();
        int b = col.bluei();
        int a = col.alphai();
        buffer.method_22918(m, (float)x, (float)(y + h), 0.0f).method_1336(r, g, b, a);
        buffer.method_22918(m, (float)(x + w), (float)(y + h), 0.0f).method_1336(r, g, b, a);
        buffer.method_22918(m, (float)(x + w), (float)y, 0.0f).method_1336(r, g, b, a);
        buffer.method_22918(m, (float)x, (float)y, 0.0f).method_1336(r, g, b, a);
    }

    public static void addRectToBufferWithUV(class_332 graphics, class_287 buffer, int x, int y, int w, int h, Color4I col, float u0, float v0, float u1, float v1) {
        if (w <= 0 || h <= 0) {
            return;
        }
        Matrix4f m = graphics.method_51448().method_23760().method_23761();
        int r = col.redi();
        int g = col.greeni();
        int b = col.bluei();
        int a = col.alphai();
        buffer.method_22918(m, (float)x, (float)(y + h), 0.0f).method_22913(u0, v1).method_1336(r, g, b, a);
        buffer.method_22918(m, (float)(x + w), (float)(y + h), 0.0f).method_22913(u1, v1).method_1336(r, g, b, a);
        buffer.method_22918(m, (float)(x + w), (float)y, 0.0f).method_22913(u1, v0).method_1336(r, g, b, a);
        buffer.method_22918(m, (float)x, (float)y, 0.0f).method_22913(u0, v0).method_1336(r, g, b, a);
    }

    public static void drawHollowRect(class_332 graphics, int x, int y, int w, int h, Color4I col, boolean roundEdges) {
        if (w <= 1 || h <= 1 || col.isEmpty()) {
            col.draw(graphics, x, y, w, h);
            return;
        }
        RenderSystem.setShader(class_757::method_34540);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        GuiHelper.addRectToBuffer(graphics, buffer, x, y + 1, 1, h - 2, col);
        GuiHelper.addRectToBuffer(graphics, buffer, x + w - 1, y + 1, 1, h - 2, col);
        if (roundEdges) {
            GuiHelper.addRectToBuffer(graphics, buffer, x + 1, y, w - 2, 1, col);
            GuiHelper.addRectToBuffer(graphics, buffer, x + 1, y + h - 1, w - 2, 1, col);
        } else {
            GuiHelper.addRectToBuffer(graphics, buffer, x, y, w, 1, col);
            GuiHelper.addRectToBuffer(graphics, buffer, x, y + h - 1, w, 1, col);
        }
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    public static void drawRectWithShade(class_332 graphics, int x, int y, int w, int h, Color4I col, int intensity) {
        RenderSystem.setShader(class_757::method_34540);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        GuiHelper.addRectToBuffer(graphics, buffer, x, y, w - 1, 1, col);
        GuiHelper.addRectToBuffer(graphics, buffer, x, y + 1, 1, h - 1, col);
        col = col.mutable().addBrightness(-intensity);
        GuiHelper.addRectToBuffer(graphics, buffer, x + w - 1, y, 1, 1, col);
        GuiHelper.addRectToBuffer(graphics, buffer, x, y + h - 1, 1, 1, col);
        col = col.mutable().addBrightness(-intensity);
        GuiHelper.addRectToBuffer(graphics, buffer, x + w - 1, y + 1, 1, h - 2, col);
        GuiHelper.addRectToBuffer(graphics, buffer, x + 1, y + h - 1, w - 1, 1, col);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    public static void drawGradientRect(class_332 graphics, int x, int y, int w, int h, Color4I col1, Color4I col2) {
        graphics.method_25296(x, y, x + w, y + h, col1.rgba(), col2.rgba());
    }

    public static void drawItem(class_332 graphics, class_1799 stack, int hash, boolean renderOverlay, @Nullable String text) {
        if (stack.method_7960()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(-8.0f, -8.0f, -8.0f);
        graphics.method_51427(stack, 0, 0);
        if (renderOverlay) {
            graphics.method_51432(mc.field_1772, stack, 0, 0, text);
        }
        graphics.method_51448().method_22909();
    }

    private static void draw(class_332 graphics, class_289 t, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        if (width <= 0 || height <= 0) {
            return;
        }
        RenderSystem.setShader(class_757::method_34540);
        Matrix4f m = graphics.method_51448().method_23760().method_23761();
        class_287 buffer = t.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(m, (float)x, (float)y, 0.0f).method_1336(red, green, blue, alpha);
        buffer.method_22918(m, (float)x, (float)(y + height), 0.0f).method_1336(red, green, blue, alpha);
        buffer.method_22918(m, (float)(x + width), (float)(y + height), 0.0f).method_1336(red, green, blue, alpha);
        buffer.method_22918(m, (float)(x + width), (float)y, 0.0f).method_1336(red, green, blue, alpha);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    public static void pushScissor(class_1041 screen, int x, int y, int w, int h) {
        if (SCISSOR.isEmpty()) {
            GL11.glEnable((int)3089);
        }
        Scissor scissor = SCISSOR.isEmpty() ? new Scissor(x, y, w, h) : ((Scissor)SCISSOR.lastElement()).crop(x, y, w, h);
        SCISSOR.push(scissor);
        scissor.scissor(screen);
    }

    public static void popScissor(class_1041 screen) {
        SCISSOR.pop();
        if (SCISSOR.isEmpty()) {
            GL11.glDisable((int)3089);
        } else {
            ((Scissor)SCISSOR.lastElement()).scissor(screen);
        }
    }

    public static String clickEventToString(@Nullable class_2558 event) {
        if (event == null) {
            return "";
        }
        return switch (event.method_10845()) {
            case class_2558.class_2559.field_11749, class_2558.class_2559.field_11748 -> event.method_10844();
            case class_2558.class_2559.field_11746 -> "file:" + event.method_10844();
            case class_2558.class_2559.field_11750 -> "command:" + event.method_10844();
            case class_2558.class_2559.field_11745 -> "suggest_command:" + event.method_10844();
            default -> "";
        };
    }

    public static void addStackTooltip(class_1799 stack, List<class_2561> list) {
        GuiHelper.addStackTooltip(stack, list, null);
    }

    public static void addStackTooltip(class_1799 stack, List<class_2561> list, @Nullable class_2561 prefix) {
        List tooltip = stack.method_7950(class_1792.class_9635.method_59528((class_1937)class_310.method_1551().field_1687), (class_1657)class_310.method_1551().field_1724, (class_1836)(class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070));
        list.add((class_2561)(prefix == null ? ((class_2561)tooltip.get(0)).method_27661().method_27692(stack.method_7932().method_58413()) : prefix.method_27661().method_10852((class_2561)tooltip.get(0))));
        for (int i = 1; i < tooltip.size(); ++i) {
            list.add((class_2561)class_2561.method_43470((String)"").method_27692(class_124.field_1080).method_10852((class_2561)tooltip.get(i)));
        }
    }

    public static void drawBorderedPanel(class_332 graphics, int x, int y, int w, int h, Color4I color, boolean outset) {
        Color4I hi = BRIGHTEN.apply(color, outset);
        Color4I lo = DARKEN.apply(color, outset);
        graphics.method_25294(x, y, x + --w, y + --h, color.rgba());
        graphics.method_25292(x, x + w - 1, y, hi.rgba());
        graphics.method_25292(x + w, x + w, y, color.rgba());
        graphics.method_25301(x, y, y + h, hi.rgba());
        graphics.method_25301(x, y + h, y + h, color.rgba());
        graphics.method_25292(x + 1, x + w, y + h, lo.rgba());
        graphics.method_25301(x + w, y, y + h, lo.rgba());
    }

    private static class Scissor {
        private final int x;
        private final int y;
        private final int w;
        private final int h;

        private Scissor(int _x, int _y, int _w, int _h) {
            this.x = _x;
            this.y = _y;
            this.w = Math.max(0, _w);
            this.h = Math.max(0, _h);
        }

        public Scissor crop(int sx, int sy, int sw, int sh) {
            int x0 = Math.max(this.x, sx);
            int y0 = Math.max(this.y, sy);
            int x1 = Math.min(this.x + this.w, sx + sw);
            int y1 = Math.min(this.y + this.h, sy + sh);
            return new Scissor(x0, y0, x1 - x0, y1 - y0);
        }

        public void scissor(class_1041 screen) {
            double scale = screen.method_4495();
            int sx = (int)((double)this.x * scale);
            int sy = (int)((double)(screen.method_4502() - (this.y + this.h)) * scale);
            int sw = (int)((double)this.w * scale);
            int sh = (int)((double)this.h * scale);
            GL11.glScissor((int)sx, (int)sy, (int)sw, (int)sh);
        }
    }
}

