/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.goals;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.activestate.ShoulderedState;
import java.util.Arrays;
import java.util.EnumSet;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_3222;

public class PokemonAttackGoal
extends class_1352 {
    private int ticksUntilNewAngerParticle = 0;
    private int ticksUntilNewAngerCry = 0;
    private int seeTime;
    private float attackRadiusSqr;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private int ticksUntilNextPathFinding = 0;
    private final double speedModifier;
    protected PokemonEntity pokemonEntity;
    private class_1309 target;

    public PokemonAttackGoal(PokemonEntity pokemonEntity, double speedModifier) {
        this.pokemonEntity = pokemonEntity;
        this.speedModifier = speedModifier;
        this.attackRadiusSqr = 64.0f;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
    }

    protected void setAttackTime(int i) {
        ((PokemonInterface)this.pokemonEntity).setAttackTime(i);
    }

    protected int getAttackTime() {
        return ((PokemonInterface)this.pokemonEntity).getAttackTime();
    }

    protected void resetAttackTime(double d) {
        PokemonAttackEffect.resetAttackTime(this.pokemonEntity, d);
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        super.method_6268();
        class_1309 owner = this.pokemonEntity.method_35057();
        if (owner == null) {
            if (this.ticksUntilNewAngerParticle < 1) {
                CobblemonFightOrFlight.PokemonEmoteAngry((class_1308)this.pokemonEntity);
                this.ticksUntilNewAngerParticle = 10;
            } else {
                --this.ticksUntilNewAngerParticle;
            }
            if (this.ticksUntilNewAngerCry < 1) {
                this.pokemonEntity.cry();
                this.ticksUntilNewAngerCry = 100 + (int)(Math.random() * 200.0);
            } else {
                --this.ticksUntilNewAngerCry;
            }
        }
        this.ticksUntilNextPathFinding = Math.max(this.ticksUntilNextPathFinding - 1, 0);
        if (PokemonUtils.shouldMelee(this.pokemonEntity)) {
            if (this.ticksUntilNextPathFinding <= 0) {
                this.ticksUntilNextPathFinding = 4 + this.pokemonEntity.method_59922().method_43048(7);
                float distance = this.pokemonEntity.method_5739((class_1297)this.target);
                if (distance > 256.0f) {
                    this.ticksUntilNextPathFinding += 10;
                }
                if (!this.pokemonEntity.getNavigation().method_6335((class_1297)this.target, this.speedModifier)) {
                    this.ticksUntilNextPathFinding += 15;
                }
            }
            this.checkAndPerformAttack(this.target);
        } else if (PokemonUtils.shouldShoot(this.pokemonEntity)) {
            this.rangeAttackTick();
        }
        this.changeMoveSpeed();
    }

    public boolean method_6264() {
        class_1309 livingEntity;
        if (PokemonUtils.moveCommandAvailable(this.pokemonEntity) || this.pokemonEntity.getPokemon().getState() instanceof ShoulderedState) {
            return false;
        }
        if ((PokemonUtils.shouldShoot(this.pokemonEntity) || PokemonUtils.shouldMelee(this.pokemonEntity)) && (livingEntity = this.pokemonEntity.method_5968()) != null && livingEntity.method_5805() && PokemonUtils.shouldFightTarget(this.pokemonEntity)) {
            this.target = livingEntity;
            return true;
        }
        return false;
    }

    public boolean method_6266() {
        if (this.target == null || !PokemonUtils.shouldShoot(this.pokemonEntity) && !PokemonUtils.shouldMelee(this.pokemonEntity)) {
            return false;
        }
        return (this.method_6264() || !this.pokemonEntity.getNavigation().method_6357()) && !this.isTargetInBattle();
    }

    public void method_6270() {
        this.target = null;
        this.seeTime = 0;
        this.pokemonEntity.getNavigation().method_6340();
    }

    private void changeMoveSpeed() {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_attack_in_battle && this.isTargetInBattle()) {
            this.pokemonEntity.getNavigation().method_6344(0.0);
        } else {
            this.pokemonEntity.getNavigation().method_6344(this.speedModifier);
        }
    }

    public boolean isTargetInBattle() {
        class_1309 class_13092 = this.pokemonEntity.method_5968();
        if (class_13092 instanceof class_3222) {
            class_3222 targetAsPlayer = (class_3222)class_13092;
            return BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(targetAsPlayer) != null;
        }
        return false;
    }

    protected boolean canPerformAttack(class_1309 entity) {
        return this.getAttackTime() == 0 && this.pokemonEntity.method_42150(entity) && this.pokemonEntity.method_5985().method_6369((class_1297)entity);
    }

    protected void checkAndPerformAttack(class_1309 target) {
        if (this.canPerformAttack(target)) {
            this.resetAttackTime(0.0);
            PokemonAttackEffect.resetAttackTime(this.pokemonEntity, 1.0);
            this.pokemonDoHurtTarget((class_1297)target);
        }
    }

    public boolean pokemonDoHurtTarget(class_1297 hurtTarget) {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_attack_in_battle && this.isTargetInBattle()) {
            return false;
        }
        if (!PokemonUtils.pokemonTryForceEncounter(this.pokemonEntity, hurtTarget)) {
            Move move = PokemonUtils.getMove(this.pokemonEntity);
            if (move != null && Arrays.stream(CobblemonFightOrFlight.moveConfig().self_centered_aoe_moves).toList().contains(move.getName())) {
                PokemonAttackEffect.dealAoEDamage(this.pokemonEntity, (class_1297)this.pokemonEntity, true, PokemonUtils.isMeleeAttackMove(move));
                if (PokemonUtils.isPhysicalMove(move)) {
                    PokemonUtils.sendAnimationPacket(this.pokemonEntity, "physical");
                } else {
                    PokemonUtils.sendAnimationPacket(this.pokemonEntity, "special");
                }
                return true;
            }
            PokemonUtils.sendAnimationPacket(this.pokemonEntity, "physical");
            return PokemonAttackEffect.pokemonAttack(this.pokemonEntity, hurtTarget);
        }
        return false;
    }

    private void rangeAttackTick() {
        double d = this.pokemonEntity.method_5649(this.target.method_23317(), this.target.method_23318(), this.target.method_23321());
        boolean bl = this.pokemonEntity.method_5985().method_6369((class_1297)this.target);
        if (bl) {
            ++this.seeTime;
        } else {
            this.seeTime = 0;
            this.resetAttackTime(d);
        }
        if (!(d > (double)this.attackRadiusSqr) && this.seeTime >= 5 && bl) {
            this.pokemonEntity.getNavigation().method_6340();
            ++this.strafingTime;
        } else {
            this.pokemonEntity.getNavigation().method_6335((class_1297)this.target, this.speedModifier);
            this.strafingTime = -1;
        }
        if (this.strafingTime >= 10) {
            if ((double)this.pokemonEntity.method_59922().method_43057() < 0.3) {
                boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.pokemonEntity.method_59922().method_43057() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (d > (double)(this.attackRadiusSqr * 0.8f)) {
                this.strafingBackwards = false;
            } else if (d < (double)(this.attackRadiusSqr * 0.2f)) {
                this.strafingBackwards = true;
            }
            this.pokemonEntity.method_5962().method_6243(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            class_1297 vehicle = this.pokemonEntity.method_49694();
            if (vehicle instanceof class_1308) {
                class_1308 mob = (class_1308)vehicle;
                mob.method_5951((class_1297)this.pokemonEntity, 30.0f, 30.0f);
            }
        }
        this.pokemonEntity.method_5988().method_35111((class_1297)this.target);
        if (this.getAttackTime() == 7 && ((PokemonInterface)this.pokemonEntity).usingSound()) {
            PokemonUtils.createSonicBoomParticle(this.pokemonEntity, this.target);
        }
        if (this.getAttackTime() % 5 == 0 && ((PokemonInterface)this.pokemonEntity).usingMagic()) {
            PokemonAttackEffect.makeMagicAttackParticle(this.pokemonEntity, (class_1297)this.target);
        }
        if (this.getAttackTime() == 0) {
            if (!bl) {
                return;
            }
            this.resetAttackTime(d);
            this.performRangedAttack(this.target);
        } else if (this.getAttackTime() < 0) {
            this.resetAttackTime(d);
        }
    }

    protected void performRangedAttack(class_1309 target) {
        PokemonAttackEffect.pokemonPerformRangedAttack(this.pokemonEntity, target);
    }
}

