/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen.scrollnormalizer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ScrollScreenNormalizerHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File NORMALIZE_SCREEN_FILE = new File(GameDirectoryUtils.getGameDirectory(), "normalized_scroll_screens.json");
    private static final Map<String, Boolean> NORMALIZE_SCREEN_MAP = new HashMap<String, Boolean>();
    private static boolean loaded = false;

    private static void loadFromFile() {
        if (loaded) {
            return;
        }
        try {
            if (NORMALIZE_SCREEN_FILE.exists()) {
                try (FileReader reader = new FileReader(NORMALIZE_SCREEN_FILE);){
                    Type mapType = new TypeToken<Map<String, Boolean>>(){}.getType();
                    Map loadedMap = (Map)GSON.fromJson((Reader)reader, mapType);
                    if (loadedMap != null) {
                        NORMALIZE_SCREEN_MAP.clear();
                        NORMALIZE_SCREEN_MAP.putAll(loadedMap);
                    }
                }
            }
            loaded = true;
        }
        catch (IOException e) {
            LOGGER.error("[FANCYMENU] Failed to load normalized scroll screen states from file!", (Throwable)e);
            loaded = true;
        }
    }

    private static void saveToFile() {
        try {
            File parentDir = NORMALIZE_SCREEN_FILE.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            try (FileWriter writer = new FileWriter(NORMALIZE_SCREEN_FILE);){
                GSON.toJson(NORMALIZE_SCREEN_MAP, (Appendable)writer);
            }
        }
        catch (IOException e) {
            LOGGER.error("[FANCYMENU] Failed to save normalized scroll screen states to file!", (Throwable)e);
        }
    }

    public static void setForScreen(@NotNull class_437 screen, boolean normalize) {
        ScrollScreenNormalizerHandler.loadFromFile();
        NORMALIZE_SCREEN_MAP.put(ScreenIdentifierHandler.getIdentifierOfScreen(screen), normalize);
        ScrollScreenNormalizerHandler.saveToFile();
    }

    public static boolean shouldNormalize(@NotNull class_437 screen) {
        ScrollScreenNormalizerHandler.loadFromFile();
        String id = ScreenIdentifierHandler.getIdentifierOfScreen(screen);
        if (!NORMALIZE_SCREEN_MAP.containsKey(id)) {
            return false;
        }
        return NORMALIZE_SCREEN_MAP.get(id);
    }
}

