/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.mcef;

import de.keksuccino.fancymenu.util.Pair;
import de.keksuccino.fancymenu.util.mcef.WrappedMCEFBrowser;
import de.keksuccino.melody.resources.audio.MinecraftSoundSettingsObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_3419;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final HashMap<String, Pair<WrappedMCEFBrowser, Long>> BROWSERS = new HashMap();

    public static void init() {
        MinecraftSoundSettingsObserver.registerVolumeListener(BrowserHandler::onVolumeUpdated);
    }

    public static void notifyHandler(@NotNull String identifier, @NotNull WrappedMCEFBrowser browser) {
        if (!BROWSERS.containsKey(identifier)) {
            BROWSERS.put(identifier, Pair.of(browser, System.currentTimeMillis()));
        }
        BROWSERS.get(identifier).setValue(System.currentTimeMillis());
    }

    @Nullable
    public static WrappedMCEFBrowser get(@NotNull String identifier) {
        Pair<WrappedMCEFBrowser, Long> browser = BROWSERS.get(identifier);
        if (browser != null) {
            return browser.getKey();
        }
        return null;
    }

    public static void remove(@NotNull String identifier, boolean close) {
        try {
            Pair<WrappedMCEFBrowser, Long> browser;
            if (close && (browser = BROWSERS.get(identifier)) != null) {
                browser.getKey().close();
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to force-close MCEFBrowser!", (Throwable)ex);
        }
        BROWSERS.remove(identifier);
    }

    public static void tick() {
        long now = System.currentTimeMillis();
        ArrayList<String> garbageCollect = new ArrayList<String>();
        for (Map.Entry<String, Pair<WrappedMCEFBrowser, Long>> m : BROWSERS.entrySet()) {
            if (m.getValue().getValue() + 5000L >= now) continue;
            garbageCollect.add(m.getKey());
        }
        garbageCollect.forEach(s -> {
            try {
                Pair<WrappedMCEFBrowser, Long> browser = BROWSERS.get(s);
                if (browser != null) {
                    browser.getKey().close();
                }
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to force-close MCEFBrowser!", (Throwable)ex);
            }
            BROWSERS.remove(s);
        });
    }

    public static void mouseMoved(double mouseX, double mouseY) {
        BROWSERS.forEach((id, browser) -> ((WrappedMCEFBrowser)browser.getKey()).method_16014(mouseX, mouseY));
    }

    public static void onVolumeUpdated(class_3419 soundSource, float newVolume) {
        BROWSERS.forEach((s, wrappedMCEFBrowserLongPair) -> ((WrappedMCEFBrowser)wrappedMCEFBrowserLongPair.getKey()).onVolumeUpdated(soundSource, newVolume));
    }
}

