/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.text.markdown.MarkdownRenderer;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ScreenRenderUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.text.IText;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.input.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_8002;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TooltipElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    protected SourceMode sourceMode = SourceMode.DIRECT;
    @Nullable
    protected String source;
    protected volatile String text;
    protected String lastText;
    @Nullable
    public ResourceSupplier<IText> textResourceSupplier;
    @Nullable
    public ResourceSupplier<ITexture> backgroundTexture;
    public int nineSliceBorderTop = 5;
    public int nineSliceBorderRight = 5;
    public int nineSliceBorderBottom = 5;
    public int nineSliceBorderLeft = 5;
    public boolean mouseFollowing = false;
    public boolean interactable = false;
    @NotNull
    public volatile MarkdownRenderer markdownRenderer = new MarkdownRenderer();
    protected List<String> lastLines;
    protected IText lastIText;
    protected int cachedRealHeight = 0;

    public TooltipElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.markdownRenderer.setAutoLineBreakingEnabled(true);
        this.markdownRenderer.addLineRenderValidator(line -> {
            if (line.parent.getY() + line.offsetY + line.getLineHeight() < (float)this.getAbsoluteY()) {
                return false;
            }
            if (line.parent.getY() + line.offsetY > (float)(this.getAbsoluteY() + this.getAbsoluteHeight())) {
                return false;
            }
            return true;
        });
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (TooltipElement.isEditor()) {
            this._render(graphics, mouseX, mouseY, partial);
        } else {
            ScreenRenderUtils.postPostRenderTask((graphics1, mouseX1, mouseY1, partial1) -> this._render(graphics, mouseX, mouseY, partial));
        }
    }

    protected void _render(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (!this.shouldRender()) {
            return;
        }
        try {
            this.renderTick();
            this.markdownRenderer.setTextOpacity(this.opacity);
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            int width = this.getAbsoluteWidth();
            int height = this.getAbsoluteHeight();
            int paddingX = 6;
            int paddingY = 6;
            RenderSystem.enableBlend();
            if (this.backgroundTexture != null) {
                ITexture tex = this.backgroundTexture.get();
                if (tex != null && tex.getResourceLocation() != null) {
                    int textureWidth = Math.max(1, tex.getWidth());
                    int textureHeight = Math.max(1, tex.getHeight());
                    if (!TooltipElement.isEditor()) {
                        graphics.method_51448().method_22903();
                        graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
                    }
                    RenderingUtils.blitNineSlicedTexture(graphics, tex.getResourceLocation(), x, y, width, height, textureWidth, textureHeight, this.nineSliceBorderTop, this.nineSliceBorderRight, this.nineSliceBorderBottom, this.nineSliceBorderLeft);
                    if (!TooltipElement.isEditor()) {
                        graphics.method_51448().method_22909();
                    }
                } else {
                    this.renderVanillaTooltipBackground(graphics, x, y, width, height);
                }
            } else {
                this.renderVanillaTooltipBackground(graphics, x, y, width, height);
            }
            if (!TooltipElement.isEditor()) {
                graphics.method_51448().method_22903();
                graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
            }
            this.markdownRenderer.setX(x + paddingX);
            this.markdownRenderer.setY(y + paddingY);
            this.markdownRenderer.method_25394(graphics, mouseX, mouseY, partial);
            if (!TooltipElement.isEditor()) {
                graphics.method_51448().method_22909();
            }
        }
        catch (Exception e) {
            LOGGER.error("[FANCYMENU] Failed to render Tooltip element!", (Throwable)e);
        }
        RenderingUtils.resetShaderColor(graphics);
    }

    private void renderVanillaTooltipBackground(class_332 graphics, int x, int y, int width, int height) {
        class_8002.method_47946((class_332)graphics, (int)x, (int)y, (int)width, (int)height, (int)(TooltipElement.isEditor() ? 0 : 400));
    }

    protected void renderTick() {
        String t;
        int paddingX = 6;
        this.markdownRenderer.setOptimalWidth(this.getAbsoluteWidth() - paddingX * 2);
        this.cachedRealHeight = (int)this.markdownRenderer.getRealHeight();
        if (this.sourceMode == SourceMode.RESOURCE) {
            List<String> lines;
            IText iText = this.textResourceSupplier != null ? this.textResourceSupplier.get() : null;
            List<String> list = lines = iText != null ? iText.getTextLines() : null;
            if (lines != null) {
                lines = new ArrayList<String>(lines);
            }
            if (!Objects.equals(this.lastIText, iText) || !Objects.equals(this.lastLines, lines)) {
                this.updateContent();
            }
            this.lastLines = lines;
            this.lastIText = iText;
        }
        if (!((t = this.text) == null || this.lastText != null && this.lastText.equals(t))) {
            this.markdownRenderer.setText(t);
        }
        this.lastText = t;
    }

    @Override
    public int getAbsoluteX() {
        if (this.mouseFollowing && !TooltipElement.isEditor()) {
            int screenWidth;
            int x = this.cachedMouseX;
            int tooltipWidth = this.getAbsoluteWidth();
            if (x + tooltipWidth > (screenWidth = TooltipElement.getScreenWidth())) {
                x = screenWidth - tooltipWidth;
            }
            if (x < 0) {
                x = 0;
            }
            return x;
        }
        return super.getAbsoluteX();
    }

    @Override
    public int getAbsoluteY() {
        if (this.mouseFollowing && !TooltipElement.isEditor()) {
            int screenHeight;
            int y = this.cachedMouseY;
            int tooltipHeight = this.getAbsoluteHeight();
            if (y + tooltipHeight > (screenHeight = TooltipElement.getScreenHeight())) {
                y = screenHeight - tooltipHeight;
            }
            if (y < 0) {
                y = 0;
            }
            return y;
        }
        return super.getAbsoluteY();
    }

    @Override
    public int getAbsoluteHeight() {
        return Math.max(this.cachedRealHeight + 12, 20);
    }

    public void updateContent() {
        if (this.source == null) {
            this.markdownRenderer.setText("-------------------");
            return;
        }
        new Thread(() -> {
            List<Object> linesRaw = new ArrayList<String>();
            try {
                if (this.source != null && !this.source.isEmpty()) {
                    if (this.sourceMode == SourceMode.DIRECT) {
                        String s = this.source.replace("%n%", "\n").replace("\r", "\n");
                        if (s.contains("\n")) {
                            linesRaw.addAll(Arrays.asList(StringUtils.splitLines((String)s, (String)"\n")));
                        } else {
                            linesRaw.add(s);
                        }
                    } else if (this.textResourceSupplier != null) {
                        IText iText = this.textResourceSupplier.get();
                        if (iText != null) {
                            linesRaw = iText.getTextLines();
                        }
                        linesRaw = linesRaw != null ? new ArrayList<Object>(linesRaw) : new ArrayList();
                    }
                } else {
                    linesRaw.add("-------------------");
                }
            }
            catch (Exception ex) {
                if (linesRaw == null) {
                    linesRaw = new ArrayList();
                }
                linesRaw.clear();
            }
            if (linesRaw.isEmpty()) {
                if (TooltipElement.isEditor()) {
                    linesRaw.add(class_1074.method_4662((String)"fancymenu.customization.items.text.status.unable_to_load", (Object[])new Object[0]));
                } else {
                    linesRaw.add("");
                }
            }
            StringBuilder text = new StringBuilder();
            for (String string : linesRaw) {
                if (!text.isEmpty()) {
                    text.append("\n");
                }
                text.append(string);
            }
            this.text = text.toString();
        }).start();
    }

    public void setSource(@NotNull SourceMode sourceMode, @Nullable String source) {
        this.sourceMode = Objects.requireNonNull(sourceMode);
        this.source = source;
        this.textResourceSupplier = null;
        if (sourceMode == SourceMode.RESOURCE && this.source != null) {
            this.textResourceSupplier = ResourceSupplier.text(this.source);
        }
        this.text = null;
        this.lastText = null;
        this.lastIText = null;
        this.lastLines = null;
        this.updateContent();
    }

    public static enum SourceMode implements LocalizedCycleEnum<SourceMode>
    {
        DIRECT("direct"),
        RESOURCE("resource");

        final String name;

        private SourceMode(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public SourceMode[] getValues() {
            return SourceMode.values();
        }

        @Override
        @Nullable
        public SourceMode getByNameInternal(@NotNull String name) {
            return SourceMode.getByName(name);
        }

        @Nullable
        public static SourceMode getByName(String name) {
            for (SourceMode i : SourceMode.values()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.elements.text.v2.source_mode";
        }

        @Override
        @NotNull
        public class_2583 getValueComponentStyle() {
            return (class_2583)WARNING_TEXT_STYLE.get();
        }
    }
}

