/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.text.v2;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.elements.text.v2.TextEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.text.v2.TextElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.text.markdown.MarkdownRenderer;
import de.keksuccino.konkrete.math.MathUtils;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextElementBuilder
extends ElementBuilder<TextElement, TextEditorElement> {
    public TextElementBuilder() {
        super("text_v2");
    }

    @Override
    @NotNull
    public TextElement buildDefaultInstance() {
        TextElement i = new TextElement(this);
        i.baseWidth = 200;
        i.baseHeight = 40;
        i.setSource(TextElement.SourceMode.DIRECT, class_1074.method_4662((String)"fancymenu.customization.items.text.placeholder", (Object[])new Object[0]));
        return i;
    }

    @Override
    public TextElement deserializeElement(@NotNull SerializedElement serialized) {
        String tableMargin;
        String tableCellPadding;
        String tableLineThickness;
        String tableAlternateRowColor;
        String tableRowBackgroundColor;
        String tableHeaderBackgroundColor;
        String tableLineColor;
        String tableAlternateRowColors;
        String bulletListSpacing;
        String bulletListIndent;
        String bulletListDotColor;
        String quoteItalic;
        String quoteIndent;
        String quoteColor;
        String hyperlinkColor;
        String separationLineColor;
        String headlineLineColor;
        String codeBlockMultiColor;
        String codeBlockSingleColor;
        String removeHtmlBreaks;
        String autoLineWrapping;
        String lineSpacingString;
        String textBorderString;
        String baseColorString;
        String scaleString;
        String caseModeString;
        String shadowString;
        String sourceModeString;
        TextElement element = new TextElement(this);
        element.baseWidth = 200;
        element.baseHeight = 40;
        element.interactable = this.deserializeBoolean(element.interactable, serialized.getValue("interactable"));
        element.source = serialized.getValue("source");
        if (element.source != null) {
            element.source = element.source.replace("%n%", "\n");
        }
        if ((sourceModeString = serialized.getValue("source_mode")) != null) {
            if (sourceModeString.equals("local") || sourceModeString.equals("web")) {
                element.sourceMode = TextElement.SourceMode.RESOURCE;
            } else {
                TextElement.SourceMode s = TextElement.SourceMode.getByName(sourceModeString);
                if (s != null) {
                    element.sourceMode = s;
                }
            }
        }
        if ((shadowString = serialized.getValue("shadow")) != null) {
            if (shadowString.equals("false")) {
                element.markdownRenderer.setTextShadow(false);
            }
            if (shadowString.equals("true")) {
                element.markdownRenderer.setTextShadow(true);
            }
        }
        if ((caseModeString = serialized.getValue("case_mode")) != null) {
            if (caseModeString.equals("lower")) {
                element.markdownRenderer.setTextCase(MarkdownRenderer.TextCase.ALL_LOWER);
            }
            if (caseModeString.equals("upper")) {
                element.markdownRenderer.setTextCase(MarkdownRenderer.TextCase.ALL_UPPER);
            }
        }
        if ((scaleString = serialized.getValue("scale")) != null && MathUtils.isFloat((String)scaleString)) {
            element.markdownRenderer.setTextBaseScale(Float.parseFloat(scaleString));
        }
        if ((baseColorString = serialized.getValue("base_color")) != null) {
            DrawableColor c = DrawableColor.of(baseColorString);
            element.markdownRenderer.setTextBaseColor(c);
        }
        if ((textBorderString = serialized.getValue("text_border")) != null && MathUtils.isInteger((String)textBorderString)) {
            element.markdownRenderer.setBorder(Integer.parseInt(textBorderString));
        }
        if ((lineSpacingString = serialized.getValue("line_spacing")) != null && MathUtils.isInteger((String)lineSpacingString)) {
            element.markdownRenderer.setLineSpacing(Integer.parseInt(lineSpacingString));
        }
        element.scrollGrabberColorHexNormal = serialized.getValue("grabber_color_normal");
        element.scrollGrabberColorHexHover = serialized.getValue("grabber_color_hover");
        element.verticalScrollGrabberTextureNormal = TextElementBuilder.deserializeImageResourceSupplier(serialized.getValue("grabber_texture_normal"));
        element.verticalScrollGrabberTextureHover = TextElementBuilder.deserializeImageResourceSupplier(serialized.getValue("grabber_texture_hover"));
        element.horizontalScrollGrabberTextureNormal = TextElementBuilder.deserializeImageResourceSupplier(serialized.getValue("horizontal_grabber_texture_normal"));
        element.horizontalScrollGrabberTextureHover = TextElementBuilder.deserializeImageResourceSupplier(serialized.getValue("horizontal_grabber_texture_hover"));
        String enableScrollingString = serialized.getValue("enable_scrolling");
        if (enableScrollingString != null && enableScrollingString.equals("false")) {
            element.enableScrolling = false;
        }
        if ((autoLineWrapping = serialized.getValue("auto_line_wrapping")) != null) {
            if (autoLineWrapping.equals("true")) {
                element.markdownRenderer.setAutoLineBreakingEnabled(true);
            }
            if (autoLineWrapping.equals("false")) {
                element.markdownRenderer.setAutoLineBreakingEnabled(false);
            }
        }
        if ((removeHtmlBreaks = serialized.getValue("remove_html_breaks")) != null) {
            if (removeHtmlBreaks.equals("true")) {
                element.markdownRenderer.setRemoveHtmlBreaks(true);
            }
            if (removeHtmlBreaks.equals("false")) {
                element.markdownRenderer.setRemoveHtmlBreaks(false);
            }
        }
        if ((codeBlockSingleColor = serialized.getValue("code_block_single_color")) != null) {
            element.markdownRenderer.setCodeBlockSingleLineColor(DrawableColor.of(codeBlockSingleColor));
        }
        if ((codeBlockMultiColor = serialized.getValue("code_block_multi_color")) != null) {
            element.markdownRenderer.setCodeBlockMultiLineColor(DrawableColor.of(codeBlockMultiColor));
        }
        if ((headlineLineColor = serialized.getValue("headline_line_color")) != null) {
            element.markdownRenderer.setHeadlineLineColor(DrawableColor.of(headlineLineColor));
        }
        if ((separationLineColor = serialized.getValue("separation_line_color")) != null) {
            element.markdownRenderer.setSeparationLineColor(DrawableColor.of(separationLineColor));
        }
        if ((hyperlinkColor = serialized.getValue("hyperlink_color")) != null) {
            element.markdownRenderer.setHyperlinkColor(DrawableColor.of(hyperlinkColor));
        }
        if ((quoteColor = serialized.getValue("quote_color")) != null) {
            element.markdownRenderer.setQuoteColor(DrawableColor.of(quoteColor));
        }
        if ((quoteIndent = serialized.getValue("quote_indent")) != null && MathUtils.isInteger((String)quoteIndent)) {
            element.markdownRenderer.setQuoteIndent(Integer.parseInt(quoteIndent));
        }
        if ((quoteItalic = serialized.getValue("quote_italic")) != null) {
            if (quoteItalic.equals("true")) {
                element.markdownRenderer.setQuoteItalic(true);
            }
            if (quoteItalic.equals("false")) {
                element.markdownRenderer.setQuoteItalic(false);
            }
        }
        if ((bulletListDotColor = serialized.getValue("bullet_list_dot_color")) != null) {
            element.markdownRenderer.setBulletListDotColor(DrawableColor.of(bulletListDotColor));
        }
        if ((bulletListIndent = serialized.getValue("bullet_list_indent")) != null && MathUtils.isInteger((String)bulletListIndent)) {
            element.markdownRenderer.setBulletListIndent(Integer.parseInt(bulletListIndent));
        }
        if ((bulletListSpacing = serialized.getValue("bullet_list_spacing")) != null && MathUtils.isInteger((String)bulletListSpacing)) {
            element.markdownRenderer.setBulletListSpacing(Integer.parseInt(bulletListSpacing));
        }
        element.markdownRenderer.setParseMarkdown(this.deserializeBoolean(true, serialized.getValue("parse_markdown")));
        String tableShowHeader = serialized.getValue("table_show_header");
        if (tableShowHeader != null) {
            element.markdownRenderer.setTableShowHeader(this.deserializeBoolean(true, tableShowHeader));
        }
        if ((tableAlternateRowColors = serialized.getValue("table_alternate_row_colors")) != null) {
            element.markdownRenderer.setTableAlternateRowColors(this.deserializeBoolean(true, tableAlternateRowColors));
        }
        if ((tableLineColor = serialized.getValue("table_line_color")) != null) {
            element.markdownRenderer.setTableLineColor(DrawableColor.of(tableLineColor));
        }
        if ((tableHeaderBackgroundColor = serialized.getValue("table_header_background_color")) != null) {
            element.markdownRenderer.setTableHeaderBackgroundColor(DrawableColor.of(tableHeaderBackgroundColor));
        }
        if ((tableRowBackgroundColor = serialized.getValue("table_row_background_color")) != null) {
            element.markdownRenderer.setTableRowBackgroundColor(DrawableColor.of(tableRowBackgroundColor));
        }
        if ((tableAlternateRowColor = serialized.getValue("table_alternate_row_color")) != null) {
            element.markdownRenderer.setTableAlternateRowColor(DrawableColor.of(tableAlternateRowColor));
        }
        if ((tableLineThickness = serialized.getValue("table_line_thickness")) != null && MathUtils.isFloat((String)tableLineThickness)) {
            element.markdownRenderer.setTableLineThickness(Float.parseFloat(tableLineThickness));
        }
        if ((tableCellPadding = serialized.getValue("table_cell_padding")) != null && MathUtils.isFloat((String)tableCellPadding)) {
            element.markdownRenderer.setTableCellPadding(Float.parseFloat(tableCellPadding));
        }
        if ((tableMargin = serialized.getValue("table_margin")) != null && MathUtils.isFloat((String)tableMargin)) {
            element.markdownRenderer.setTableMargin(Float.parseFloat(tableMargin));
        }
        element.markdownRenderer.refreshRenderer();
        element.setSource(element.sourceMode, element.source);
        return element;
    }

    @Override
    protected SerializedElement serializeElement(@NotNull TextElement element, @NotNull SerializedElement serializeTo) {
        serializeTo.putProperty("interactable", "" + element.interactable);
        if (element.source != null) {
            serializeTo.putProperty("source", element.source.replace("\n", "%n%"));
        }
        serializeTo.putProperty("source_mode", element.sourceMode.name);
        serializeTo.putProperty("shadow", "" + element.markdownRenderer.isTextShadow());
        if (element.markdownRenderer.getTextCase() == MarkdownRenderer.TextCase.ALL_LOWER) {
            serializeTo.putProperty("case_mode", "lower");
        } else if (element.markdownRenderer.getTextCase() == MarkdownRenderer.TextCase.ALL_UPPER) {
            serializeTo.putProperty("case_mode", "upper");
        }
        serializeTo.putProperty("scale", "" + element.markdownRenderer.getTextBaseScale());
        serializeTo.putProperty("base_color", element.markdownRenderer.getTextBaseColor().getHex());
        serializeTo.putProperty("text_border", "" + (int)element.markdownRenderer.getBorder());
        serializeTo.putProperty("line_spacing", "" + (int)element.markdownRenderer.getLineSpacing());
        if (element.scrollGrabberColorHexNormal != null) {
            serializeTo.putProperty("grabber_color_normal", element.scrollGrabberColorHexNormal);
        }
        if (element.scrollGrabberColorHexHover != null) {
            serializeTo.putProperty("grabber_color_hover", element.scrollGrabberColorHexHover);
        }
        if (element.verticalScrollGrabberTextureNormal != null) {
            serializeTo.putProperty("grabber_texture_normal", element.verticalScrollGrabberTextureNormal.getSourceWithPrefix());
        }
        if (element.verticalScrollGrabberTextureHover != null) {
            serializeTo.putProperty("grabber_texture_hover", element.verticalScrollGrabberTextureHover.getSourceWithPrefix());
        }
        if (element.horizontalScrollGrabberTextureNormal != null) {
            serializeTo.putProperty("horizontal_grabber_texture_normal", element.horizontalScrollGrabberTextureNormal.getSourceWithPrefix());
        }
        if (element.horizontalScrollGrabberTextureHover != null) {
            serializeTo.putProperty("horizontal_grabber_texture_hover", element.horizontalScrollGrabberTextureHover.getSourceWithPrefix());
        }
        serializeTo.putProperty("enable_scrolling", "" + element.enableScrolling);
        serializeTo.putProperty("auto_line_wrapping", "" + element.markdownRenderer.isAutoLineBreakingEnabled());
        serializeTo.putProperty("remove_html_breaks", "" + element.markdownRenderer.isRemoveHtmlBreaks());
        serializeTo.putProperty("code_block_single_color", element.markdownRenderer.getCodeBlockSingleLineColor().getHex());
        serializeTo.putProperty("code_block_multi_color", element.markdownRenderer.getCodeBlockMultiLineColor().getHex());
        serializeTo.putProperty("headline_line_color", element.markdownRenderer.getHeadlineUnderlineColor().getHex());
        serializeTo.putProperty("separation_line_color", element.markdownRenderer.getSeparationLineColor().getHex());
        serializeTo.putProperty("hyperlink_color", element.markdownRenderer.getHyperlinkColor().getHex());
        serializeTo.putProperty("quote_color", element.markdownRenderer.getQuoteColor().getHex());
        serializeTo.putProperty("quote_indent", "" + element.markdownRenderer.getQuoteIndent());
        serializeTo.putProperty("quote_italic", "" + element.markdownRenderer.isQuoteItalic());
        serializeTo.putProperty("bullet_list_dot_color", element.markdownRenderer.getBulletListDotColor().getHex());
        serializeTo.putProperty("bullet_list_indent", "" + element.markdownRenderer.getBulletListIndent());
        serializeTo.putProperty("bullet_list_spacing", "" + element.markdownRenderer.getBulletListSpacing());
        serializeTo.putProperty("parse_markdown", "" + element.markdownRenderer.isParseMarkdown());
        serializeTo.putProperty("table_show_header", "" + element.markdownRenderer.isTableShowHeader());
        serializeTo.putProperty("table_alternate_row_colors", "" + element.markdownRenderer.isTableAlternateRowColors());
        serializeTo.putProperty("table_line_color", element.markdownRenderer.getTableLineColor().getHex());
        serializeTo.putProperty("table_header_background_color", element.markdownRenderer.getTableHeaderBackgroundColor().getHex());
        serializeTo.putProperty("table_row_background_color", element.markdownRenderer.getTableRowBackgroundColor().getHex());
        serializeTo.putProperty("table_alternate_row_color", element.markdownRenderer.getTableAlternateRowColor().getHex());
        serializeTo.putProperty("table_line_thickness", "" + element.markdownRenderer.getTableLineThickness());
        serializeTo.putProperty("table_cell_padding", "" + element.markdownRenderer.getTableCellPadding());
        serializeTo.putProperty("table_margin", "" + element.markdownRenderer.getTableMargin());
        return serializeTo;
    }

    @Override
    @NotNull
    public TextEditorElement wrapIntoEditorElement(@NotNull TextElement element, @NotNull LayoutEditorScreen editor) {
        return new TextEditorElement(element, editor);
    }

    @Override
    @NotNull
    public class_2561 getDisplayName(@Nullable AbstractElement element) {
        return class_2561.method_43471((String)"fancymenu.customization.items.text");
    }

    @Override
    @Nullable
    public class_2561[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines("fancymenu.customization.items.text.v2.desc", new String[0]);
    }
}

