/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc.common.impl;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.darkhax.bookshelf.common.api.PhysicalSide;
import net.darkhax.bookshelf.common.api.annotation.OnlyFor;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.enchdesc.common.impl.Config;
import net.darkhax.pricklemc.common.api.config.ConfigManager;
import net.minecraft.class_1074;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_486;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class EnchdescMod {
    private static final String[] KEY_TYPES = new String[]{"desc", "description", "info"};
    private static EnchdescMod instance;
    private boolean hasInitialized = false;
    private Config config;

    public void init() {
        if (this.hasInitialized) {
            throw new IllegalStateException("The EnchantmentDescriptions has already been initialized.");
        }
        if (Services.PLATFORM.isPhysicalClient()) {
            this.config = (Config)ConfigManager.load((String)"enchdesc", (Object)new Config());
        }
        this.hasInitialized = true;
    }

    @OnlyFor(value=PhysicalSide.CLIENT)
    public void insertDescriptions(class_1799 stack, List<class_2561> lines) {
        if (this.hasInitialized && this.config.enabled && this.hasEnchantments(stack)) {
            if (this.config.only_on_books && !(stack.method_7909() instanceof class_1772)) {
                return;
            }
            if (this.config.only_in_enchanting_table && !(class_310.method_1551().field_1755 instanceof class_486)) {
                return;
            }
            if (this.config.require_keybind && !class_437.method_25442()) {
                if (this.config.activate_text.method_10851() != class_8828.field_46625) {
                    lines.add(this.config.activate_text);
                }
                return;
            }
            this.insertDescriptions(stack.method_58657(), lines);
            this.insertDescriptions((class_9304)stack.method_57825(class_9334.field_49643, (Object)class_9304.field_49385), lines);
        }
    }

    private boolean hasEnchantments(class_1799 stack) {
        return !((class_9304)stack.method_57825(class_9334.field_49633, (Object)class_9304.field_49385)).method_57543() || !((class_9304)stack.method_57825(class_9334.field_49643, (Object)class_9304.field_49385)).method_57543();
    }

    @OnlyFor(value=PhysicalSide.CLIENT)
    private void insertDescriptions(class_9304 enchantments, List<class_2561> lines) {
        if (!enchantments.method_57543()) {
            for (Object2IntMap.Entry entry : enchantments.method_57539()) {
                ((class_6880)entry.getKey()).method_40230().ifPresent(key -> {
                    class_2561 fullName = class_1887.method_8179((class_6880)((class_6880)entry.getKey()), (int)entry.getIntValue());
                    for (class_2561 line : lines) {
                        class_5250 description;
                        int index;
                        if (!fullName.equals((Object)line) || (index = lines.indexOf(line)) == -1 || (description = this.getDescription((class_6880<class_1887>)((class_6880)entry.getKey()), key.method_29177(), entry.getIntValue())) == null) continue;
                        class_2564.method_10889((class_5250)description, (class_2583)this.config.style);
                        lines.add(index + 1, (class_2561)this.config.prefix.method_27661().method_10852((class_2561)description).method_10852(this.config.suffix));
                        break;
                    }
                });
            }
        }
    }

    @Nullable
    @OnlyFor(value=PhysicalSide.CLIENT)
    private class_5250 getDescription(class_6880<class_1887> enchantment, class_2960 id, int level) {
        class_7417 class_74172;
        class_5250 description = this.getDescription("enchantment." + id.method_12836() + "." + id.method_12832() + ".", level);
        if (description == null && (class_74172 = ((class_1887)enchantment.comp_349()).comp_2686().method_10851()) instanceof class_2588) {
            class_2588 translatable = (class_2588)class_74172;
            description = this.getDescription(translatable.method_11022() + ".", level);
        }
        return description;
    }

    @Nullable
    @OnlyFor(value=PhysicalSide.CLIENT)
    private class_5250 getDescription(String baseKey, int level) {
        for (String keyType : KEY_TYPES) {
            String key = baseKey + keyType;
            if (class_1074.method_4663((String)key)) {
                return class_2561.method_43471((String)key);
            }
            if (!class_1074.method_4663((String)(key = key + "." + level))) continue;
            return class_2561.method_43471((String)key);
        }
        return null;
    }

    public boolean hasInitialized() {
        return this.hasInitialized;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static EnchdescMod getInstance() {
        if (instance == null) {
            instance = new EnchdescMod();
        }
        return instance;
    }
}

