/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.access.AccessManager;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class DeleteCommand
extends Command {
    private DeleteCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").requires(cs -> cs.method_9259(0))).then(class_2170.method_9244((String)"npc_targets", (ArgumentType)EasyNPCArgument.npc()).executes(context -> DeleteCommand.delete((class_2168)context.getSource(), EasyNPCArgument.getEntitiesWithAccess((CommandContext<class_2168>)context, "npc_targets"))));
    }

    private static int delete(class_2168 context, Collection<? extends EasyNPC<?>> easyNPCs) {
        int deletedEntities = 0;
        for (EasyNPC<?> easyNPC : easyNPCs) {
            UUID uuid = easyNPC.getUUID();
            if (AccessManager.hasAccess(context, uuid)) {
                easyNPC.getEntity().method_31472();
                ++deletedEntities;
                continue;
            }
            DeleteCommand.sendFailureMessage(context, "You are not allowed to delete the Easy NPC " + String.valueOf(uuid) + " !");
        }
        if (deletedEntities == 1) {
            EasyNPC<?> easyNPC = easyNPCs.iterator().next();
            return DeleteCommand.sendSuccessMessage(context, "Deleted Easy NPC " + easyNPC.getEntity().method_5476().getString() + " !");
        }
        if (deletedEntities > 1) {
            return DeleteCommand.sendSuccessMessage(context, "Deleted " + deletedEntities + " of " + easyNPCs.size() + " selected Easy NPCs!");
        }
        return DeleteCommand.sendFailureMessage(context, "Nothing to delete!");
    }
}

