/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.syncher;

import de.markusbordihn.easynpc.data.action.ActionEventSet;
import de.markusbordihn.easynpc.data.attribute.CustomAttributes;
import de.markusbordihn.easynpc.data.attribute.EntityAttributes;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.display.DisplayAttributeSet;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataSet;
import de.markusbordihn.easynpc.data.objective.TargetedEntitySet;
import de.markusbordihn.easynpc.data.objective.TargetedPlayerSet;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.data.skin.SkinUUID;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.spawner.SpawnerUUID;
import de.markusbordihn.easynpc.data.trading.TradingDataSet;
import de.markusbordihn.easynpc.data.trading.TradingType;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1916;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_9139;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityDataSerializersManager {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final Map<String, class_2941<?>> ENTITY_DATA_SERIALIZERS = new LinkedHashMap();
    public static final class_2941<ActionEventSet> ACTION_EVENT_SET = EntityDataSerializersManager.defineSerializer(ActionEventSet.class.getSimpleName(), class_2941.method_56031(ActionEventSet.STREAM_CODEC));
    public static final class_2941<CustomAttributes> CUSTOM_ATTRIBUTES = EntityDataSerializersManager.defineSerializer(CustomAttributes.class.getSimpleName(), class_2941.method_56031(CustomAttributes.STREAM_CODEC));
    public static final class_2941<DialogDataSet> DIALOG_DATA_SET = EntityDataSerializersManager.defineSerializer(DialogDataSet.class.getSimpleName(), class_2941.method_56031(DialogDataSet.STREAM_CODEC));
    public static final class_2941<DisplayAttributeSet> DISPLAY_ATTRIBUTE_SET = EntityDataSerializersManager.defineSerializer(DisplayAttributeSet.class.getSimpleName(), class_2941.method_56031(DisplayAttributeSet.STREAM_CODEC));
    public static final class_2941<EntityAttributes> ENTITY_ATTRIBUTES = EntityDataSerializersManager.defineSerializer(EntityAttributes.class.getSimpleName(), class_2941.method_56031(EntityAttributes.STREAM_CODEC));
    public static final class_2941<class_1916> MERCHANT_OFFERS = EntityDataSerializersManager.defineSerializer(class_1916.class.getSimpleName(), class_2941.method_56031((class_9139)class_1916.field_48373));
    public static final class_2941<ModelPose> MODEL_POSE = EntityDataSerializersManager.defineSerializer(ModelPose.class.getSimpleName(), class_2941.method_56031(ModelPose.STREAM_CODEC));
    public static final class_2941<ObjectiveDataSet> OBJECTIVE_DATA_SET = EntityDataSerializersManager.defineSerializer(ObjectiveDataSet.class.getSimpleName(), class_2941.method_56031(ObjectiveDataSet.STREAM_CODEC));
    public static final class_2941<CustomPosition> POSITION = EntityDataSerializersManager.defineSerializer(CustomPosition.class.getSimpleName(), class_2941.method_56031(CustomPosition.STREAM_CODEC));
    public static final class_2941<Profession> PROFESSION = EntityDataSerializersManager.defineSerializer(Profession.class.getSimpleName(), class_2941.method_56031(Profession.STREAM_CODEC));
    public static final class_2941<RenderDataSet> RENDER_DATA_SET = EntityDataSerializersManager.defineSerializer(RenderDataSet.class.getSimpleName(), class_2941.method_56031(RenderDataSet.STREAM_CODEC));
    public static final class_2941<CustomRotation> ROTATION = EntityDataSerializersManager.defineSerializer(CustomRotation.class.getSimpleName(), class_2941.method_56031(CustomRotation.STREAM_CODEC));
    public static final class_2941<CustomScale> SCALE = EntityDataSerializersManager.defineSerializer(CustomScale.class.getSimpleName(), class_2941.method_56031(CustomScale.STREAM_CODEC));
    public static final class_2941<SkinDataEntry> SKIN_DATA_ENTRY = EntityDataSerializersManager.defineSerializer(SkinDataEntry.class.getSimpleName(), class_2941.method_56031(SkinDataEntry.STREAM_CODEC));
    public static final class_2941<SkinType> SKIN_TYPE = EntityDataSerializersManager.defineSerializer(SkinType.class.getSimpleName(), class_2941.method_56031(SkinType.STREAM_CODEC));
    public static final class_2941<UUID> SKIN_UUID = EntityDataSerializersManager.defineSerializer(SkinUUID.class.getSimpleName(), class_2941.method_56031(SkinUUID.STREAM_CODEC));
    public static final class_2941<SoundDataSet> SOUND_DATA_SET = EntityDataSerializersManager.defineSerializer(SoundDataSet.class.getSimpleName(), class_2941.method_56031(SoundDataSet.STREAM_CODEC));
    public static final class_2941<UUID> SPAWNER_UUID = EntityDataSerializersManager.defineSerializer(SpawnerUUID.class.getSimpleName(), class_2941.method_56031(SpawnerUUID.STREAM_CODEC));
    public static final class_2941<HashSet<UUID>> TARGETED_ENTITY_HASH_SET = EntityDataSerializersManager.defineSerializer(TargetedEntitySet.class.getSimpleName(), class_2941.method_56031(TargetedEntitySet.STREAM_CODEC));
    public static final class_2941<HashSet<String>> TARGETED_PLAYER_HASH_SET = EntityDataSerializersManager.defineSerializer(TargetedPlayerSet.class.getSimpleName(), class_2941.method_56031(TargetedPlayerSet.STREAM_CODEC));
    public static final class_2941<TradingDataSet> TRADING_DATA_SET = EntityDataSerializersManager.defineSerializer(TradingDataSet.class.getSimpleName(), class_2941.method_56031(TradingDataSet.STREAM_CODEC));
    public static final class_2941<TradingType> TRADING_TYPE = EntityDataSerializersManager.defineSerializer(TradingType.class.getSimpleName(), class_2941.method_56031(TradingType.STREAM_CODEC));

    private EntityDataSerializersManager() {
    }

    public static <T> class_2941<T> defineSerializer(String className, class_2941<T> serializer) {
        if (ENTITY_DATA_SERIALIZERS.containsKey(className)) {
            log.error("Entity data serializer {} already defined with {}!", (Object)className, ENTITY_DATA_SERIALIZERS.get(className));
            return null;
        }
        ENTITY_DATA_SERIALIZERS.put(className, serializer);
        return serializer;
    }

    public static void register() {
        for (Map.Entry<String, class_2941<?>> entry : ENTITY_DATA_SERIALIZERS.entrySet()) {
            class_2941<?> serializer = entry.getValue();
            if (serializer == null) {
                log.error("Failed to register entity data serializer {}", (Object)entry.getKey());
                continue;
            }
            class_2943.method_12720(serializer);
            int id = class_2943.method_12719(serializer);
            if (id >= 0) {
                log.info("Registered entity data serializer {} with id {}", (Object)entry.getKey(), (Object)id);
                continue;
            }
            log.error("Failed to register entity data serializer {} with {}", (Object)entry.getKey(), serializer);
        }
    }
}

