/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogButtonType;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record OpenDialogButtonEditorMessage(UUID uuid, UUID dialogId, UUID dialogButtonId) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = class_2960.method_60655((String)"easy_npc", (String)"open_dialog_button_editor");
    public static final class_8710.class_9154<OpenDialogButtonEditorMessage> PAYLOAD_TYPE = new class_8710.class_9154(MESSAGE_ID);
    public static final class_9139<class_9129, OpenDialogButtonEditorMessage> STREAM_CODEC = class_9139.method_56437((buffer, message) -> message.write((class_2540)buffer), OpenDialogButtonEditorMessage::create);

    public static OpenDialogButtonEditorMessage create(class_2540 buffer) {
        return new OpenDialogButtonEditorMessage(buffer.method_10790(), buffer.method_10790(), buffer.method_10790());
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10797(this.dialogId);
        buffer.method_10797(this.dialogButtonId);
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.dialogId == null) {
            log.error("Invalid dialog id for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        DialogData<?> dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Unable to get valid dialog data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        DialogDataSet dialogDataSet = dialogData.getDialogDataSet();
        if (dialogDataSet == null) {
            log.error("Unable to get valid dialog data set for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        DialogDataEntry dialogDataEntry = dialogDataSet.getDialog(this.dialogId);
        if (dialogDataEntry == null) {
            log.error("Unable to get valid dialog data for dialog {} for {} from {}", easyNPC, (Object)this.dialogId, (Object)serverPlayer);
            return;
        }
        UUID newDialogButtonId = this.dialogButtonId;
        if (this.dialogButtonId != null && this.dialogButtonId.equals(EMPTY_UUID)) {
            DialogButtonEntry newDialogButton = new DialogButtonEntry("Button " + RANDOM.nextInt(1000), DialogButtonType.DEFAULT);
            log.info("Created new dialog button {} for dialog {} for {} from {}", (Object)newDialogButton, (Object)this.dialogId, easyNPC, (Object)serverPlayer);
            dialogDataEntry.setDialogButton(newDialogButton);
            newDialogButtonId = newDialogButton.id();
        } else if (this.dialogButtonId != null && !dialogData.hasDialogButton(this.dialogId, this.dialogButtonId)) {
            log.error("Invalid dialog button id {} for {} from {}", (Object)this.dialogButtonId, easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Open dialog button editor for dialog {} and button {} for {} from {}", (Object)this.dialogId, (Object)newDialogButtonId, easyNPC, (Object)serverPlayer);
        MenuManager.getMenuHandler().openEditorMenu(EditorType.DIALOG_BUTTON, serverPlayer, easyNPC, this.dialogId, newDialogButtonId, 0);
    }
}

