/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record ExportWorldPresetMessage(UUID uuid, String name) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = class_2960.method_60655((String)"easy_npc", (String)"export_world_preset");
    public static final class_8710.class_9154<ExportWorldPresetMessage> PAYLOAD_TYPE = new class_8710.class_9154(MESSAGE_ID);
    public static final class_9139<class_9129, ExportWorldPresetMessage> STREAM_CODEC = class_9139.method_56437((buffer, message) -> message.write((class_2540)buffer), ExportWorldPresetMessage::create);

    public static ExportWorldPresetMessage create(class_2540 buffer) {
        return new ExportWorldPresetMessage(buffer.method_10790(), buffer.method_19772());
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10814(this.name);
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.name == null || this.name.isEmpty()) {
            log.warn("Export preset name is empty for {}", easyNPC);
            return;
        }
        SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
        if (skinData == null) {
            log.warn("Export preset skin data is empty for {}", easyNPC);
            return;
        }
        SkinModel skinModel = skinData.getSkinModel();
        if (skinModel == null) {
            log.warn("Export preset skin model is empty for {}", easyNPC);
            return;
        }
        PresetData<?> presetData = easyNPC.getEasyNPCPresetData();
        class_2487 compoundTag = presetData.exportPresetData();
        if (compoundTag == null || compoundTag.method_33133()) {
            log.warn("Export preset data is empty for {}", easyNPC);
            return;
        }
        File presetFile = WorldPresetDataFiles.getPresetFile(skinModel, this.name);
        if (presetFile == null) {
            log.error("Failed to get preset file for {} with name {}", (Object)skinModel, (Object)this.name);
            return;
        }
        log.info("Exporting EasyNPC {} with {} and skin {} to {}", (Object)this.name, easyNPC, (Object)skinModel, (Object)presetFile);
        try {
            class_2507.method_30614((class_2487)compoundTag, (Path)presetFile.toPath());
        }
        catch (IOException exception) {
            log.error("Failed to export EasyNPC {} with {} and skin {} to {}:", (Object)this.name, easyNPC, (Object)skinModel, (Object)presetFile, (Object)exception);
        }
    }
}

