/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.SkinHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import de.markusbordihn.easynpc.utils.PlayersUtils;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record ChangeSkinMessage(UUID uuid, String skinName, String skinURL, UUID skinUUID, SkinType skinType, String skinVariant) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = class_2960.method_60655((String)"easy_npc", (String)"change_skin");
    public static final class_8710.class_9154<ChangeSkinMessage> PAYLOAD_TYPE = new class_8710.class_9154(MESSAGE_ID);
    public static final class_9139<class_9129, ChangeSkinMessage> STREAM_CODEC = class_9139.method_56437((buffer, message) -> message.write((class_2540)buffer), ChangeSkinMessage::create);

    public static ChangeSkinMessage create(class_2540 buffer) {
        return new ChangeSkinMessage(buffer.method_10790(), buffer.method_19772(), buffer.method_19772(), buffer.method_10790(), (SkinType)buffer.method_10818(SkinType.class), buffer.method_19772());
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10814(this.skinName);
        buffer.method_10814(this.skinURL);
        buffer.method_10797(this.skinUUID);
        buffer.method_10817((Enum)this.skinType);
        buffer.method_10814(this.skinVariant);
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        boolean successfullyChanged;
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null || this.skinName == null || this.skinType == null || easyNPC.getEasyNPCSkinData() == null) {
            log.error("Skin validation failed for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        switch (this.skinType) {
            case NONE: {
                boolean bl = SkinHandler.setNoneSkin(easyNPC);
                break;
            }
            case CUSTOM: {
                boolean bl = SkinHandler.setCustomSkin(easyNPC, this.skinUUID);
                break;
            }
            case DEFAULT: {
                boolean bl = SkinHandler.setDefaultSkin(easyNPC, this.skinVariant);
                break;
            }
            case PLAYER_SKIN: {
                UUID userUUID = this.skinUUID;
                if (userUUID == null || Constants.BLANK_UUID.equals(this.skinUUID)) {
                    log.debug("Try to convert user {} to UUID ...", (Object)this.skinName);
                    userUUID = PlayersUtils.getUserUUID(serverPlayer.method_5682(), this.skinName);
                }
                boolean bl = SkinHandler.setPlayerSkin(easyNPC, this.skinName, userUUID);
                break;
            }
            case SECURE_REMOTE_URL: 
            case INSECURE_REMOTE_URL: {
                boolean bl = SkinHandler.setRemoteSkin(easyNPC, this.skinURL);
                break;
            }
            default: {
                log.error("Failed processing skin:{} uuid:{} url:{} type:{} for {} from {}", (Object)this.skinName, (Object)this.skinUUID, (Object)this.skinURL, (Object)this.skinType, easyNPC, (Object)serverPlayer);
                boolean bl = successfullyChanged = false;
            }
        }
        if (!successfullyChanged) {
            log.error("Failed changing skin:{} uuid:{} url:{} type:{} for {} from {}", (Object)this.skinName, (Object)this.skinUUID, (Object)this.skinURL, (Object)this.skinType, easyNPC, (Object)serverPlayer);
        }
    }
}

