/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.model.ModelScaleAxis;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ScaleData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record ChangeScaleMessage(UUID uuid, ModelScaleAxis scaleAxis, Float scaleValue) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = class_2960.method_60655((String)"easy_npc", (String)"change_scale");
    public static final class_8710.class_9154<ChangeScaleMessage> PAYLOAD_TYPE = new class_8710.class_9154(MESSAGE_ID);
    public static final class_9139<class_9129, ChangeScaleMessage> STREAM_CODEC = class_9139.method_56437((buffer, message) -> message.write((class_2540)buffer), ChangeScaleMessage::create);

    public static ChangeScaleMessage create(class_2540 buffer) {
        return new ChangeScaleMessage(buffer.method_10790(), (ModelScaleAxis)buffer.method_10818(ModelScaleAxis.class), Float.valueOf(buffer.readFloat()));
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.scaleAxis);
        buffer.method_52941(this.scaleValue.floatValue());
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.scaleAxis == null) {
            log.error("Invalid scale axis request for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.scaleValue == null || this.scaleValue.floatValue() < 0.1f || this.scaleValue.floatValue() > 10.0f) {
            log.error("Invalid scale {} request for UUID {} from {}", (Object)this.scaleValue, easyNPC, (Object)serverPlayer);
            return;
        }
        ScaleData<?> scaleData = easyNPC.getEasyNPCScaleData();
        if (scaleData == null) {
            log.error("Invalid scale data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        scaleData.setModelScaleAxis(this.scaleAxis, this.scaleValue);
    }
}

