/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4050;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record ChangeModelRotationMessage(UUID uuid, ModelPart modelPart, CustomRotation rotation) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = class_2960.method_60655((String)"easy_npc", (String)"change_model_rotation");
    public static final class_8710.class_9154<ChangeModelRotationMessage> PAYLOAD_TYPE = new class_8710.class_9154(MESSAGE_ID);
    public static final class_9139<class_9129, ChangeModelRotationMessage> STREAM_CODEC = class_9139.method_56437((buffer, message) -> message.write((class_2540)buffer), ChangeModelRotationMessage::create);

    public static ChangeModelRotationMessage create(class_2540 buffer) {
        return new ChangeModelRotationMessage(buffer.method_10790(), (ModelPart)buffer.method_10818(ModelPart.class), new CustomRotation(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()));
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.modelPart);
        buffer.method_52941(this.rotation.x());
        buffer.method_52941(this.rotation.y());
        buffer.method_52941(this.rotation.z());
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.modelPart == null) {
            log.error("Invalid modelPart for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.rotation == null) {
            log.error("Invalid rotation for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change {} rotation to {}\u00b0 {}\u00b0 {}\u00b0 for {} from {}", (Object)this.modelPart, (Object)Float.valueOf(this.rotation.x()), (Object)Float.valueOf(this.rotation.y()), (Object)Float.valueOf(this.rotation.z()), easyNPC, (Object)serverPlayer);
        if (this.modelPart != ModelPart.ROOT) {
            easyNPC.getEntity().method_18380(class_4050.field_18076);
            modelData.setModelPose(ModelPose.CUSTOM);
        }
        modelData.setModelPartRotation(this.modelPart, this.rotation);
        if (!modelData.hasChangedModel()) {
            log.debug("Reset custom model pose for {} from {}", easyNPC, (Object)serverPlayer);
            modelData.setModelPose(ModelPose.DEFAULT);
            easyNPC.getEntity().method_18380(class_4050.field_18076);
        }
    }
}

