/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4050;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record ChangeModelPositionMessage(UUID uuid, ModelPart modelPart, CustomPosition position) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = class_2960.method_60655((String)"easy_npc", (String)"change_model_position");
    public static final class_8710.class_9154<ChangeModelPositionMessage> PAYLOAD_TYPE = new class_8710.class_9154(MESSAGE_ID);
    public static final class_9139<class_9129, ChangeModelPositionMessage> STREAM_CODEC = class_9139.method_56437((buffer, message) -> message.write((class_2540)buffer), ChangeModelPositionMessage::create);

    public static ChangeModelPositionMessage create(class_2540 buffer) {
        return new ChangeModelPositionMessage(buffer.method_10790(), (ModelPart)buffer.method_10818(ModelPart.class), new CustomPosition(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()));
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.modelPart);
        buffer.method_52941(this.position.x());
        buffer.method_52941(this.position.y());
        buffer.method_52941(this.position.z());
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.modelPart == null) {
            log.error("Invalid modelPart for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.position == null) {
            log.error("Invalid position for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change {} position to {}\u00b0 for {} from {}", (Object)this.modelPart, (Object)this.position, easyNPC, (Object)serverPlayer);
        if (this.modelPart != ModelPart.ROOT) {
            easyNPC.getEntity().method_18380(class_4050.field_18076);
            modelData.setModelPose(ModelPose.CUSTOM);
        }
        modelData.setModelPartPosition(this.modelPart, this.position);
        if (!modelData.hasChangedModel()) {
            log.debug("Reset custom model pose for {} from {}", easyNPC, (Object)serverPlayer);
            modelData.setModelPose(ModelPose.DEFAULT);
        }
    }
}

