/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public record ChangeActionEventMessage(UUID uuid, ActionEventType actionEventType, ActionDataSet actionDataSet) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = class_2960.method_60655((String)"easy_npc", (String)"change_action_event");
    public static final class_8710.class_9154<ChangeActionEventMessage> PAYLOAD_TYPE = new class_8710.class_9154(MESSAGE_ID);
    public static final class_9139<class_9129, ChangeActionEventMessage> STREAM_CODEC = class_9139.method_56437((buffer, message) -> message.write((class_2540)buffer), ChangeActionEventMessage::create);

    public static ChangeActionEventMessage create(class_2540 buffer) {
        return new ChangeActionEventMessage(buffer.method_10790(), (ActionEventType)buffer.method_10818(ActionEventType.class), new ActionDataSet(buffer.method_10798()));
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.actionEventType);
        buffer.method_10794((class_2520)this.actionDataSet.createTag());
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null || this.actionEventType == null || this.actionEventType == ActionEventType.NONE || this.actionDataSet == null) {
            log.error("Failed to change action event for {}: Invalid data", easyNPC);
            return;
        }
        int permissionLevel = 0;
        MinecraftServer minecraftServer = serverPlayer.method_5682();
        ActionEventData<?> actionEventData = easyNPC.getEasyNPCActionEventData();
        if (minecraftServer != null) {
            permissionLevel = minecraftServer.method_3835(serverPlayer.method_7334());
            log.debug("Set action owner permission level {} for {} from {}", (Object)permissionLevel, easyNPC, (Object)serverPlayer);
            actionEventData.setActionPermissionLevel(permissionLevel);
        } else {
            log.warn("Unable to verify permission level from {} for {}", (Object)this, (Object)serverPlayer);
        }
        log.debug("Set action event {} with {} for {} from {} with owner permission level {}.", (Object)this.actionEventType, (Object)this.actionDataSet, easyNPC, (Object)serverPlayer, (Object)permissionLevel);
        actionEventData.getActionEventSet().setActionEvent(this.actionEventType, this.actionDataSet);
    }
}

