/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import io.netty.buffer.Unpooled;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface NetworkMessageRecord
extends class_8710 {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC");
    public static final UUID EMPTY_UUID = new UUID(0L, 0L);
    public static final Random RANDOM = new Random();

    public static boolean checkAccess(UUID uuid, class_3222 serverPlayer) {
        if (uuid == null || uuid.equals(EMPTY_UUID)) {
            log.error("Unable to get valid entity UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return false;
        }
        if (serverPlayer == null) {
            log.error("Unable to get valid player for entity with UUID {}", (Object)uuid);
            return false;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("Unable to get valid entity with UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return false;
        }
        if (!LivingEntityManager.hasAccess(uuid, serverPlayer)) {
            log.error("User {} has no access to Easy NPC with uuid {}.", (Object)serverPlayer, (Object)uuid);
            return false;
        }
        return true;
    }

    public class_2960 id();

    public void write(class_2540 var1);

    default public class_2540 payload() {
        class_2540 friendlyByteBuf = new class_2540(Unpooled.buffer());
        this.write(friendlyByteBuf);
        return friendlyByteBuf;
    }

    default public void handleClient() {
        log.error("Network message client handler not implemented for {}", (Object)this);
    }

    default public void handleServer(class_3222 serverPlayer) {
        log.error("Network message server handler not implemented for {}", (Object)this);
    }

    default public EasyNPC<?> getEasyNPC(UUID uuid, class_3222 serverPlayer) {
        if (uuid == null || uuid.equals(EMPTY_UUID)) {
            log.error("Invalid Easy NPC UUID {} from {}", (Object)uuid, (Object)serverPlayer);
            return null;
        }
        if (serverPlayer == null) {
            log.error("Invalid server player for Easy NPC with UUID {}", (Object)uuid);
            return null;
        }
        return LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
    }

    default public EasyNPC<?> getEasyNPCAndCheckAccess(UUID uuid, class_3222 serverPlayer) {
        return NetworkMessageRecord.checkAccess(uuid, serverPlayer) ? this.getEasyNPC(uuid, serverPlayer) : null;
    }
}

