/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network;

import de.markusbordihn.easynpc.network.NetworkHandlerManager;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface NetworkHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC");
    public static final String LOG_PREFIX = "[NetworkHandler]";
    public static final int PROTOCOL_VERSION = 23;

    public <M extends NetworkMessageRecord> void registerClientNetworkMessageHandler(class_8710.class_9154<M> var1, class_9139<class_9129, M> var2, Class<M> var3, Function<class_2540, M> var4);

    public <M extends NetworkMessageRecord> void registerServerNetworkMessageHandler(class_8710.class_9154<M> var1, class_9139<class_9129, M> var2, Class<M> var3, Function<class_2540, M> var4);

    public <M extends NetworkMessageRecord> void sendToServer(M var1);

    public <M extends NetworkMessageRecord> void sendToPlayer(M var1, class_3222 var2);

    public <M extends NetworkMessageRecord> void addClientMessage(class_8710.class_9154<M> var1, Class<M> var2);

    public <M extends NetworkMessageRecord> void addServerMessage(class_8710.class_9154<M> var1, Class<M> var2);

    public Map<class_8710.class_9154<?>, Class<? extends NetworkMessageRecord>> getClientMessages();

    public Map<class_8710.class_9154<?>, Class<? extends NetworkMessageRecord>> getServerMessages();

    public <M extends NetworkMessageRecord> void addRegisteredClientMessage(class_8710.class_9154<M> var1, Class<M> var2);

    public <M extends NetworkMessageRecord> void addRegisteredServerMessage(class_8710.class_9154<M> var1, Class<M> var2);

    public Map<class_8710.class_9154<?>, Class<? extends NetworkMessageRecord>> getRegisteredClientMessages();

    public Map<class_8710.class_9154<?>, Class<? extends NetworkMessageRecord>> getRegisteredServerMessages();

    default public <M extends NetworkMessageRecord> void registerClientPayloadType(class_8710.class_9154<M> type, class_9139<class_9129, M> codec) {
    }

    default public <M extends NetworkMessageRecord> void registerServerPayloadType(class_8710.class_9154<M> type, class_9139<class_9129, M> codec) {
    }

    default public boolean sendMessageToPlayer(NetworkMessageRecord networkMessageRecord, class_3222 serverPlayer) {
        if (!this.hasClientMessage(networkMessageRecord.method_56479())) {
            log.error("{} Message {} is not registered as client message", (Object)LOG_PREFIX, (Object)networkMessageRecord.method_56479());
            return false;
        }
        try {
            this.sendToPlayer(networkMessageRecord, serverPlayer);
        }
        catch (Exception e) {
            log.error("{} Failed to send message {} to player {}", (Object)LOG_PREFIX, (Object)networkMessageRecord.id(), (Object)serverPlayer.method_5477().getString(), (Object)e);
            return false;
        }
        return true;
    }

    default public boolean sendMessageToServer(NetworkMessageRecord networkMessageRecord) {
        if (!this.hasServerMessage(networkMessageRecord.method_56479())) {
            log.error("{} Message {} is not registered as server message", (Object)LOG_PREFIX, (Object)networkMessageRecord.method_56479());
            return false;
        }
        if (class_310.method_1551().method_1562() == null) {
            log.error("{} Failed to send message {} to server: No connection available", (Object)LOG_PREFIX, (Object)networkMessageRecord.method_56479());
            return false;
        }
        try {
            this.sendToServer(networkMessageRecord);
        }
        catch (Exception e) {
            log.error("{} Failed to send message {} to server", (Object)LOG_PREFIX, (Object)networkMessageRecord.id(), (Object)e);
            return false;
        }
        return true;
    }

    default public boolean hasClientMessage(class_8710.class_9154<?> messageID) {
        return this.getClientMessages().containsKey(messageID);
    }

    default public boolean hasServerMessage(class_8710.class_9154<?> messageID) {
        return this.getServerMessages().containsKey(messageID);
    }

    default public Class<? extends NetworkMessageRecord> getRegisteredClientMessage(class_8710.class_9154<?> messageID) {
        return this.getRegisteredClientMessages().get(messageID);
    }

    default public Class<? extends NetworkMessageRecord> getRegisteredServerMessage(class_8710.class_9154<?> messageID) {
        return this.getRegisteredServerMessages().get(messageID);
    }

    default public class_8710.class_9154<?> getRegisteredClientMessageId(Class<? extends NetworkMessageRecord> networkMessage) {
        return this.getRegisteredClientMessages().entrySet().stream().filter(entry -> ((Class)entry.getValue()).equals(networkMessage)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    default public class_8710.class_9154<?> getRegisteredServerMessageId(Class<? extends NetworkMessageRecord> networkMessage) {
        return this.getRegisteredServerMessages().entrySet().stream().filter(entry -> ((Class)entry.getValue()).equals(networkMessage)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    default public boolean hasRegisteredClientMessage(class_8710.class_9154<?> messageID) {
        return this.getRegisteredClientMessages().containsKey(messageID);
    }

    default public boolean hasRegisteredClientMessage(Class<? extends NetworkMessageRecord> networkMessage) {
        return this.getRegisteredClientMessages().containsValue(networkMessage);
    }

    default public boolean hasRegisteredServerMessage(class_8710.class_9154<?> messageID) {
        return this.getRegisteredServerMessages().containsKey(messageID);
    }

    default public boolean hasRegisteredServerMessage(Class<? extends NetworkMessageRecord> networkMessage) {
        return this.getRegisteredServerMessages().containsValue(networkMessage);
    }

    default public <M extends NetworkMessageRecord> void registerServerNetworkMessage(class_8710.class_9154<M> type, class_9139<class_9129, M> codec, Class<M> networkMessage, Function<class_2540, M> creator) {
        if (!this.hasServerMessage(type)) {
            this.registerServerPayloadType(type, codec);
        }
        if (NetworkHandlerManager.isServerNetworkHandler()) {
            if (this.hasRegisteredServerMessage(type)) {
                log.error("{} Server network message id {} already registered with {}", (Object)LOG_PREFIX, type, this.getRegisteredServerMessage(type));
                return;
            }
            if (this.hasRegisteredServerMessage(networkMessage)) {
                log.error("{} Server network message {} already registered with id {}", (Object)LOG_PREFIX, networkMessage, this.getRegisteredServerMessageId(networkMessage));
                return;
            }
            try {
                this.registerServerNetworkMessageHandler(type, codec, networkMessage, creator);
                this.addRegisteredServerMessage(type, networkMessage);
            }
            catch (Exception e) {
                log.error("{} Failed to register server network message id {} with {}", (Object)LOG_PREFIX, type, networkMessage, (Object)e);
                return;
            }
        }
        this.addServerMessage(type, networkMessage);
    }

    default public <M extends NetworkMessageRecord> void registerClientNetworkMessage(class_8710.class_9154<M> type, class_9139<class_9129, M> codec, Class<M> networkMessage, Function<class_2540, M> creator) {
        if (!this.hasClientMessage(type)) {
            this.registerClientPayloadType(type, codec);
        }
        if (NetworkHandlerManager.isClientNetworkHandler()) {
            if (this.hasRegisteredClientMessage(type)) {
                log.error("{} Client network message id {} already registered with {}", (Object)LOG_PREFIX, type, this.getRegisteredClientMessage(type));
                return;
            }
            if (this.hasRegisteredClientMessage(networkMessage)) {
                log.error("{} Client network message {} already registered with id {}", (Object)LOG_PREFIX, networkMessage, this.getRegisteredClientMessageId(networkMessage));
                return;
            }
            try {
                this.registerClientNetworkMessageHandler(type, codec, networkMessage, creator);
                this.addRegisteredClientMessage(type, networkMessage);
            }
            catch (Exception e) {
                log.error("{} Failed to register client network message id {} with {}", (Object)LOG_PREFIX, type, networkMessage, (Object)e);
                return;
            }
        }
        this.addClientMessage(type, networkMessage);
    }

    default public void logRegisterClientNetworkMessageHandler(class_8710.class_9154<?> messageID, Class<?> networkMessage) {
        log.info("{} Registering client network message {} with {}", (Object)LOG_PREFIX, (Object)networkMessage.getSimpleName(), messageID);
    }

    default public void logRegisterClientNetworkMessageHandler(class_8710.class_9154<?> messageID, Class<?> networkMessage, int registrationID) {
        log.info("{} Registering client network message {} with {} ({})", (Object)LOG_PREFIX, (Object)networkMessage.getSimpleName(), messageID, (Object)registrationID);
    }

    default public void logRegisterServerNetworkMessageHandler(class_8710.class_9154<?> messageID, Class<?> networkMessage) {
        log.info("{} Registering server network message {} with {}", (Object)LOG_PREFIX, (Object)networkMessage.getSimpleName(), messageID);
    }

    default public void logRegisterServerNetworkMessageHandler(class_8710.class_9154<?> messageID, Class<?> networkMessage, int registrationID) {
        log.info("{} Registering server network message {} with {} ({})", (Object)LOG_PREFIX, (Object)networkMessage.getSimpleName(), messageID, (Object)registrationID);
    }
}

