/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network;

import de.markusbordihn.easynpc.network.NetworkHandlerInterface;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class NetworkHandler
implements NetworkHandlerInterface {
    private final Map<class_8710.class_9154<?>, Class<? extends NetworkMessageRecord>> clientMessages = new LinkedHashMap();
    private final Map<class_8710.class_9154<?>, Class<? extends NetworkMessageRecord>> serverMessages = new LinkedHashMap();
    private final Map<class_8710.class_9154<?>, Class<? extends NetworkMessageRecord>> registeredClientMessages = new LinkedHashMap();
    private final Map<class_8710.class_9154<?>, Class<? extends NetworkMessageRecord>> registeredServerMessages = new LinkedHashMap();

    public NetworkHandler() {
        log.info("{} NetworkHandler ...", (Object)"\ud83d\udde3 Register Easy NPC");
    }

    public void sendToServer(NetworkMessageRecord networkMessageRecord) {
        ClientPlayNetworking.send((class_8710)networkMessageRecord);
    }

    public void sendToPlayer(NetworkMessageRecord networkMessageRecord, class_3222 serverPlayer) {
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)networkMessageRecord);
    }

    @Override
    public <M extends NetworkMessageRecord> void registerClientPayloadType(class_8710.class_9154<M> type, class_9139<class_9129, M> codec) {
        log.info("Registering client payload type {} with {}", type, codec);
        PayloadTypeRegistry.playS2C().register(type, codec);
    }

    @Override
    public <M extends NetworkMessageRecord> void registerServerPayloadType(class_8710.class_9154<M> type, class_9139<class_9129, M> codec) {
        log.info("Registering server payload type {} with {}", type, codec);
        PayloadTypeRegistry.playC2S().register(type, codec);
    }

    @Override
    public <M extends NetworkMessageRecord> void registerClientNetworkMessageHandler(class_8710.class_9154<M> type, class_9139<class_9129, M> codec, Class<M> networkMessageRecord, Function<class_2540, M> creator) {
        if (!ClientPlayNetworking.registerGlobalReceiver(type, (payload, context) -> payload.handleClient())) {
            log.error("Failed to register client network message handler {}:", type);
        } else {
            this.logRegisterClientNetworkMessageHandler(type, networkMessageRecord);
        }
    }

    @Override
    public <M extends NetworkMessageRecord> void registerServerNetworkMessageHandler(class_8710.class_9154<M> type, class_9139<class_9129, M> codec, Class<M> networkMessageRecord, Function<class_2540, M> creator) {
        if (!ServerPlayNetworking.registerGlobalReceiver(type, (payload, context) -> payload.handleServer(context.player()))) {
            log.error("Failed to register server network message handler {}:", type);
        } else {
            this.logRegisterServerNetworkMessageHandler(type, networkMessageRecord);
        }
    }

    @Override
    public <M extends NetworkMessageRecord> void addClientMessage(class_8710.class_9154<M> messageID, Class<M> networkMessage) {
        this.clientMessages.put(messageID, networkMessage);
    }

    @Override
    public <M extends NetworkMessageRecord> void addServerMessage(class_8710.class_9154<M> messageID, Class<M> networkMessage) {
        this.serverMessages.put(messageID, networkMessage);
    }

    @Override
    public Map<class_8710.class_9154<?>, Class<? extends NetworkMessageRecord>> getClientMessages() {
        return this.clientMessages;
    }

    @Override
    public Map<class_8710.class_9154<?>, Class<? extends NetworkMessageRecord>> getServerMessages() {
        return this.serverMessages;
    }

    @Override
    public <M extends NetworkMessageRecord> void addRegisteredClientMessage(class_8710.class_9154<M> messageID, Class<M> networkMessage) {
        this.registeredClientMessages.put(messageID, networkMessage);
    }

    @Override
    public <M extends NetworkMessageRecord> void addRegisteredServerMessage(class_8710.class_9154<M> messageID, Class<M> networkMessage) {
        this.registeredServerMessages.put(messageID, networkMessage);
    }

    @Override
    public Map<class_8710.class_9154<?>, Class<? extends NetworkMessageRecord>> getRegisteredClientMessages() {
        return this.registeredClientMessages;
    }

    @Override
    public Map<class_8710.class_9154<?>, Class<? extends NetworkMessageRecord>> getRegisteredServerMessages() {
        return this.registeredServerMessages;
    }
}

