/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.item.configuration;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCPresetItem
extends class_1792 {
    public static final String ENTITY_TYPE_TAG = "EntityType";
    public static final String NAME = "easy_npc_preset";
    public static final String PRESET_TAG = "Preset";
    public static final String SPAWNER_UUID_TAG = "SpawnerUUID";
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final String FALL_DISTANCE_TAG = "FallDistance";
    private static final String FIRE_TAG = "Fire";
    private static final String MOTION_TAG = "Motion";
    private static final String ON_GROUND_TAG = "OnGround";
    private static final String CUSTOM_NAME_TAG = "CustomName";
    private static final String TEXT_TAG = "text";

    public EasyNPCPresetItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static boolean hasPreset(class_1799 itemStack) {
        class_9279 customData = (class_9279)itemStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
        return customData != null && customData.method_57450(PRESET_TAG) && !customData.method_57463().method_10562(PRESET_TAG).method_33133();
    }

    public static class_2487 getPreset(class_1799 itemStack) {
        class_9279 customData = (class_9279)itemStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
        return customData.method_57450(PRESET_TAG) ? customData.method_57463().method_10562(PRESET_TAG) : new class_2487();
    }

    public static void savePreset(class_1799 itemStack, class_2960 entityType, class_2487 presetData) {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10582(ENTITY_TYPE_TAG, entityType.toString());
        compoundTag.method_10566(PRESET_TAG, (class_2520)presetData);
        if (compoundTag.method_10545(FIRE_TAG)) {
            compoundTag.method_10551(FIRE_TAG);
        }
        if (compoundTag.method_10545(FALL_DISTANCE_TAG)) {
            compoundTag.method_10551(FALL_DISTANCE_TAG);
        }
        if (compoundTag.method_10545(MOTION_TAG)) {
            compoundTag.method_10551(MOTION_TAG);
        }
        if (compoundTag.method_10545(ON_GROUND_TAG)) {
            compoundTag.method_10551(ON_GROUND_TAG);
        }
        class_9279.method_57453((class_9331)class_9334.field_49628, (class_1799)itemStack, (class_2487)compoundTag);
    }

    public static String getCustomName(class_1799 itemStack) {
        class_2487 customNameTag;
        class_2487 compoundTag = EasyNPCPresetItem.getPreset(itemStack);
        if (compoundTag.method_10545(CUSTOM_NAME_TAG) && (customNameTag = compoundTag.method_10562(CUSTOM_NAME_TAG)).method_10545(TEXT_TAG)) {
            return customNameTag.method_10558(TEXT_TAG);
        }
        return null;
    }

    public static boolean hasEntityType(class_1799 itemStack) {
        class_9279 customData = (class_9279)itemStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
        return customData.method_57450(ENTITY_TYPE_TAG) && !customData.method_57463().method_10558(ENTITY_TYPE_TAG).isEmpty();
    }

    public static class_1299<?> getEntityType(class_1799 itemStack) {
        class_9279 customData = (class_9279)itemStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
        if (customData.method_57450(ENTITY_TYPE_TAG)) {
            return class_1299.method_5898((String)customData.method_57463().method_10558(ENTITY_TYPE_TAG)).orElse(null);
        }
        return null;
    }

    public static void setSpawnerUUID(class_1799 itemStack, UUID uuid) {
        class_9279 customData = (class_9279)itemStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 compoundTag = customData.method_57463();
        if (uuid != null) {
            compoundTag.method_25927(SPAWNER_UUID_TAG, uuid);
        } else {
            compoundTag.method_10551(SPAWNER_UUID_TAG);
        }
        class_9279.method_57453((class_9331)class_9334.field_49628, (class_1799)itemStack, (class_2487)compoundTag);
    }

    public static UUID getSpawnerUUID(class_1799 itemStack) {
        class_9279 customData = (class_9279)itemStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
        return customData.method_57450(SPAWNER_UUID_TAG) ? customData.method_57463().method_25926(SPAWNER_UUID_TAG) : null;
    }

    public static boolean spawnAtPosition(class_2338 blockPos, class_1799 itemStack, class_1937 level) {
        if (level.field_9236 || !EasyNPCPresetItem.hasPreset(itemStack) || !EasyNPCPresetItem.hasEntityType(itemStack)) {
            return false;
        }
        class_2487 entityPreset = EasyNPCPresetItem.getPreset(itemStack);
        class_1299<?> entityType = EasyNPCPresetItem.getEntityType(itemStack);
        if (entityType == null) {
            log.error("No valid entity type found in {}!", (Object)itemStack);
            return false;
        }
        class_1297 entity = entityType.method_5883(level);
        if (entity == null) {
            log.error("Unable to create entity for {} in {}", entityType, (Object)level);
            return false;
        }
        if (entityPreset.method_10545("UUID")) {
            entityPreset.method_10551("UUID");
        }
        entity.method_5651(entityPreset);
        UUID spawnerUUID = EasyNPCPresetItem.getSpawnerUUID(itemStack);
        if (spawnerUUID != null && entity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)entity;
            easyNPC.getEasyNPCSpawnerData().setSpawnerUUID(EasyNPCPresetItem.getSpawnerUUID(itemStack));
        }
        entity.method_24203((double)((float)blockPos.method_10263() + 0.5f), (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + 0.5f));
        if (level.method_8649(entity)) {
            log.debug("Spawned {} at {} from spawner {} with {} in {}", entityType, (Object)blockPos, (Object)spawnerUUID, (Object)entityPreset, (Object)level);
            return true;
        }
        return false;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 level = context.method_8045();
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        class_1799 itemStack = context.method_8041();
        if (itemStack.method_7960() || !EasyNPCPresetItem.hasPreset(itemStack) || !EasyNPCPresetItem.hasEntityType(itemStack)) {
            log.warn("No valid preset found in {}!", (Object)itemStack);
            return class_1269.field_5814;
        }
        Iterable possibleSpawnPositions = class_2338.method_30512((class_2338)context.method_8037(), (int)4, (class_2350)class_2350.field_11043, (class_2350)class_2350.field_11034);
        for (class_2338.class_2339 blockPos : possibleSpawnPositions) {
            class_238 aabb = new class_238((class_2338)blockPos).method_1014(0.1);
            class_2338 targetBlockPos = new class_2338(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
            if (!level.method_8320(targetBlockPos.method_10084()).method_26215() || !level.method_18467(class_1297.class, aabb).isEmpty() || !EasyNPCPresetItem.spawnAtPosition(targetBlockPos, itemStack, level)) continue;
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean method_7885(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player) {
        return false;
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltipList, class_1836 tooltipFlag) {
        class_1299<?> entityType;
        if (EasyNPCPresetItem.hasPreset(itemStack) && (entityType = EasyNPCPresetItem.getEntityType(itemStack)) != null) {
            tooltipList.add((class_2561)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset"));
            String customName = EasyNPCPresetItem.getCustomName(itemStack);
            if (customName != null) {
                tooltipList.add((class_2561)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset.custom_name", customName));
            }
            tooltipList.add((class_2561)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset.entity_type", entityType.method_5897()));
        }
    }
}

