/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationData;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PresetHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    private PresetHandler() {
    }

    public static boolean importPreset(class_3218 serverLevel, class_2487 compoundTag, class_243 position, UUID uuid, class_3222 serverPlayer) {
        if (position != null) {
            class_2499 posTag = new class_2499();
            posTag.add((Object)class_2489.method_23241((double)position.field_1352));
            posTag.add((Object)class_2489.method_23241((double)position.field_1351));
            posTag.add((Object)class_2489.method_23241((double)position.field_1350));
            compoundTag.method_10566("Pos", (class_2520)posTag);
        }
        if (uuid != null) {
            compoundTag.method_25927("UUID", uuid);
        }
        if (!PresetHandler.importPreset(serverLevel, compoundTag)) {
            return false;
        }
        UUID compoundUUID = compoundTag.method_25926("UUID");
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(compoundUUID, serverLevel);
        if (easyNPC == null) {
            log.error("[{}] Error importing preset {}, no entity found for {}", (Object)serverLevel, (Object)compoundTag, (Object)compoundUUID);
            return false;
        }
        OwnerData<?> ownerData = easyNPC.getEasyNPCOwnerData();
        if (serverPlayer != null && ownerData != null) {
            ownerData.setOwner((class_1309)serverPlayer);
        }
        if (position != null) {
            NavigationData<?> navigationData = easyNPC.getEasyNPCNavigationData();
            if (navigationData == null) {
                log.warn("[{}] Warning: Importing preset, no navigation data available for {}", (Object)serverLevel, easyNPC);
            } else if (!easyNPC.getEntity().method_19538().equals((Object)position)) {
                navigationData.setHomePosition(new class_2338((int)position.field_1352, (int)position.field_1351, (int)position.field_1350));
            }
        }
        log.debug("[{}] Imported preset data {} for {}", (Object)serverLevel, (Object)compoundUUID, easyNPC);
        return true;
    }

    public static boolean importPreset(class_3218 serverLevel, class_2487 compoundTag) {
        class_1297 entity;
        UUID existingUUID;
        class_1299 entityType;
        if (serverLevel == null || compoundTag == null) {
            log.error("[{}] Error importing preset ", (Object)serverLevel);
            return false;
        }
        if (compoundTag.method_33133()) {
            log.error("[{}] Empty preset data for import", (Object)serverLevel);
            return false;
        }
        class_1299 class_12992 = entityType = compoundTag.method_10545("id") ? (class_1299)class_1299.method_5898((String)compoundTag.method_10558("id")).orElse(null) : null;
        if (entityType == null) {
            log.error("[{}] Error importing preset, invalid entity type", (Object)serverLevel);
            return false;
        }
        UUID uUID = existingUUID = compoundTag.method_10545("UUID") ? compoundTag.method_25926("UUID") : null;
        if (existingUUID != null && LivingEntityManager.getEasyNPCEntityByUUID(existingUUID, serverLevel) != null) {
            EasyNPC<?> existingEasyNPC = LivingEntityManager.getEasyNPCEntityByUUID(existingUUID, serverLevel);
            if (compoundTag.method_10545("id") && !compoundTag.method_10558("id").isEmpty() && compoundTag.method_10558("id").equals(existingEasyNPC.getEntityTypeId()) && existingEasyNPC.getEasyNPCPresetData() != null) {
                log.debug("[{}] Update preset data for existing entity {}!", (Object)serverLevel, existingEasyNPC);
                existingEasyNPC.getEasyNPCPresetData().importPresetData(compoundTag);
                return true;
            }
            LivingEntityManager.discardEasyNPCEntityByUUID(existingUUID, serverLevel);
        }
        if (!((entity = entityType.method_5883((class_1937)serverLevel)) instanceof EasyNPC)) {
            log.error("[{}] Error importing preset, invalid entity with type {}", (Object)serverLevel, (Object)entityType);
            return false;
        }
        EasyNPC easyNPCEntity = (EasyNPC)entity;
        PresetData presetData = easyNPCEntity.getEasyNPCPresetData();
        if (presetData == null) {
            log.error("[{}] Error importing preset, no preset data available for {}", (Object)serverLevel, (Object)easyNPCEntity);
            return false;
        }
        presetData.importPresetData(compoundTag);
        if (!serverLevel.method_8649(easyNPCEntity.getEntity())) {
            log.error("[{}] Error spawning entity", (Object)easyNPCEntity);
            return false;
        }
        log.debug("[{}] Imported preset data {} for {}", (Object)serverLevel, (Object)compoundTag, (Object)easyNPCEntity);
        return true;
    }

    public static boolean importCustomPreset(class_3218 serverLevel, class_2960 presetLocation, class_243 position, UUID uuid, class_3222 serverPlayer) {
        if (serverLevel == null || presetLocation == null) {
            log.error("[{}] Error importing custom preset ", (Object)serverLevel);
            return false;
        }
        Path presetFile = CustomPresetDataFiles.getPresetsResourceLocationPath(presetLocation);
        if (presetFile == null || !presetFile.toFile().exists()) {
            log.error("[{}] Error importing custom preset, no preset file found at {}", (Object)serverLevel, (Object)presetLocation);
            return false;
        }
        try {
            class_2487 compoundTag = class_2507.method_30613((Path)presetFile.toFile().toPath(), (class_2505)class_2505.method_53898());
            return PresetHandler.importPreset(serverLevel, compoundTag, position, uuid, serverPlayer);
        }
        catch (IOException exception) {
            log.error("[{}] Error reading custom preset file {}", (Object)serverLevel, (Object)presetFile, (Object)exception);
            return false;
        }
    }

    public static boolean exportCustomPreset(EasyNPC<?> easyNPC, String name) {
        SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
        if (skinData == null) {
            log.warn("[{}] Error no skin data available!", easyNPC);
            return false;
        }
        File presetFile = CustomPresetDataFiles.getPresetFile(skinData.getSkinModel(), name);
        return PresetHandler.exportPreset(easyNPC, presetFile);
    }

    public static boolean importDataPreset(class_3218 serverLevel, class_2960 presetLocation, class_243 position, UUID uuid, class_3222 serverPlayer) {
        if (serverLevel == null || presetLocation == null) {
            log.error("[{}] Error importing data preset ", (Object)serverLevel);
            return false;
        }
        MinecraftServer minecraftServer = serverLevel.method_8503();
        if (minecraftServer.method_34864().method_14486(presetLocation).isEmpty()) {
            log.error("[{}] Error importing data preset, no preset file found at {}", (Object)serverLevel, (Object)presetLocation);
            return false;
        }
        try {
            class_2487 compoundTag = class_2507.method_10629((InputStream)minecraftServer.method_34864().open(presetLocation), (class_2505)class_2505.method_53898());
            return PresetHandler.importPreset(serverLevel, compoundTag, position, uuid, serverPlayer);
        }
        catch (IOException exception) {
            log.error("[{}] Error reading data preset file {}", (Object)serverLevel, (Object)presetLocation, (Object)exception);
            return false;
        }
    }

    public static boolean importDefaultPreset(class_3218 serverLevel, class_2960 presetLocation, class_243 position, UUID uuid, class_3222 serverPlayer) {
        if (serverLevel == null || presetLocation == null) {
            log.error("[{}] Error importing default preset ", (Object)serverLevel);
            return false;
        }
        MinecraftServer minecraftServer = serverLevel.method_8503();
        if (minecraftServer.method_34864().method_14486(presetLocation).isEmpty()) {
            log.error("[{}] Error importing data preset, no preset file found at {}", (Object)serverLevel, (Object)presetLocation);
            return false;
        }
        try {
            class_2487 compoundTag = class_2507.method_10629((InputStream)minecraftServer.method_34864().open(presetLocation), (class_2505)class_2505.method_53898());
            return PresetHandler.importPreset(serverLevel, compoundTag, position, uuid, serverPlayer);
        }
        catch (IOException exception) {
            log.error("[{}] Error reading default preset file {}", (Object)serverLevel, (Object)presetLocation, (Object)exception);
            return false;
        }
    }

    public static boolean importLocalPreset(class_3218 serverLevel, class_2487 compoundTag, class_2960 presetLocation, class_243 position, UUID uuid, class_3222 serverPlayer) {
        if (serverLevel == null || presetLocation == null) {
            log.error("[{}] Error importing local preset {}", (Object)serverLevel, (Object)presetLocation);
            return false;
        }
        if (compoundTag == null || compoundTag.method_33133()) {
            log.error("[{}] Error importing local preset {}, no preset data found!", (Object)serverLevel, (Object)presetLocation);
            return false;
        }
        if (PresetHandler.importPreset(serverLevel, compoundTag, position, uuid, serverPlayer)) {
            return true;
        }
        log.error("[{}] Error reading data preset file {}", (Object)serverLevel, (Object)presetLocation);
        return false;
    }

    public static boolean importWorldPreset(class_3218 serverLevel, class_2960 presetLocation, class_243 position, UUID uuid, class_3222 serverPlayer) {
        if (serverLevel == null || presetLocation == null) {
            log.error("[{}] Error importing world preset ", (Object)serverLevel);
            return false;
        }
        Path presetFile = WorldPresetDataFiles.getPresetsResourceLocationPath(presetLocation);
        if (presetFile == null || !presetFile.toFile().exists()) {
            log.error("[{}] Error importing world preset, no preset file found at {}", (Object)serverLevel, (Object)presetLocation);
            return false;
        }
        try {
            class_2487 compoundTag = class_2507.method_30613((Path)presetFile.toFile().toPath(), (class_2505)class_2505.method_53898());
            return PresetHandler.importPreset(serverLevel, compoundTag, position, uuid, serverPlayer);
        }
        catch (IOException exception) {
            log.error("[{}] Error reading world preset file {}", (Object)serverLevel, (Object)presetFile, (Object)exception);
            return false;
        }
    }

    public static boolean exportWorldPreset(EasyNPC<?> easyNPC, String name) {
        SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
        if (skinData == null) {
            log.warn("[{}] Error no skin data available!", easyNPC);
            return false;
        }
        File presetFile = WorldPresetDataFiles.getPresetFile(skinData.getSkinModel(), name);
        return PresetHandler.exportPreset(easyNPC, presetFile);
    }

    public static boolean exportPreset(EasyNPC<?> easyNPC, File file) {
        if (easyNPC == null || file == null) {
            log.error("[{}] Error exporting preset {} !", easyNPC, (Object)file);
            return false;
        }
        PresetData<?> presetData = easyNPC.getEasyNPCPresetData();
        if (presetData == null) {
            log.error("[{}] Error no preset data available!", easyNPC);
            return false;
        }
        class_2487 compoundTag = presetData.exportPresetData();
        if (compoundTag == null || compoundTag.method_33133()) {
            log.error("[{}] Error exporting custom preset {}!", easyNPC, (Object)file);
            return false;
        }
        return PresetHandler.exportPreset(file, compoundTag);
    }

    public static boolean exportPreset(File file, class_2487 compoundTag) {
        if (file == null || compoundTag == null) {
            log.error("Error exporting preset file {} with {} !", (Object)file, (Object)compoundTag);
            return false;
        }
        if (compoundTag.method_33133()) {
            log.error("Empty preset data for export to {} !", (Object)file);
            return false;
        }
        try {
            class_2507.method_30614((class_2487)compoundTag, (Path)file.toPath());
            return true;
        }
        catch (IOException exception) {
            log.error("Failed to export preset file {} with {}:", (Object)file, (Object)compoundTag, (Object)exception);
            return false;
        }
    }
}

