/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelScaleAxis;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.EnumMap;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;

public interface ScaleData<T extends class_1314>
extends EasyNPC<T> {
    public static final float DEFAULT_SCALE_X = 1.0f;
    public static final float DEFAULT_SCALE_Y = 1.0f;
    public static final float DEFAULT_SCALE_Z = 1.0f;
    public static final String EASY_NPC_DATA_SCALE_DATA_TAG = "ScaleData";

    public static void registerSyncedScaleData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("- Registering Synched Scale Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.SCALE_X, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13320));
        map.put(SynchedDataIndex.SCALE_Y, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13320));
        map.put(SynchedDataIndex.SCALE_Z, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13320));
    }

    default public Float getDefaultScaleX() {
        return Float.valueOf(1.0f);
    }

    default public Float getDefaultScaleY() {
        return Float.valueOf(1.0f);
    }

    default public Float getDefaultScaleZ() {
        return Float.valueOf(1.0f);
    }

    default public void setModelScaleAxis(ModelScaleAxis scaleAxis, Float scaleValue) {
        switch (scaleAxis) {
            case X: {
                this.setScaleX(scaleValue);
                break;
            }
            case Y: {
                this.setScaleY(scaleValue);
                break;
            }
            case Z: {
                this.setScaleZ(scaleValue);
                break;
            }
            default: {
                log.error("Invalid scale axis {} for {}", (Object)scaleAxis, (Object)this);
            }
        }
    }

    default public Float getScaleX() {
        return (Float)this.getSynchedEntityData(SynchedDataIndex.SCALE_X);
    }

    default public void setScaleX(Float scale) {
        if (!Objects.equals(this.getScaleX(), scale)) {
            this.setSynchedEntityData(SynchedDataIndex.SCALE_X, scale);
            this.getEntity().method_18382();
        }
    }

    default public Float getScaleY() {
        return (Float)this.getSynchedEntityData(SynchedDataIndex.SCALE_Y);
    }

    default public void setScaleY(Float scale) {
        if (!Objects.equals(this.getScaleY(), scale)) {
            this.setSynchedEntityData(SynchedDataIndex.SCALE_Y, scale);
            this.getEntity().method_18382();
        }
    }

    default public Float getScaleZ() {
        return (Float)this.getSynchedEntityData(SynchedDataIndex.SCALE_Z);
    }

    default public void setScaleZ(Float scale) {
        if (!Objects.equals(this.getScaleZ(), scale)) {
            this.setSynchedEntityData(SynchedDataIndex.SCALE_Z, scale);
            this.getEntity().method_18382();
        }
    }

    default public void defineSynchedScaleData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.SCALE_X, this.getDefaultScaleX());
        this.defineSynchedEntityData(builder, SynchedDataIndex.SCALE_Y, this.getDefaultScaleY());
        this.defineSynchedEntityData(builder, SynchedDataIndex.SCALE_Z, this.getDefaultScaleZ());
    }

    default public void addAdditionalScaleData(class_2487 compoundTag) {
        if (Objects.equals(this.getScaleX(), this.getDefaultScaleX()) && Objects.equals(this.getScaleY(), this.getDefaultScaleY()) && Objects.equals(this.getScaleZ(), this.getDefaultScaleZ())) {
            return;
        }
        compoundTag.method_10566(EASY_NPC_DATA_SCALE_DATA_TAG, (class_2520)CompoundTagUtils.writeScale(this.getScaleX().floatValue(), this.getScaleY().floatValue(), this.getScaleZ().floatValue()));
    }

    default public void readAdditionalScaleData(class_2487 compoundTag) {
        if (!compoundTag.method_10545(EASY_NPC_DATA_SCALE_DATA_TAG)) {
            return;
        }
        CustomScale customScale = CompoundTagUtils.readCustomScale(compoundTag.method_10562(EASY_NPC_DATA_SCALE_DATA_TAG));
        if (customScale.x() > 0.0f) {
            this.setScaleX(Float.valueOf(customScale.x()));
        }
        if (customScale.y() > 0.0f) {
            this.setScaleY(Float.valueOf(customScale.y()));
        }
        if (customScale.z() > 0.0f) {
            this.setScaleZ(Float.valueOf(customScale.z()));
        }
    }
}

