/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_6025;

public interface OwnerData<T extends class_1314>
extends EasyNPC<T>,
class_6025 {
    public static final String DATA_OWNER_TAG = "Owner";

    public static void registerSyncedOwnerData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("- Registering Synched Owner Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.OWNER_UUID, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13313));
    }

    default public UUID method_6139() {
        Optional ownerUUID = (Optional)this.getSynchedEntityData(SynchedDataIndex.OWNER_UUID);
        return ownerUUID.orElse(null);
    }

    default public void setOwnerUUID(UUID uuid) {
        this.setSynchedEntityData(SynchedDataIndex.OWNER_UUID, Optional.ofNullable(uuid));
    }

    default public boolean hasOwner() {
        return this.method_6139() != null;
    }

    default public boolean isOwnedBy(class_1309 livingEntity) {
        return livingEntity != null && this.hasOwner() && livingEntity.method_5667().equals(this.method_6139());
    }

    default public class_1309 method_35057() {
        class_1937 level = this.getLevel();
        if (level == null) {
            return null;
        }
        try {
            UUID uuid = this.method_6139();
            return uuid == null ? null : level.method_18470(uuid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    default public void setOwner(class_1309 owner) {
        if (owner != null) {
            this.setOwnerUUID(owner.method_5667());
        } else {
            this.setOwnerUUID(null);
        }
    }

    default public String getOwnerName() {
        class_1309 owner = this.method_35057();
        return owner == null ? "" : owner.method_5477().getString();
    }

    default public boolean isOwner(class_3222 serverPlayer) {
        return serverPlayer != null && this.isOwner(serverPlayer.method_5667());
    }

    default public boolean isOwner(UUID uuid) {
        return uuid != null && this.hasOwner() && uuid.equals(this.method_6139());
    }

    default public void defineSynchedOwnerData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.OWNER_UUID, Optional.empty());
    }

    default public void addAdditionalOwnerData(class_2487 compoundTag) {
        if (this.method_6139() != null) {
            compoundTag.method_25927(DATA_OWNER_TAG, this.method_6139());
        }
    }

    default public void readAdditionalOwnerData(class_2487 compoundTag) {
        if (compoundTag.method_25928(DATA_OWNER_TAG)) {
            UUID uuid = compoundTag.method_25926(DATA_OWNER_TAG);
            this.setOwnerUUID(uuid);
        }
    }
}

