/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;

public interface ModelRotationData<T extends class_1314>
extends EasyNPC<T> {
    public static final CustomRotation DEFAULT_MODEL_PART_ROTATION = new CustomRotation(0.0f, 0.0f, 0.0f);
    public static final String EASY_NPC_DATA_MODEL_LOCK_TAG = "Lock";
    public static final String EASY_NPC_DATA_MODEL_ROTATION_TAG = "Rotation";

    public static void registerSyncedModelRotationData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("- Registering Synched Model Rotation Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.MODEL_LOCK_ROTATION, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13323));
        map.put(SynchedDataIndex.MODEL_HEAD_ROTATION, class_2945.method_12791(entityClass, EntityDataSerializersManager.ROTATION));
        map.put(SynchedDataIndex.MODEL_BODY_ROTATION, class_2945.method_12791(entityClass, EntityDataSerializersManager.ROTATION));
        map.put(SynchedDataIndex.MODEL_ARMS_ROTATION, class_2945.method_12791(entityClass, EntityDataSerializersManager.ROTATION));
        map.put(SynchedDataIndex.MODEL_LEFT_ARM_ROTATION, class_2945.method_12791(entityClass, EntityDataSerializersManager.ROTATION));
        map.put(SynchedDataIndex.MODEL_RIGHT_ARM_ROTATION, class_2945.method_12791(entityClass, EntityDataSerializersManager.ROTATION));
        map.put(SynchedDataIndex.MODEL_LEFT_LEG_ROTATION, class_2945.method_12791(entityClass, EntityDataSerializersManager.ROTATION));
        map.put(SynchedDataIndex.MODEL_RIGHT_LEG_ROTATION, class_2945.method_12791(entityClass, EntityDataSerializersManager.ROTATION));
        map.put(SynchedDataIndex.MODEL_ROOT_ROTATION, class_2945.method_12791(entityClass, EntityDataSerializersManager.ROTATION));
    }

    public boolean hasHeadModelPart();

    public boolean hasBodyModelPart();

    public boolean hasArmsModelPart();

    public boolean hasLeftArmModelPart();

    public boolean hasRightArmModelPart();

    public boolean hasLeftLegModelPart();

    public boolean hasRightLegModelPart();

    default public CustomRotation getModelPartRotation(ModelPart modelPart) {
        return switch (modelPart) {
            case ModelPart.HEAD -> this.getModelHeadRotation();
            case ModelPart.BODY -> this.getModelBodyRotation();
            case ModelPart.ARMS -> this.getModelArmsRotation();
            case ModelPart.LEFT_ARM -> this.getModelLeftArmRotation();
            case ModelPart.RIGHT_ARM -> this.getModelRightArmRotation();
            case ModelPart.LEFT_LEG -> this.getModelLeftLegRotation();
            case ModelPart.RIGHT_LEG -> this.getModelRightLegRotation();
            default -> DEFAULT_MODEL_PART_ROTATION;
        };
    }

    default public void setModelPartRotation(ModelPart modelPart, CustomRotation rotation) {
        switch (modelPart) {
            case HEAD: {
                this.setModelHeadRotation(rotation);
                break;
            }
            case BODY: {
                this.setModelBodyRotation(rotation);
                break;
            }
            case ARMS: {
                this.setModelArmsRotation(rotation);
                break;
            }
            case LEFT_ARM: {
                this.setModelLeftArmRotation(rotation);
                break;
            }
            case RIGHT_ARM: {
                this.setModelRightArmRotation(rotation);
                break;
            }
            case LEFT_LEG: {
                this.setModelLeftLegRotation(rotation);
                break;
            }
            case RIGHT_LEG: {
                this.setModelRightLegRotation(rotation);
                break;
            }
            case ROOT: {
                this.setModelRootRotation(rotation);
                break;
            }
            default: {
                log.error("Invalid rotation model part {} for {}", (Object)modelPart, (Object)this);
            }
        }
    }

    default public boolean hasChangedModelRotation() {
        return this.hasHeadModelPart() && this.getModelHeadRotation().hasChanged() || this.hasBodyModelPart() && this.getModelBodyRotation().hasChanged() || this.hasArmsModelPart() && this.getModelArmsRotation().hasChanged() || this.hasLeftArmModelPart() && this.getModelLeftArmRotation().hasChanged() || this.hasRightArmModelPart() && this.getModelRightArmRotation().hasChanged() || this.hasLeftLegModelPart() && this.getModelLeftLegRotation().hasChanged() || this.hasRightLegModelPart() && this.getModelRightLegRotation().hasChanged();
    }

    default public boolean getModelLockRotation() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_LOCK_ROTATION);
    }

    default public void setModelLockRotation(boolean modelLockRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LOCK_ROTATION, modelLockRotation);
    }

    default public CustomRotation getModelHeadRotation() {
        return (CustomRotation)this.getSynchedEntityData(SynchedDataIndex.MODEL_HEAD_ROTATION);
    }

    default public void setModelHeadRotation(CustomRotation modelHeadRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_HEAD_ROTATION, modelHeadRotation);
    }

    default public CustomRotation getModelBodyRotation() {
        return (CustomRotation)this.getSynchedEntityData(SynchedDataIndex.MODEL_BODY_ROTATION);
    }

    default public void setModelBodyRotation(CustomRotation modelBodyRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_BODY_ROTATION, modelBodyRotation);
    }

    default public CustomRotation getModelArmsRotation() {
        return (CustomRotation)this.getSynchedEntityData(SynchedDataIndex.MODEL_ARMS_ROTATION);
    }

    default public void setModelArmsRotation(CustomRotation modelArmsRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_ARMS_ROTATION, modelArmsRotation);
    }

    default public CustomRotation getModelLeftArmRotation() {
        return (CustomRotation)this.getSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_ROTATION);
    }

    default public void setModelLeftArmRotation(CustomRotation modelLeftArmRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_ROTATION, modelLeftArmRotation);
    }

    default public CustomRotation getModelRightArmRotation() {
        return (CustomRotation)this.getSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_ROTATION);
    }

    default public void setModelRightArmRotation(CustomRotation modelRightArmRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_ROTATION, modelRightArmRotation);
    }

    default public CustomRotation getModelLeftLegRotation() {
        return (CustomRotation)this.getSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_ROTATION);
    }

    default public void setModelLeftLegRotation(CustomRotation modelLeftLegRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_ROTATION, modelLeftLegRotation);
    }

    default public CustomRotation getModelRightLegRotation() {
        return (CustomRotation)this.getSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_ROTATION);
    }

    default public void setModelRightLegRotation(CustomRotation modelRightLegRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_ROTATION, modelRightLegRotation);
    }

    default public CustomRotation getModelRootRotation() {
        return (CustomRotation)this.getSynchedEntityData(SynchedDataIndex.MODEL_ROOT_ROTATION);
    }

    default public void setModelRootRotation(CustomRotation modelRootRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_ROOT_ROTATION, modelRootRotation);
    }

    default public void defineSynchedModelRotationData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_LOCK_ROTATION, false);
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_HEAD_ROTATION, new CustomRotation(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_BODY_ROTATION, new CustomRotation(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_ARMS_ROTATION, new CustomRotation(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_LEFT_ARM_ROTATION, new CustomRotation(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_RIGHT_ARM_ROTATION, new CustomRotation(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_LEFT_LEG_ROTATION, new CustomRotation(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_RIGHT_LEG_ROTATION, new CustomRotation(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_ROOT_ROTATION, new CustomRotation(0.0f, 0.0f, 0.0f));
    }

    default public void addAdditionalModelRotationData(class_2487 compoundTag) {
        class_2487 rotationsTag = new class_2487();
        if (this.getModelLockRotation()) {
            rotationsTag.method_10556(EASY_NPC_DATA_MODEL_LOCK_TAG, this.getModelLockRotation());
        }
        if (this.hasHeadModelPart() && this.getModelHeadRotation() != null && this.getModelHeadRotation().hasChanged()) {
            rotationsTag.method_10566(ModelPart.HEAD.getTagName(), (class_2520)this.getModelHeadRotation().save());
        }
        if (this.hasBodyModelPart() && this.getModelBodyRotation() != null && this.getModelBodyRotation().hasChanged()) {
            rotationsTag.method_10566(ModelPart.BODY.getTagName(), (class_2520)this.getModelBodyRotation().save());
        }
        if (this.hasArmsModelPart() && this.getModelArmsRotation() != null && this.getModelArmsRotation().hasChanged()) {
            rotationsTag.method_10566(ModelPart.ARMS.getTagName(), (class_2520)this.getModelArmsRotation().save());
        }
        if (this.hasLeftArmModelPart() && this.getModelLeftArmRotation() != null && this.getModelLeftArmRotation().hasChanged()) {
            rotationsTag.method_10566(ModelPart.LEFT_ARM.getTagName(), (class_2520)this.getModelLeftArmRotation().save());
        }
        if (this.hasRightArmModelPart() && this.getModelRightArmRotation() != null && this.getModelRightArmRotation().hasChanged()) {
            rotationsTag.method_10566(ModelPart.RIGHT_ARM.getTagName(), (class_2520)this.getModelRightArmRotation().save());
        }
        if (this.hasLeftLegModelPart() && this.getModelLeftLegRotation() != null && this.getModelLeftLegRotation().hasChanged()) {
            rotationsTag.method_10566(ModelPart.LEFT_LEG.getTagName(), (class_2520)this.getModelLeftLegRotation().save());
        }
        if (this.hasRightLegModelPart() && this.getModelRightLegRotation() != null && this.getModelRightLegRotation().hasChanged()) {
            rotationsTag.method_10566(ModelPart.RIGHT_LEG.getTagName(), (class_2520)this.getModelRightLegRotation().save());
        }
        if (this.getModelRootRotation() != null && this.getModelRootRotation().hasChanged()) {
            rotationsTag.method_10566(ModelPart.ROOT.getTagName(), (class_2520)this.getModelRootRotation().save());
        }
        compoundTag.method_10566(EASY_NPC_DATA_MODEL_ROTATION_TAG, (class_2520)rotationsTag);
    }

    default public void readAdditionalModelRotationData(class_2487 compoundTag) {
        if (!compoundTag.method_10545(EASY_NPC_DATA_MODEL_ROTATION_TAG)) {
            return;
        }
        class_2487 rotationsTag = compoundTag.method_10562(EASY_NPC_DATA_MODEL_ROTATION_TAG);
        if (rotationsTag.method_10545(EASY_NPC_DATA_MODEL_LOCK_TAG)) {
            this.setModelLockRotation(rotationsTag.method_10577(EASY_NPC_DATA_MODEL_LOCK_TAG));
        }
        if (rotationsTag.method_10545(ModelPart.HEAD.getTagName())) {
            this.setModelHeadRotation(new CustomRotation(rotationsTag.method_10554(ModelPart.HEAD.getTagName(), 5)));
        }
        if (rotationsTag.method_10545(ModelPart.BODY.getTagName())) {
            this.setModelBodyRotation(new CustomRotation(rotationsTag.method_10554(ModelPart.BODY.getTagName(), 5)));
        }
        if (rotationsTag.method_10545(ModelPart.ARMS.getTagName())) {
            this.setModelArmsRotation(new CustomRotation(rotationsTag.method_10554(ModelPart.ARMS.getTagName(), 5)));
        }
        if (rotationsTag.method_10545(ModelPart.LEFT_ARM.getTagName())) {
            this.setModelLeftArmRotation(new CustomRotation(rotationsTag.method_10554(ModelPart.LEFT_ARM.getTagName(), 5)));
        }
        if (rotationsTag.method_10545(ModelPart.RIGHT_ARM.getTagName())) {
            this.setModelRightArmRotation(new CustomRotation(rotationsTag.method_10554(ModelPart.RIGHT_ARM.getTagName(), 5)));
        }
        if (rotationsTag.method_10545(ModelPart.LEFT_LEG.getTagName())) {
            this.setModelLeftLegRotation(new CustomRotation(rotationsTag.method_10554(ModelPart.LEFT_LEG.getTagName(), 5)));
        }
        if (rotationsTag.method_10545(ModelPart.RIGHT_LEG.getTagName())) {
            this.setModelRightLegRotation(new CustomRotation(rotationsTag.method_10554(ModelPart.RIGHT_LEG.getTagName(), 5)));
        }
        if (rotationsTag.method_10545(ModelPart.ROOT.getTagName())) {
            this.setModelRootRotation(new CustomRotation(rotationsTag.method_10554(ModelPart.ROOT.getTagName(), 5)));
        }
    }
}

