/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2945;

public interface ModelPositionData<T extends class_1314>
extends EasyNPC<T> {
    public static final CustomPosition DEFAULT_MODEL_PART_POSITION = new CustomPosition(0.0f, 0.0f, 0.0f);
    public static final String EASY_NPC_DATA_MODEL_POSITION_TAG = "Position";

    public static void registerSyncedModelPositionData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("- Registering Synched Model Position Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.MODEL_HEAD_POSITION, class_2945.method_12791(entityClass, EntityDataSerializersManager.POSITION));
        map.put(SynchedDataIndex.MODEL_BODY_POSITION, class_2945.method_12791(entityClass, EntityDataSerializersManager.POSITION));
        map.put(SynchedDataIndex.MODEL_ARMS_POSITION, class_2945.method_12791(entityClass, EntityDataSerializersManager.POSITION));
        map.put(SynchedDataIndex.MODEL_LEFT_ARM_POSITION, class_2945.method_12791(entityClass, EntityDataSerializersManager.POSITION));
        map.put(SynchedDataIndex.MODEL_RIGHT_ARM_POSITION, class_2945.method_12791(entityClass, EntityDataSerializersManager.POSITION));
        map.put(SynchedDataIndex.MODEL_LEFT_LEG_POSITION, class_2945.method_12791(entityClass, EntityDataSerializersManager.POSITION));
        map.put(SynchedDataIndex.MODEL_RIGHT_LEG_POSITION, class_2945.method_12791(entityClass, EntityDataSerializersManager.POSITION));
    }

    public boolean hasHeadModelPart();

    public boolean hasBodyModelPart();

    public boolean hasArmsModelPart();

    public boolean hasLeftArmModelPart();

    public boolean hasRightArmModelPart();

    public boolean hasLeftLegModelPart();

    public boolean hasRightLegModelPart();

    default public CustomPosition getModelPartPosition(ModelPart modelPart) {
        return switch (modelPart) {
            case ModelPart.HEAD -> this.getModelHeadPosition();
            case ModelPart.BODY -> this.getModelBodyPosition();
            case ModelPart.ARMS -> this.getModelArmsPosition();
            case ModelPart.LEFT_ARM -> this.getModelLeftArmPosition();
            case ModelPart.RIGHT_ARM -> this.getModelRightArmPosition();
            case ModelPart.LEFT_LEG -> this.getModelLeftLegPosition();
            case ModelPart.RIGHT_LEG -> this.getModelRightLegPosition();
            default -> DEFAULT_MODEL_PART_POSITION;
        };
    }

    default public void setModelPartPosition(ModelPart modelPart, CustomPosition position) {
        if (modelPart == ModelPart.ROOT) {
            return;
        }
        switch (modelPart) {
            case HEAD: {
                this.setModelHeadPosition(position);
                break;
            }
            case BODY: {
                this.setModelBodyPosition(position);
                break;
            }
            case ARMS: {
                this.setModelArmsPosition(position);
                break;
            }
            case LEFT_ARM: {
                this.setModelLeftArmPosition(position);
                break;
            }
            case RIGHT_ARM: {
                this.setModelRightArmPosition(position);
                break;
            }
            case LEFT_LEG: {
                this.setModelLeftLegPosition(position);
                break;
            }
            case RIGHT_LEG: {
                this.setModelRightLegPosition(position);
                break;
            }
            default: {
                log.error("Invalid position model part {} for {}", (Object)modelPart, (Object)this);
            }
        }
    }

    default public CustomPosition getModelHeadPosition() {
        return (CustomPosition)this.getSynchedEntityData(SynchedDataIndex.MODEL_HEAD_POSITION);
    }

    default public void setModelHeadPosition(CustomPosition modelHeadPosition) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_HEAD_POSITION, modelHeadPosition);
    }

    default public CustomPosition getModelBodyPosition() {
        return (CustomPosition)this.getSynchedEntityData(SynchedDataIndex.MODEL_BODY_POSITION);
    }

    default public void setModelBodyPosition(CustomPosition modelBodyPosition) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_BODY_POSITION, modelBodyPosition);
    }

    default public CustomPosition getModelArmsPosition() {
        return (CustomPosition)this.getSynchedEntityData(SynchedDataIndex.MODEL_ARMS_POSITION);
    }

    default public void setModelArmsPosition(CustomPosition modelArmsPosition) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_ARMS_POSITION, modelArmsPosition);
    }

    default public CustomPosition getModelLeftArmPosition() {
        return (CustomPosition)this.getSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_POSITION);
    }

    default public void setModelLeftArmPosition(CustomPosition modelLeftArmPosition) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_POSITION, modelLeftArmPosition);
    }

    default public CustomPosition getModelRightArmPosition() {
        return (CustomPosition)this.getSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_POSITION);
    }

    default public void setModelRightArmPosition(CustomPosition modelRightArmPosition) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_POSITION, modelRightArmPosition);
    }

    default public CustomPosition getModelLeftLegPosition() {
        return (CustomPosition)this.getSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_POSITION);
    }

    default public void setModelLeftLegPosition(CustomPosition modelLeftLegPosition) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_POSITION, modelLeftLegPosition);
    }

    default public CustomPosition getModelRightLegPosition() {
        return (CustomPosition)this.getSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_POSITION);
    }

    default public void setModelRightLegPosition(CustomPosition modelRightLegPosition) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_POSITION, modelRightLegPosition);
    }

    default public boolean hasChangedModelPosition() {
        return this.hasHeadModelPart() && this.getModelHeadPosition().hasChanged() || this.hasBodyModelPart() && this.getModelBodyPosition().hasChanged() || this.hasArmsModelPart() && this.getModelArmsPosition().hasChanged() || this.hasLeftArmModelPart() && this.getModelLeftArmPosition().hasChanged() || this.hasRightArmModelPart() && this.getModelRightArmPosition().hasChanged() || this.hasLeftLegModelPart() && this.getModelLeftLegPosition().hasChanged() || this.hasRightLegModelPart() && this.getModelRightLegPosition().hasChanged();
    }

    default public void defineSynchedModelPositionData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_HEAD_POSITION, new CustomPosition(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_BODY_POSITION, new CustomPosition(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_ARMS_POSITION, new CustomPosition(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_LEFT_ARM_POSITION, new CustomPosition(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_RIGHT_ARM_POSITION, new CustomPosition(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_LEFT_LEG_POSITION, new CustomPosition(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_RIGHT_LEG_POSITION, new CustomPosition(0.0f, 0.0f, 0.0f));
    }

    default public void addAdditionalModelPositionData(class_2487 compoundTag) {
        class_2487 positionsTag = new class_2487();
        if (this.hasHeadModelPart() && this.getModelHeadPosition() != null && this.getModelHeadPosition().hasChanged()) {
            positionsTag.method_10566(ModelPart.HEAD.getTagName(), (class_2520)this.getModelHeadPosition().save());
        }
        if (this.hasBodyModelPart() && this.getModelBodyPosition() != null && this.getModelBodyPosition().hasChanged()) {
            positionsTag.method_10566(ModelPart.BODY.getTagName(), (class_2520)this.getModelBodyPosition().save());
        }
        if (this.hasArmsModelPart() && this.getModelArmsPosition() != null && this.getModelArmsPosition().hasChanged()) {
            positionsTag.method_10566(ModelPart.ARMS.getTagName(), (class_2520)this.getModelArmsPosition().save());
        }
        if (this.hasLeftArmModelPart() && this.getModelLeftArmPosition() != null && this.getModelLeftArmPosition().hasChanged()) {
            positionsTag.method_10566(ModelPart.LEFT_ARM.getTagName(), (class_2520)this.getModelLeftArmPosition().save());
        }
        if (this.hasRightArmModelPart() && this.getModelRightArmPosition() != null && this.getModelRightArmPosition().hasChanged()) {
            positionsTag.method_10566(ModelPart.RIGHT_ARM.getTagName(), (class_2520)this.getModelRightArmPosition().save());
        }
        if (this.hasLeftLegModelPart() && this.getModelLeftLegPosition() != null && this.getModelLeftLegPosition().hasChanged()) {
            positionsTag.method_10566(ModelPart.LEFT_LEG.getTagName(), (class_2520)this.getModelLeftLegPosition().save());
        }
        if (this.hasRightLegModelPart() && this.getModelRightLegPosition() != null && this.getModelRightLegPosition().hasChanged()) {
            positionsTag.method_10566(ModelPart.RIGHT_LEG.getTagName(), (class_2520)this.getModelRightLegPosition().save());
        }
        compoundTag.method_10566(EASY_NPC_DATA_MODEL_POSITION_TAG, (class_2520)positionsTag);
    }

    default public void readAdditionalModelPositionData(class_2487 compoundTag) {
        if (!compoundTag.method_10545(EASY_NPC_DATA_MODEL_POSITION_TAG)) {
            return;
        }
        class_2487 positionTag = compoundTag.method_10562(EASY_NPC_DATA_MODEL_POSITION_TAG);
        if (positionTag.method_10545(ModelPart.HEAD.getTagName())) {
            this.setModelHeadPosition(new CustomPosition(positionTag.method_10554(ModelPart.HEAD.getTagName(), 5)));
        }
        if (positionTag.method_10545(ModelPart.BODY.getTagName())) {
            this.setModelBodyPosition(new CustomPosition(positionTag.method_10554(ModelPart.BODY.getTagName(), 5)));
        }
        if (positionTag.method_10545(ModelPart.ARMS.getTagName())) {
            this.setModelArmsPosition(new CustomPosition(positionTag.method_10554(ModelPart.ARMS.getTagName(), 5)));
        }
        if (positionTag.method_10545(ModelPart.LEFT_ARM.getTagName())) {
            this.setModelLeftArmPosition(new CustomPosition(positionTag.method_10554(ModelPart.LEFT_ARM.getTagName(), 5)));
        }
        if (positionTag.method_10545(ModelPart.RIGHT_ARM.getTagName())) {
            this.setModelRightArmPosition(new CustomPosition(positionTag.method_10554(ModelPart.RIGHT_ARM.getTagName(), 5)));
        }
        if (positionTag.method_10545(ModelPart.LEFT_LEG.getTagName())) {
            this.setModelLeftLegPosition(new CustomPosition(positionTag.method_10554(ModelPart.LEFT_LEG.getTagName(), 5)));
        }
        if (positionTag.method_10545(ModelPart.RIGHT_LEG.getTagName())) {
            this.setModelRightLegPosition(new CustomPosition(positionTag.method_10554(ModelPart.RIGHT_LEG.getTagName(), 5)));
        }
    }
}

