/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.display.DisplayAttributeSet;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2945;

public interface DisplayAttributeData<E extends class_1314>
extends EasyNPC<E> {
    public static void registerSyncedDisplayAttributeData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("- Registering Synched Display Attribute Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, class_2945.method_12791(entityClass, EntityDataSerializersManager.DISPLAY_ATTRIBUTE_SET));
    }

    default public DisplayAttributeSet getDisplayAttributeSet() {
        return (DisplayAttributeSet)this.getSynchedEntityData(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET);
    }

    default public void setDisplayAttributeSet(DisplayAttributeSet displayAttributeSet) {
        this.setSynchedEntityData(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, displayAttributeSet);
    }

    default public void clearDisplayAttributeSet() {
        this.setSynchedEntityData(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, new DisplayAttributeSet());
    }

    default public void updateDisplayAttributeSet() {
        DisplayAttributeSet displayAttributeSet = this.getDisplayAttributeSet();
        if (displayAttributeSet != null) {
            this.clearDisplayAttributeSet();
            this.setDisplayAttributeSet(displayAttributeSet);
        }
    }

    default public boolean hasDisplayAttribute(DisplayAttributeType displayAttributeType) {
        DisplayAttributeSet displayAttributeSet = this.getDisplayAttributeSet();
        if (displayAttributeSet != null) {
            return displayAttributeSet.hasDisplayAttribute(displayAttributeType);
        }
        return false;
    }

    default public boolean getDisplayBooleanAttribute(DisplayAttributeType displayAttributeType) {
        DisplayAttributeSet displayAttributeSet = this.getDisplayAttributeSet();
        if (displayAttributeSet != null) {
            return displayAttributeSet.getBooleanValue(displayAttributeType);
        }
        return false;
    }

    default public int getDisplayIntAttribute(DisplayAttributeType displayAttributeType) {
        DisplayAttributeSet displayAttributeSet = this.getDisplayAttributeSet();
        if (displayAttributeSet != null) {
            return displayAttributeSet.getIntValue(displayAttributeType);
        }
        return 0;
    }

    default public void defineSynchedDisplayAttributeData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, new DisplayAttributeSet());
    }

    default public void readAdditionalDisplayAttributeData(class_2487 compoundTag) {
        if (compoundTag.method_10545("DisplayAttributeSet")) {
            DisplayAttributeSet displayAttributeSet = new DisplayAttributeSet(compoundTag);
            this.setDisplayAttributeSet(displayAttributeSet);
        }
    }

    default public void addAdditionalDisplayAttributeData(class_2487 compoundTag) {
        DisplayAttributeSet displayAttributeSet = this.getDisplayAttributeSet();
        if (displayAttributeSet != null) {
            displayAttributeSet.save(compoundTag);
        }
    }
}

