/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderData;
import de.markusbordihn.easynpc.menu.MenuManager;
import net.minecraft.class_1314;
import net.minecraft.class_3222;

public interface ConfigurationData<T extends class_1314>
extends EasyNPC<T> {
    default public void openMainConfigurationMenu(class_3222 serverPlayer) {
        if (this.supportsConfiguration()) {
            MenuManager.getMenuHandler().openConfigurationMenu(ConfigurationType.MAIN, serverPlayer, this, 0);
        } else {
            log.error("Configuration is not supported for {} ...", (Object)this);
        }
    }

    default public boolean supportsConfigurationType(ConfigurationType configurationType) {
        RenderData renderData = this.getEasyNPCRenderData();
        boolean isCustomModel = renderData != null && renderData.getRenderDataSet() != null && renderData.getRenderDataSet().getRenderType() != RenderType.DEFAULT;
        return switch (configurationType) {
            case ConfigurationType.MAIN -> this.supportsConfiguration();
            case ConfigurationType.DEFAULT_MODEL, ConfigurationType.CUSTOM_MODEL -> this.supportsChangeModelConfiguration();
            case ConfigurationType.POSE -> {
                if (!isCustomModel && this.supportsPoseConfiguration()) {
                    yield true;
                }
                yield false;
            }
            case ConfigurationType.DEFAULT_POSE -> this.supportsDefaultPoseConfiguration();
            case ConfigurationType.ADVANCED_POSE -> this.supportsAdvancedPoseConfiguration();
            case ConfigurationType.CUSTOM_POSE -> this.supportsCustomPoseConfiguration();
            case ConfigurationType.SCALING -> {
                if (!isCustomModel && this.supportsScalingConfiguration()) {
                    yield true;
                }
                yield false;
            }
            case ConfigurationType.SKIN -> {
                if (!isCustomModel && this.supportsSkinConfiguration()) {
                    yield true;
                }
                yield false;
            }
            case ConfigurationType.DEFAULT_ROTATION -> this.supportsDefaultRotationConfiguration();
            case ConfigurationType.NONE_SKIN -> this.supportsNoneSkinConfiguration();
            case ConfigurationType.DEFAULT_SKIN -> this.supportsDefaultSkinConfiguration();
            case ConfigurationType.URL_SKIN -> this.supportsUrlSkinConfiguration();
            case ConfigurationType.PLAYER_SKIN -> this.supportsPlayerSkinConfiguration();
            case ConfigurationType.CUSTOM_SKIN -> this.supportsCustomSkinConfiguration();
            default -> true;
        };
    }

    default public boolean supportsConfiguration() {
        return true;
    }

    default public boolean supportsChangeModelConfiguration() {
        return true;
    }

    default public boolean supportsPoseConfiguration() {
        return true;
    }

    default public boolean supportsDefaultPoseConfiguration() {
        return true;
    }

    default public boolean supportsAdvancedPoseConfiguration() {
        return true;
    }

    default public boolean supportsCustomPoseConfiguration() {
        return true;
    }

    default public boolean supportsScalingConfiguration() {
        return true;
    }

    default public boolean supportsDefaultRotationConfiguration() {
        return true;
    }

    default public boolean supportsSkinConfiguration() {
        return true;
    }

    default public boolean supportsNoneSkinConfiguration() {
        return true;
    }

    default public boolean supportsDefaultSkinConfiguration() {
        return true;
    }

    default public boolean supportsUrlSkinConfiguration() {
        return true;
    }

    default public boolean supportsPlayerSkinConfiguration() {
        return false;
    }

    default public boolean supportsCustomSkinConfiguration() {
        return true;
    }
}

