/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.sound;

import de.markusbordihn.easynpc.data.sound.SoundDataEntry;
import de.markusbordihn.easynpc.data.sound.SoundType;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class SoundDataSet {
    public static final String DATA_SOUND_DATA_SET_TAG = "SoundDataSet";
    public static final class_9139<class_9129, SoundDataSet> STREAM_CODEC = new class_9139<class_9129, SoundDataSet>(){

        public SoundDataSet decode(class_9129 registryFriendlyByteBuf) {
            return new SoundDataSet(registryFriendlyByteBuf.method_10798());
        }

        public void encode(class_9129 registryFriendlyByteBuf, SoundDataSet soundDataSet) {
            registryFriendlyByteBuf.method_10794((class_2520)soundDataSet.createTag());
        }
    };
    private final Map<SoundType, SoundDataEntry> soundDataEntryMap = new EnumMap<SoundType, SoundDataEntry>(SoundType.class);

    public SoundDataSet() {
    }

    public SoundDataSet(class_2487 compoundTag) {
        this.load(compoundTag);
    }

    public boolean hasSound(SoundType type) {
        return this.soundDataEntryMap.containsKey((Object)type);
    }

    public void addSound(SoundType type, class_3414 soundEvent) {
        this.addSound(type, soundEvent.method_14833());
    }

    public void addSound(SoundType type, class_2960 resourceLocation) {
        this.soundDataEntryMap.put(type, new SoundDataEntry(type, resourceLocation));
    }

    public boolean isEmpty() {
        return this.soundDataEntryMap.isEmpty();
    }

    public SoundDataEntry getSound(SoundType type) {
        return this.soundDataEntryMap.get((Object)type);
    }

    public void load(class_2487 compoundTag) {
        if (!compoundTag.method_10545(DATA_SOUND_DATA_SET_TAG)) {
            return;
        }
        this.soundDataEntryMap.clear();
        class_2499 soundListTag = compoundTag.method_10554(DATA_SOUND_DATA_SET_TAG, 10);
        for (int i = 0; i < soundListTag.size(); ++i) {
            class_2487 soundDataTag = soundListTag.method_10602(i);
            SoundDataEntry soundDataEntry = new SoundDataEntry(soundDataTag);
            this.soundDataEntryMap.put(soundDataEntry.getType(), soundDataEntry);
        }
    }

    public class_2487 save(class_2487 compoundTag) {
        class_2499 soundListTag = new class_2499();
        for (Map.Entry<SoundType, SoundDataEntry> entry : this.soundDataEntryMap.entrySet()) {
            SoundDataEntry soundDataEntry = entry.getValue();
            soundListTag.add((Object)soundDataEntry.createTag());
        }
        compoundTag.method_10566(DATA_SOUND_DATA_SET_TAG, (class_2520)soundListTag);
        return compoundTag;
    }

    public class_2487 createTag() {
        return this.save(new class_2487());
    }
}

