/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.sound;

import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoundDataEntry {
    public static final String DATA_SOUND_ENABLED_TAG = "Enabled";
    public static final String DATA_SOUND_NAME_TAG = "Name";
    public static final String DATA_SOUND_PITCH_TAG = "Pitch";
    public static final String DATA_SOUND_TYPE = "Type";
    public static final String DATA_SOUND_VOLUME_TAG = "Volume";
    public static final boolean DEFAULT_ENABLED = true;
    public static final float DEFAULT_PITCH = 1.0f;
    public static final float DEFAULT_VOLUME = 0.75f;
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private boolean enabled = true;
    private float pitch = 1.0f;
    private class_3414 soundEvent;
    private SoundType type;
    private float volume = 0.75f;

    public SoundDataEntry(SoundType type, class_2960 location) {
        this(type, location, 0.75f, 1.0f, true);
    }

    public SoundDataEntry(SoundType type, class_2960 location, float volume, float pitch, boolean enabled) {
        this.type = type;
        this.volume = volume;
        this.pitch = pitch;
        this.enabled = enabled;
        this.soundEvent = class_7923.field_41172.method_17966(location).orElseGet(() -> class_3414.method_47908((class_2960)location));
    }

    public SoundDataEntry(class_2487 compoundTag) {
        this.load(compoundTag);
    }

    public SoundType getType() {
        return this.type;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public class_3414 getSoundEvent() {
        return this.soundEvent;
    }

    public void load(class_2487 compoundTag) {
        this.type = SoundType.valueOf(compoundTag.method_10558(DATA_SOUND_TYPE));
        if (compoundTag.method_10545(DATA_SOUND_NAME_TAG)) {
            class_2960 location = CompoundTagUtils.readResourceLocation(compoundTag, DATA_SOUND_NAME_TAG);
            this.soundEvent = class_7923.field_41172.method_17966(location).orElseGet(() -> class_3414.method_47908((class_2960)location));
        } else {
            log.error("Unable to load sound event for type {} and {}", (Object)this.type.name(), (Object)compoundTag);
            this.soundEvent = class_3417.field_14737;
        }
        if (compoundTag.method_10545(DATA_SOUND_VOLUME_TAG)) {
            this.volume = compoundTag.method_10583(DATA_SOUND_VOLUME_TAG);
        }
        if (compoundTag.method_10545(DATA_SOUND_PITCH_TAG)) {
            this.pitch = compoundTag.method_10583(DATA_SOUND_PITCH_TAG);
        }
        if (compoundTag.method_10545(DATA_SOUND_ENABLED_TAG)) {
            this.enabled = compoundTag.method_10577(DATA_SOUND_ENABLED_TAG);
        }
    }

    public class_2487 save(class_2487 compoundTag) {
        compoundTag.method_10582(DATA_SOUND_TYPE, this.type.name());
        compoundTag.method_10582(DATA_SOUND_NAME_TAG, this.soundEvent.method_14833().toString());
        if (this.volume != 0.75f) {
            compoundTag.method_10548(DATA_SOUND_VOLUME_TAG, this.volume);
        }
        if (this.pitch != 1.0f) {
            compoundTag.method_10548(DATA_SOUND_PITCH_TAG, this.pitch);
        }
        if (!this.enabled) {
            compoundTag.method_10556(DATA_SOUND_ENABLED_TAG, this.enabled);
        }
        return compoundTag;
    }

    public class_2487 createTag() {
        return this.save(new class_2487());
    }
}

